/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.FrameSO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;

public class FrameSO3TrajectoryPoint
implements FrameSO3TrajectoryPointBasics {
    private final FrameSO3Waypoint so3Waypoint = new FrameSO3Waypoint();
    private double time;

    public FrameSO3TrajectoryPoint() {
    }

    public FrameSO3TrajectoryPoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameSO3TrajectoryPoint(double time, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setIncludingFrame(time, orientation, angularVelocity);
    }

    public FrameSO3TrajectoryPoint(FrameSO3TrajectoryPointBasics other) {
        this.setIncludingFrame(other);
    }

    public FrameSO3TrajectoryPoint(ReferenceFrame referenceFrame, SO3TrajectoryPointBasics other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    @Override
    public FrameQuaternionReadOnly getOrientation() {
        return this.so3Waypoint.getOrientation();
    }

    @Override
    public void setOrientation(double x, double y, double z, double s) {
        this.so3Waypoint.setOrientation(x, y, z, s);
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.so3Waypoint.getAngularVelocity();
    }

    @Override
    public void setAngularVelocity(double x, double y, double z) {
        this.so3Waypoint.setAngularVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.so3Waypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.so3Waypoint.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.so3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.so3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public String toString() {
        return "SO3 trajectory point: (time = " + WaypointToStringTools.formatTime(this.getTime()) + ", " + WaypointToStringTools.waypointToString(this.so3Waypoint) + ")";
    }
}

