/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.FrameEuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;

public class FrameEuclideanTrajectoryPoint
implements FrameEuclideanTrajectoryPointBasics {
    private final FrameEuclideanWaypoint euclideanWaypoint = new FrameEuclideanWaypoint();
    private double time;

    public FrameEuclideanTrajectoryPoint() {
    }

    public FrameEuclideanTrajectoryPoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameEuclideanTrajectoryPoint(double time, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setIncludingFrame(time, position, linearVelocity);
    }

    public FrameEuclideanTrajectoryPoint(FrameEuclideanTrajectoryPointBasics other) {
        this.setIncludingFrame(other);
    }

    public FrameEuclideanTrajectoryPoint(ReferenceFrame referenceFrame, EuclideanTrajectoryPointBasics other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.euclideanWaypoint.setPosition(x, y, z);
    }

    @Override
    public FrameVector3DReadOnly getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.euclideanWaypoint.setLinearVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.euclideanWaypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.euclideanWaypoint.applyInverseTransform(transform);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.euclideanWaypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.euclideanWaypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public String toString() {
        return "Euclidean trajectory point: (time = " + WaypointToStringTools.format(this.getTime()) + ", " + WaypointToStringTools.waypointToString(this.euclideanWaypoint) + ")";
    }
}

