/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.EuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.tools.WaypointToStringTools;

public class EuclideanTrajectoryPoint
implements EuclideanTrajectoryPointBasics {
    private final EuclideanWaypoint euclideanWaypoint = new EuclideanWaypoint();
    private double time;

    public EuclideanTrajectoryPoint() {
    }

    public EuclideanTrajectoryPoint(EuclideanTrajectoryPointBasics other) {
        this.set(other);
    }

    public EuclideanTrajectoryPoint(double time, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.set(time, position, linearVelocity);
    }

    @Override
    public Point3DReadOnly getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.euclideanWaypoint.setPosition(x, y, z);
    }

    @Override
    public Vector3DReadOnly getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    @Override
    public void setLinearVelocity(double x, double y, double z) {
        this.euclideanWaypoint.setLinearVelocity(x, y, z);
    }

    public void applyTransform(Transform transform) {
        this.euclideanWaypoint.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.euclideanWaypoint.applyInverseTransform(transform);
    }

    @Override
    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public String toString() {
        return "Euclidean trajectory point: (time = " + WaypointToStringTools.formatTime(this.getTime()) + ", " + WaypointToStringTools.waypointToString(this.euclideanWaypoint) + ")";
    }
}

