/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.interfaces;

import us.ihmc.robotics.math.trajectories.interfaces.DoubleTrajectoryGenerator;
import us.ihmc.robotics.time.TimeIntervalProvider;

public interface PolynomialReadOnly
extends TimeIntervalProvider,
DoubleTrajectoryGenerator {
    public int getMaximumNumberOfCoefficients();

    public int getNumberOfCoefficients();

    public double getCurrentTime();

    public double getCoefficient(int var1);

    public double[] getCoefficients();

    default public double getFinalTime() {
        return this.getTimeInterval().getEndTime();
    }

    default public double getInitialTime() {
        return this.getTimeInterval().getStartTime();
    }

    default public double getDuration() {
        return this.getTimeInterval().getDuration();
    }

    default public boolean timeIntervalContains(double timeToCheck, double EPSILON) {
        return this.getTimeInterval().epsilonContains(timeToCheck, EPSILON);
    }

    default public boolean timeIntervalContains(double timeToCheck) {
        return this.getTimeInterval().intervalContains(timeToCheck);
    }

    @Override
    default public boolean isDone() {
        return this.getCurrentTime() >= this.getTimeInterval().getEndTime();
    }
}

