/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.interfaces;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.trajectories.core.PolynomialTools;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialReadOnly;

public interface PolynomialBasics
extends PolynomialReadOnly {
    public void setConstraintRow(int var1, double var2, double var4, int var6);

    public void reshape(int var1);

    default public void setCoefficient(int idx, double value) {
        this.setIsConstraintMatrixUpToDate(false);
        this.setCoefficientUnsafe(idx, value);
    }

    public void setCoefficientUnsafe(int var1, double var2);

    @Override
    public double getCoefficient(int var1);

    public void setNumberOfCoefficients(int var1);

    public void setCurrentTime(double var1);

    public DMatrixRMaj getCoefficientsVector();

    public void solveForCoefficients();

    public void setIsConstraintMatrixUpToDate(boolean var1);

    public boolean isConstraintMatrixUpToDate();

    @Override
    default public void initialize() {
        this.solveForCoefficients();
        this.commitCoefficientsToMemory();
    }

    default public void set(PolynomialReadOnly other) {
        int index;
        this.reset();
        this.getTimeInterval().set(other.getTimeInterval());
        this.reshape(other.getNumberOfCoefficients());
        this.setNumberOfCoefficients(other.getNumberOfCoefficients());
        this.setCurrentTime(this.getCurrentTime());
        for (index = 0; index < other.getNumberOfCoefficients(); ++index) {
            this.setCoefficient(index, other.getCoefficient(index));
        }
        while (index < this.getMaximumNumberOfCoefficients()) {
            this.setCoefficient(index, Double.NaN);
            ++index;
        }
        this.setIsConstraintMatrixUpToDate(false);
    }

    default public void setDirectly(DMatrixRMaj coefficients) {
        int index;
        this.reshape(coefficients.getNumRows());
        for (index = 0; index < this.getNumberOfCoefficients(); ++index) {
            this.setCoefficient(index, coefficients.get(index, 0));
        }
        while (index < this.getMaximumNumberOfCoefficients()) {
            this.setCoefficient(index, Double.NaN);
            ++index;
        }
        this.setIsConstraintMatrixUpToDate(false);
    }

    default public void setDirectly(double[] coefficients) {
        int index;
        this.reshape(coefficients.length);
        for (index = 0; index < this.getNumberOfCoefficients(); ++index) {
            this.setCoefficient(index, coefficients[index]);
        }
        while (index < this.getMaximumNumberOfCoefficients()) {
            this.setCoefficient(index, Double.NaN);
            ++index;
        }
        this.setIsConstraintMatrixUpToDate(false);
    }

    default public void shiftTrajectory(double offsetValue) {
        this.setCoefficient(0, this.getCoefficient(0) + offsetValue);
    }

    default public double getIntegral(double from, double to) {
        double[] fromPowers = new double[this.getNumberOfCoefficients() + 1];
        double[] toPowers = new double[this.getNumberOfCoefficients() + 1];
        PolynomialTools.setXPowers(fromPowers, from);
        PolynomialTools.setXPowers(toPowers, to);
        double integral = 0.0;
        for (int i = 0; i < this.getNumberOfCoefficients(); ++i) {
            integral += 1.0 / ((double)i + 1.0) * this.getCoefficient(i) * (toPowers[i + 1] - fromPowers[i + 1]);
        }
        return integral;
    }

    default public void reset() {
        this.getTimeInterval().reset();
        this.setNumberOfCoefficients(0);
        this.setIsConstraintMatrixUpToDate(false);
        for (int i = 0; i < this.getMaximumNumberOfCoefficients(); ++i) {
            this.setCoefficient(i, Double.NaN);
        }
    }

    default public void setTime(double t0, double tFinal) {
        this.getTimeInterval().setInterval(t0, tFinal);
    }

    default public void setFinalTime(double tFinal) {
        this.getTimeInterval().setEndTime(tFinal);
    }

    default public void setInitialTime(double t0) {
        this.getTimeInterval().setStartTime(t0);
    }

    default public void setZero() {
        this.setConstant(0.0);
    }

    default public void setConstant(double z) {
        this.setConstant(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, z);
    }

    default public void setConstant(double t0, double tFinal, double z) {
        this.setTime(t0, tFinal);
        this.reshape(1);
        this.setPositionRow(0, 0.0, z);
        this.setIsConstraintMatrixUpToDate(true);
        this.setCoefficient(0, z);
    }

    default public void setLinear(double t0, double tFinal, double z0, double zf) {
        this.setTime(t0, tFinal);
        this.reshape(2);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tFinal, zf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setLinear(double t, double z, double zd) {
        this.setTime(t, Double.POSITIVE_INFINITY);
        this.reshape(2);
        this.setPositionRow(0, t, z);
        this.setVelocityRow(1, t, zd);
        this.setIsConstraintMatrixUpToDate(true);
        this.setCoefficient(0, z - zd * t);
        this.setCoefficient(1, zd);
    }

    default public void setQuintic(double t0, double tFinal, double z0, double zd0, double zdd0, double zf, double zdf, double zddf) {
        this.setTime(t0, tFinal);
        this.reshape(6);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tFinal, zf);
        this.setVelocityRow(4, tFinal, zdf);
        this.setAccelerationRow(5, tFinal, zddf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuinticUsingWayPoint(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zdd0, double zIntermediate, double zf, double zdf) {
        this.setTime(t0, tFinal);
        this.reshape(6);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tIntermediate, zIntermediate);
        this.setPositionRow(4, tFinal, zf);
        this.setVelocityRow(5, tFinal, zdf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuinticUsingWayPoint2(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zdd0, double zIntermediate, double zdIntermediate, double zf) {
        this.setTime(t0, tFinal);
        this.reshape(6);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tIntermediate, zIntermediate);
        this.setVelocityRow(4, tIntermediate, zdIntermediate);
        this.setPositionRow(5, tFinal, zf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuinticTwoWaypoints(double t0, double tIntermediate0, double tIntermediate1, double tFinal, double z0, double zd0, double zIntermediate0, double zIntermediate1, double zf, double zdf) {
        this.setTime(t0, tFinal);
        this.reshape(6);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tIntermediate0, zIntermediate0);
        this.setPositionRow(3, tIntermediate1, zIntermediate1);
        this.setPositionRow(4, tFinal, zf);
        this.setVelocityRow(5, tFinal, zdf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuinticUsingIntermediateVelocityAndAcceleration(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zdIntermediate, double zddIntermediate, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(6);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setVelocityRow(2, tIntermediate, zdIntermediate);
        this.setAccelerationRow(3, tIntermediate, zddIntermediate);
        this.setPositionRow(4, tFinal, zFinal);
        this.setVelocityRow(5, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuarticUsingOneIntermediateVelocity(double t0, double tIntermediate0, double tIntermediate1, double tFinal, double z0, double zIntermediate0, double zIntermediate1, double zFinal, double zdIntermediate1) {
        this.setTime(t0, tFinal);
        this.reshape(5);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tIntermediate0, zIntermediate0);
        this.setPositionRow(2, tIntermediate1, zIntermediate1);
        this.setVelocityRow(3, tIntermediate1, zdIntermediate1);
        this.setPositionRow(4, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuinticWithZeroTerminalAcceleration(double t0, double tFinal, double z0, double zd0, double zFinal, double zdFinal) {
        this.setQuintic(t0, tFinal, z0, zd0, 0.0, zFinal, zdFinal, 0.0);
    }

    default public void setSexticUsingWaypoint(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zdd0, double zIntermediate, double zf, double zdf, double zddf) {
        this.setTime(t0, tFinal);
        this.reshape(7);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tIntermediate, zIntermediate);
        this.setPositionRow(4, tFinal, zf);
        this.setVelocityRow(5, tFinal, zdf);
        this.setAccelerationRow(6, tFinal, zddf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setSeptic(double t0, double tIntermediate0, double tIntermediate1, double tFinal, double z0, double zd0, double zIntermediate0, double zdIntermediate0, double zIntermediate1, double zdIntermediate1, double zf, double zdf) {
        this.setTime(t0, tFinal);
        this.reshape(8);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tIntermediate0, zIntermediate0);
        this.setVelocityRow(3, tIntermediate0, zdIntermediate0);
        this.setPositionRow(4, tIntermediate1, zIntermediate1);
        this.setVelocityRow(5, tIntermediate1, zdIntermediate1);
        this.setPositionRow(6, tFinal, zf);
        this.setVelocityRow(7, tFinal, zdf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setSepticInitialAndFinalAcceleration(double t0, double tIntermediate0, double tIntermediate1, double tFinal, double z0, double zd0, double zdd0, double zIntermediate0, double zIntermediate1, double zf, double zdf, double zddf) {
        this.setTime(t0, tFinal);
        this.reshape(8);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tIntermediate0, zIntermediate0);
        this.setPositionRow(4, tIntermediate1, zIntermediate1);
        this.setPositionRow(5, tFinal, zf);
        this.setVelocityRow(6, tFinal, zdf);
        this.setAccelerationRow(7, tFinal, zddf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setNonic(double t0, double tIntermediate0, double tIntermediate1, double tFinal, double z0, double zd0, double zIntermediate0, double zdIntermediate0, double zIntermediate1, double zdIntermediate1, double zf, double zdf) {
        this.setTime(t0, tFinal);
        this.reshape(10);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tIntermediate0, zIntermediate0);
        this.setVelocityRow(3, tIntermediate0, zdIntermediate0);
        this.setPositionRow(4, tIntermediate1, zIntermediate1);
        this.setVelocityRow(5, tIntermediate1, zdIntermediate1);
        this.setPositionRow(6, tFinal, zf);
        this.setVelocityRow(7, tFinal, zdf);
        this.setAccelerationRow(8, t0, 0.0);
        this.setAccelerationRow(9, tFinal, 0.0);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setSexticUsingWaypointVelocityAndAcceleration(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zdd0, double zdIntermediate, double zddIntermediate, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(7);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setVelocityRow(3, tIntermediate, zdIntermediate);
        this.setAccelerationRow(4, tIntermediate, zddIntermediate);
        this.setPositionRow(5, tFinal, zFinal);
        this.setVelocityRow(6, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuarticUsingIntermediateVelocity(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zdIntermediate, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(5);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setVelocityRow(2, tIntermediate, zdIntermediate);
        this.setPositionRow(3, tFinal, zFinal);
        this.setVelocityRow(4, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuartic(double t0, double tFinal, double z0, double zd0, double zdd0, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(5);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tFinal, zFinal);
        this.setVelocityRow(4, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuarticUsingMidPoint(double t0, double tFinal, double z0, double zd0, double zMid, double zFinal, double zdFinal) {
        double tMid = t0 + (tFinal - t0) / 2.0;
        this.setQuarticUsingWayPoint(t0, tMid, tFinal, z0, zd0, zMid, zFinal, zdFinal);
    }

    default public void setQuarticUsingWayPoint(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zIntermediate, double zf, double zdf) {
        this.setTime(t0, tFinal);
        this.reshape(5);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tIntermediate, zIntermediate);
        this.setPositionRow(3, tFinal, zf);
        this.setVelocityRow(4, tFinal, zdf);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuarticUsingFinalAcceleration(double t0, double tFinal, double z0, double zd0, double zFinal, double zdFinal, double zddFinal) {
        this.setTime(t0, tFinal);
        this.reshape(5);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tFinal, zFinal);
        this.setVelocityRow(3, tFinal, zdFinal);
        this.setAccelerationRow(4, tFinal, zddFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubic(double t0, double tFinal, double z0, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, 0.0);
        this.setPositionRow(2, tFinal, zFinal);
        this.setVelocityRow(3, tFinal, 0.0);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubic(double t0, double tFinal, double z0, double zd0, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tFinal, zFinal);
        this.setVelocityRow(3, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicWithIntermediatePositionAndInitialVelocityConstraint(double t0, double tIntermediate, double tFinal, double z0, double zd0, double zIntermediate, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tIntermediate, zIntermediate);
        this.setPositionRow(3, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicWithIntermediatePositionAndFinalVelocityConstraint(double t0, double tIntermediate, double tFinal, double z0, double zIntermediate, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tIntermediate, zIntermediate);
        this.setPositionRow(2, tFinal, zFinal);
        this.setVelocityRow(3, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicBezier(double t0, double tFinal, double z0, double zR1, double zR2, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tFinal, zFinal);
        this.setVelocityRow(2, t0, 3.0 * (zR1 - z0) / (tFinal - t0));
        this.setVelocityRow(3, tFinal, 3.0 * (zFinal - zR2) / (tFinal - t0));
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicUsingFinalAccelerationButNotFinalPosition(double t0, double tFinal, double z0, double zd0, double zdFinal, double zddFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setVelocityRow(2, tFinal, zdFinal);
        this.setAccelerationRow(3, tFinal, zddFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuadratic(double t0, double tFinal, double z0, double zd0, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(3);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuadraticWithFinalVelocityConstraint(double t0, double tFinal, double z0, double zFinal, double zdFinal) {
        this.setTime(t0, tFinal);
        this.reshape(3);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tFinal, zFinal);
        this.setVelocityRow(2, tFinal, zdFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuadraticUsingInitialAcceleration(double t0, double tFinal, double z0, double zd0, double zdd0) {
        this.setTime(t0, tFinal);
        this.reshape(3);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setQuadraticUsingIntermediatePoint(double t0, double tIntermediate, double tFinal, double z0, double zIntermediate, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(3);
        MathTools.checkIntervalContains((double)tIntermediate, (double)t0, (double)tFinal);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tIntermediate, zIntermediate);
        this.setPositionRow(2, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicUsingIntermediatePoint(double t0, double tIntermediate1, double tFinal, double z0, double zIntermediate1, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        MathTools.checkIntervalContains((double)tIntermediate1, (double)t0, (double)tFinal);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tIntermediate1, zIntermediate1);
        this.setPositionRow(2, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicUsingIntermediatePoints(double t0, double tIntermediate1, double tIntermediate2, double tFinal, double z0, double zIntermediate1, double zIntermediate2, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        MathTools.checkIntervalContains((double)tIntermediate1, (double)t0, (double)tIntermediate1);
        MathTools.checkIntervalContains((double)tIntermediate2, (double)tIntermediate1, (double)tFinal);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tIntermediate1, zIntermediate1);
        this.setPositionRow(2, tIntermediate2, zIntermediate2);
        this.setPositionRow(3, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicThreeInitialConditionsFinalPosition(double t0, double tFinal, double z0, double zd0, double zdd0, double zFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setAccelerationRow(2, t0, zdd0);
        this.setPositionRow(3, tFinal, zFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setCubicInitialPositionThreeFinalConditions(double t0, double tFinal, double z0, double zFinal, double zdFinal, double zddFinal) {
        this.setTime(t0, tFinal);
        this.reshape(4);
        this.setPositionRow(0, t0, z0);
        this.setPositionRow(1, tFinal, zFinal);
        this.setVelocityRow(2, tFinal, zdFinal);
        this.setAccelerationRow(3, tFinal, zddFinal);
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setInitialPositionVelocityZeroFinalHighOrderDerivatives(double t0, double tFinal, double z0, double zd0, double zFinal, double zdFinal) {
        if (this.getMaximumNumberOfCoefficients() < 4) {
            throw new RuntimeException("Need at least 4 coefficients in order to set initial and final positions and velocities");
        }
        this.setTime(t0, tFinal);
        this.reshape(this.getMaximumNumberOfCoefficients());
        this.setPositionRow(0, t0, z0);
        this.setVelocityRow(1, t0, zd0);
        this.setPositionRow(2, tFinal, zFinal);
        this.setVelocityRow(3, tFinal, zdFinal);
        int order = 2;
        for (int row = 4; row < this.getMaximumNumberOfCoefficients(); ++row) {
            this.setConstraintRow(row, tFinal, 0.0, order++);
        }
        this.setIsConstraintMatrixUpToDate(true);
        this.initialize();
    }

    default public void setPositionRow(int row, double x, double z) {
        this.setIsConstraintMatrixUpToDate(false);
        this.setConstraintRow(row, x, z, 0);
    }

    default public void setVelocityRow(int row, double x, double zVelocity) {
        this.setIsConstraintMatrixUpToDate(false);
        this.setConstraintRow(row, x, zVelocity, 1);
    }

    default public void setAccelerationRow(int row, double x, double zAcceleration) {
        this.setIsConstraintMatrixUpToDate(false);
        this.setConstraintRow(row, x, zAcceleration, 2);
    }

    default public void commitCoefficientsToMemory() {
        int row;
        if (!this.isConstraintMatrixUpToDate()) {
            throw new RuntimeException("The constraint matrix is out of date, setting from it will change data.");
        }
        for (row = 0; row < this.getNumberOfCoefficients(); ++row) {
            this.setCoefficient(row, this.getCoefficientsVector().get(row, 0));
        }
        while (row < this.getMaximumNumberOfCoefficients()) {
            this.setCoefficient(row, Double.NaN);
            ++row;
        }
        this.setIsConstraintMatrixUpToDate(true);
    }
}

