/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.PositionTrajectoryGenerator;
import us.ihmc.robotics.time.TimeIntervalProvider;

public interface Polynomial3DReadOnly
extends PositionTrajectoryGenerator,
TimeIntervalProvider {
    public PolynomialReadOnly getAxis(int var1);

    default public PolynomialReadOnly getAxis(Axis3D axis) {
        return this.getAxis(axis.ordinal());
    }

    public Tuple3DReadOnly[] getCoefficients();

    @Override
    default public void compute(double t) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).compute(t);
        }
    }

    @Override
    default public boolean isDone() {
        for (int i = 0; i < 3; ++i) {
            if (this.getAxis(i).isDone()) continue;
            return false;
        }
        return true;
    }

    default public double getDuration() {
        return this.getTimeInterval().getDuration();
    }

    default public boolean timeIntervalContains(double timeToCheck, double EPSILON) {
        return this.getTimeInterval().epsilonContains(timeToCheck, EPSILON);
    }

    default public boolean timeIntervalContains(double timeToCheck) {
        return this.getTimeInterval().intervalContains(timeToCheck);
    }

    default public int getNumberOfCoefficients() {
        if (this.getNumberOfCoefficients(0) == this.getNumberOfCoefficients(1) && this.getNumberOfCoefficients(0) == this.getNumberOfCoefficients(2)) {
            return this.getNumberOfCoefficients(0);
        }
        return -1;
    }

    default public int getNumberOfCoefficients(Axis3D dir) {
        return this.getAxis(dir.ordinal()).getNumberOfCoefficients();
    }

    default public int getNumberOfCoefficients(int index) {
        return this.getAxis(index).getNumberOfCoefficients();
    }

    default public int getMaximumNumberOfCoefficients() {
        if (this.getMaximumNumberOfCoefficients(0) == this.getMaximumNumberOfCoefficients(1) && this.getMaximumNumberOfCoefficients(0) == this.getMaximumNumberOfCoefficients(2)) {
            return this.getMaximumNumberOfCoefficients(0);
        }
        throw new RuntimeException("The maximum number of coefficients are not the same for all three axes.");
    }

    default public int getMaximumNumberOfCoefficients(Axis3D dir) {
        return this.getAxis(dir.ordinal()).getNumberOfCoefficients();
    }

    default public int getMaximumNumberOfCoefficients(int index) {
        return this.getAxis(index).getMaximumNumberOfCoefficients();
    }

    default public void getCoefficients(int idx, DMatrixRMaj coefficientsToPack) {
        this.getCoefficients(idx).get((DMatrix)coefficientsToPack);
    }

    default public Tuple3DReadOnly getCoefficients(int i) {
        return this.getCoefficients()[i];
    }
}

