/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialReadOnly;

public interface Polynomial3DBasics
extends Polynomial3DReadOnly,
Transformable {
    @Override
    default public PolynomialBasics getAxis(Axis3D axis) {
        return this.getAxis(axis.ordinal());
    }

    @Override
    public PolynomialBasics getAxis(int var1);

    public Tuple3DBasics[] getCoefficients();

    default public Tuple3DBasics getCoefficients(int i) {
        for (int axis = 0; axis < 3; ++axis) {
            this.getAxis(axis).setIsConstraintMatrixUpToDate(false);
        }
        return this.getCoefficients()[i];
    }

    default public void shiftTrajectory(Tuple3DReadOnly offset) {
        this.shiftTrajectory(offset.getX(), offset.getY(), offset.getZ());
    }

    default public void shiftTrajectory(double offsetX, double offsetY, double offsetZ) {
        this.getCoefficients(0).add(offsetX, offsetY, offsetZ);
        for (int i = 0; i < 3; ++i) {
            this.getAxis(i).setIsConstraintMatrixUpToDate(false);
        }
    }

    default public void reset() {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).reset();
        }
    }

    @Override
    default public void initialize() {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).initialize();
        }
    }

    default public void commitCoefficientsToMemory() {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).initialize();
        }
    }

    default public void set(Polynomial3DReadOnly other) {
        this.set(other.getAxis(Axis3D.X), other.getAxis(Axis3D.Y), other.getAxis(Axis3D.Z));
    }

    default public void set(PolynomialReadOnly xPolynomial, PolynomialReadOnly yPolynomial, PolynomialReadOnly zPolynomial) {
        this.getAxis(Axis3D.X).set(xPolynomial);
        this.getAxis(Axis3D.Y).set(yPolynomial);
        this.getAxis(Axis3D.Z).set(zPolynomial);
    }

    default public void applyTransform(Transform transform) {
        for (int i = 0; i < this.getNumberOfCoefficients(); ++i) {
            this.getCoefficients(i).applyTransform(transform);
        }
    }

    default public void applyInverseTransform(Transform transform) {
        for (int i = 0; i < this.getNumberOfCoefficients(); ++i) {
            this.getCoefficients(i).applyInverseTransform(transform);
        }
    }

    default public void setConstant(Point3DReadOnly z) {
        this.setConstant(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, (Tuple3DReadOnly)z);
    }

    default public void setZero() {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setZero();
        }
    }

    default public void setConstant(double t0, double tFinal, Tuple3DReadOnly z) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setConstant(t0, tFinal, z.getElement(index));
        }
    }

    default public void setCubic(double t0, double tFinal, Point3DReadOnly z0, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubic(t0, tFinal, z0.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setCubic(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubic(t0, tFinal, z0.getElement(index), zd0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setCubicInitialPositionThreeFinalConditions(double t0, double tFinal, Point3DReadOnly z0, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal, Vector3DReadOnly zddFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicInitialPositionThreeFinalConditions(t0, tFinal, z0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index), zddFinal.getElement(index));
        }
    }

    default public void setCubicThreeInitialConditionsFinalPosition(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicThreeInitialConditionsFinalPosition(t0, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setCubicUsingFinalAccelerationButNotFinalPosition(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdFinal, Vector3DReadOnly zddFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicUsingFinalAccelerationButNotFinalPosition(t0, tFinal, z0.getElement(index), zd0.getElement(index), zdFinal.getElement(index), zddFinal.getElement(index));
        }
    }

    default public void setCubicUsingIntermediatePoints(double t0, double tIntermediate1, double tIntermediate2, double tFinal, Point3DReadOnly z0, Point3DReadOnly zIntermediate1, Point3DReadOnly zIntermediate2, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicUsingIntermediatePoints(t0, tIntermediate1, tIntermediate2, tFinal, z0.getElement(index), zIntermediate1.getElement(index), zIntermediate2.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setCubicUsingIntermediatePoint(double t0, double tIntermediate1, double tFinal, Point3DReadOnly z0, Point3DReadOnly zIntermediate1, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicUsingIntermediatePoint(t0, tIntermediate1, tFinal, z0.getElement(index), zIntermediate1.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setCubicWithIntermediatePositionAndFinalVelocityConstraint(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Point3DReadOnly zIntermediate, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicWithIntermediatePositionAndFinalVelocityConstraint(t0, tIntermediate, tFinal, z0.getElement(index), zIntermediate.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setCubicWithIntermediatePositionAndInitialVelocityConstraint(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zIntermediate, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicWithIntermediatePositionAndInitialVelocityConstraint(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zIntermediate.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setCubicBezier(double t0, double tFinal, Point3DReadOnly z0, Point3DReadOnly zR1, Point3DReadOnly zR2, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setCubicBezier(t0, tFinal, z0.getElement(index), zR1.getElement(index), zR2.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setInitialPositionVelocityZeroFinalHighOrderDerivatives(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setInitialPositionVelocityZeroFinalHighOrderDerivatives(t0, tFinal, z0.getElement(index), zd0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setLinear(double t0, Point3DReadOnly z0, Vector3DReadOnly zDot) {
        for (Axis3D axis : Axis3D.values) {
            int index = axis.ordinal();
            this.getAxis(index).setLinear(t0, z0.getElement(index), zDot.getElement(index));
        }
    }

    default public void setLinear(double t0, double tFinal, Point3DReadOnly z0, Point3DReadOnly zf) {
        for (Axis3D axis : Axis3D.values) {
            int index = axis.ordinal();
            this.getAxis(index).setLinear(t0, tFinal, z0.getElement(index), zf.getElement(index));
        }
    }

    default public void setNonic(double t0, double tIntermediate0, double tIntermediate1, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zIntermediate0, Vector3DReadOnly zdIntermediate0, Point3DReadOnly zIntermediate1, Vector3DReadOnly zdIntermediate1, Point3DReadOnly zf, Vector3DReadOnly zdf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setNonic(t0, tIntermediate0, tIntermediate1, tFinal, z0.getElement(index), zd0.getElement(index), zIntermediate0.getElement(index), zdIntermediate0.getElement(index), zIntermediate1.getElement(index), zdIntermediate1.getElement(index), zf.getElement(index), zdf.getElement(index));
        }
    }

    default public void setQuadratic(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuadratic(t0, tFinal, z0.getElement(index), zd0.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setQuadraticUsingInitialAcceleration(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuadraticUsingInitialAcceleration(t0, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index));
        }
    }

    default public void setQuadraticUsingIntermediatePoint(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Point3DReadOnly zIntermediate, Point3DReadOnly zFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuadraticUsingIntermediatePoint(t0, tIntermediate, tFinal, z0.getElement(index), zIntermediate.getElement(index), zFinal.getElement(index));
        }
    }

    default public void setQuadraticWithFinalVelocityConstraint(double t0, double tFinal, Point3DReadOnly z0, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuadraticWithFinalVelocityConstraint(t0, tFinal, z0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setQuartic(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuartic(t0, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setQuarticUsingFinalAcceleration(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal, Vector3DReadOnly zddFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuarticUsingFinalAcceleration(t0, tFinal, z0.getElement(index), zd0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index), zddFinal.getElement(index));
        }
    }

    default public void setQuarticUsingIntermediateVelocity(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdIntermediate, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuarticUsingIntermediateVelocity(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zdIntermediate.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setQuarticUsingMidPoint(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zMid, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuarticUsingMidPoint(t0, tFinal, z0.getElement(index), zd0.getElement(index), zMid.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setQuarticUsingOneIntermediateVelocity(double t0, double tIntermediate0, double tIntermediate1, double tFinal, Point3DReadOnly z0, Point3DReadOnly zIntermediate0, Point3DReadOnly zIntermediate1, Point3DReadOnly zFinal, Vector3DReadOnly zdIntermediate1) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuarticUsingOneIntermediateVelocity(t0, tIntermediate0, tIntermediate1, tFinal, z0.getElement(index), zIntermediate0.getElement(index), zIntermediate1.getElement(index), zFinal.getElement(index), zdIntermediate1.getElement(index));
        }
    }

    default public void setQuarticUsingWayPoint(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zIntermediate, Point3DReadOnly zf, Vector3DReadOnly zdf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuarticUsingWayPoint(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zIntermediate.getElement(index), zf.getElement(index), zdf.getElement(index));
        }
    }

    default public void setQuintic(double t0, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zf, Vector3DReadOnly zdf, Vector3DReadOnly zddf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuintic(t0, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zf.getElement(index), zdf.getElement(index), zddf.getElement(index));
        }
    }

    default public void setQuinticTwoWaypoints(double t0, double tIntermediate0, double tIntermediate1, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zIntermediate0, Point3DReadOnly zIntermediate1, Point3DReadOnly zf, Vector3DReadOnly zdf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuinticTwoWaypoints(t0, tIntermediate0, tIntermediate1, tFinal, z0.getElement(index), zd0.getElement(index), zIntermediate0.getElement(index), zIntermediate1.getElement(index), zf.getElement(index), zdf.getElement(index));
        }
    }

    default public void setQuinticUsingIntermediateVelocityAndAcceleration(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdIntermediate, Vector3DReadOnly zddIntermediate, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuinticUsingIntermediateVelocityAndAcceleration(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zdIntermediate.getElement(index), zddIntermediate.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setQuinticUsingWayPoint(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zIntermediate, Point3DReadOnly zf, Vector3DReadOnly zdf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuinticUsingWayPoint(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zIntermediate.getElement(index), zf.getElement(index), zdf.getElement(index));
        }
    }

    default public void setQuinticUsingWayPoint2(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zIntermediate, Vector3DReadOnly zdIntermediate, Point3DReadOnly zf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuinticUsingWayPoint2(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zIntermediate.getElement(index), zdIntermediate.getElement(index), zf.getElement(index));
        }
    }

    default public void setSeptic(double t0, double tIntermediate0, double tIntermediate1, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Point3DReadOnly zIntermediate0, Vector3DReadOnly zdIntermediate0, Point3DReadOnly zIntermediate1, Vector3DReadOnly zdIntermediate1, Point3DReadOnly zf, Vector3DReadOnly zdf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setSeptic(t0, tIntermediate0, tIntermediate1, tFinal, z0.getElement(index), zd0.getElement(index), zIntermediate0.getElement(index), zdIntermediate0.getElement(index), zIntermediate1.getElement(index), zdIntermediate1.getElement(index), zf.getElement(index), zdf.getElement(index));
        }
    }

    default public void setSepticInitialAndFinalAcceleration(double t0, double tIntermediate0, double tIntermediate1, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zIntermediate0, Point3DReadOnly zIntermediate1, Point3DReadOnly zf, Vector3DReadOnly zdf, Vector3DReadOnly zddf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setSepticInitialAndFinalAcceleration(t0, tIntermediate0, tIntermediate1, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zIntermediate0.getElement(index), zIntermediate1.getElement(index), zf.getElement(index), zdf.getElement(index), zddf.getElement(index));
        }
    }

    default public void setQuinticWithZeroTerminalAcceleration(double t0, double tFinal, Tuple3DReadOnly z0, Tuple3DReadOnly zd0, Tuple3DReadOnly zFinal, Tuple3DReadOnly zdFinal) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setQuinticWithZeroTerminalAcceleration(t0, tFinal, z0.getElement(index), zd0.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }

    default public void setSexticUsingWaypoint(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Point3DReadOnly zIntermediate, Point3DReadOnly zf, Vector3DReadOnly zdf, Vector3DReadOnly zddf) {
        for (int index = 0; index < 3; ++index) {
            this.getAxis(index).setSexticUsingWaypoint(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zIntermediate.getElement(index), zf.getElement(index), zdf.getElement(index), zddf.getElement(index));
        }
    }

    default public void setSexticUsingWaypointVelocityAndAcceleration(double t0, double tIntermediate, double tFinal, Point3DReadOnly z0, Vector3DReadOnly zd0, Vector3DReadOnly zdd0, Vector3DReadOnly zdIntermediate, Vector3DReadOnly zddIntermediate, Point3DReadOnly zFinal, Vector3DReadOnly zdFinal) {
        for (Axis3D axis : Axis3D.values) {
            int index = axis.ordinal();
            this.getAxis(index).setSexticUsingWaypointVelocityAndAcceleration(t0, tIntermediate, tFinal, z0.getElement(index), zd0.getElement(index), zdd0.getElement(index), zdIntermediate.getElement(index), zddIntermediate.getElement(index), zFinal.getElement(index), zdFinal.getElement(index));
        }
    }
}

