/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import gnu.trove.TDoubleCollection;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import org.apache.commons.math3.util.Precision;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.OneDoFTrajectoryPointList;

public class OneDoFTrajectoryPointCalculator {
    private static final int maxIterations = 2000;
    private final TrajectoryPointOptimizer trajectoryPointOptimizer = new TrajectoryPointOptimizer(1);
    private final OneDoFTrajectoryPointList trajectory = new OneDoFTrajectoryPointList();
    private final TDoubleArrayList positions = new TDoubleArrayList();
    private final TDoubleArrayList velocities = new TDoubleArrayList();
    private final TDoubleArrayList times = new TDoubleArrayList();

    public void clear() {
        this.positions.clear();
        this.times.clear();
        this.velocities.clear();
        this.trajectory.clear();
    }

    public void appendTrajectoryPoint(double position) {
        this.positions.add(position);
    }

    public void appendTrajectoryPoint(double time, double position) {
        this.positions.add(position);
        this.times.add(time);
    }

    public void compute(double trajectoryTime) {
        int i;
        if (!this.velocities.isEmpty()) {
            throw new RuntimeException("Was already computed. Need to clear and readd points before computing again.");
        }
        TDoubleArrayList startPosition = new TDoubleArrayList(new double[]{this.positions.get(0)});
        TDoubleArrayList startVelocity = new TDoubleArrayList(new double[]{0.0});
        TDoubleArrayList finalPosition = new TDoubleArrayList(new double[]{this.positions.get(this.positions.size() - 1)});
        TDoubleArrayList finalVelocity = new TDoubleArrayList(new double[]{0.0});
        ArrayList<TDoubleArrayList> waypoints = new ArrayList<TDoubleArrayList>();
        for (int i2 = 1; i2 < this.positions.size() - 1; ++i2) {
            waypoints.add(new TDoubleArrayList(new double[]{this.positions.get(i2)}));
        }
        this.trajectoryPointOptimizer.setEndPoints(startPosition, startVelocity, finalPosition, finalVelocity);
        this.trajectoryPointOptimizer.setWaypoints(waypoints);
        if (this.times.isEmpty()) {
            this.computeIncludingTimes();
        } else {
            this.computeForFixedTime(trajectoryTime);
        }
        this.times.clear();
        this.times.add(0.0);
        this.velocities.add(0.0);
        TDoubleArrayList velocityToPack = new TDoubleArrayList();
        for (i = 0; i < waypoints.size(); ++i) {
            this.times.add(this.trajectoryPointOptimizer.getWaypointTime(i) * trajectoryTime);
            this.trajectoryPointOptimizer.getWaypointVelocity(velocityToPack, i);
            this.velocities.add(velocityToPack.get(0) / trajectoryTime);
        }
        this.times.add(trajectoryTime);
        this.velocities.add(0.0);
        for (i = 0; i < this.positions.size(); ++i) {
            double time = this.times.get(i);
            double position = this.positions.get(i);
            double velocity = this.velocities.get(i);
            this.trajectory.addTrajectoryPoint(time, position, velocity);
        }
    }

    private void computeForFixedTime(double trajectoryTime) {
        if (this.times.size() != this.positions.size()) {
            throw new RuntimeException("If providing times provide one for each position waypoint!");
        }
        if (!Precision.equals((double)this.times.get(0), (double)0.0, (double)Double.MIN_VALUE)) {
            throw new RuntimeException("First time must be zero. Offset your trajectory later!");
        }
        if (!Precision.equals((double)this.times.get(this.times.size() - 1), (double)trajectoryTime, (double)Double.MIN_VALUE)) {
            throw new RuntimeException("Last waypoint time must match the trajectory time!");
        }
        TDoubleArrayList waypointTimes = new TDoubleArrayList((TDoubleCollection)this.times.subList(1, this.times.size() - 1));
        waypointTimes.transformValues(time -> time / trajectoryTime);
        this.trajectoryPointOptimizer.computeForFixedTime(waypointTimes);
    }

    private void computeIncludingTimes() {
        this.trajectoryPointOptimizer.compute(2000);
    }

    public int getNumberOfTrajectoryPoints() {
        return this.positions.size();
    }

    public OneDoFTrajectoryPointList getTrajectoryData() {
        return this.trajectory;
    }
}

