/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.ArrayList;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.math.trajectories.interfaces.DoubleTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoOneDoFTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.OneDoFTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MultipleWaypointsTrajectoryGenerator
implements DoubleTrajectoryGenerator {
    public static final int defaultMaximumNumberOfWaypoints = 30;
    private final int maximumNumberOfWaypoints;
    private final String namePrefix;
    private final YoRegistry registry;
    private final YoDouble currentTrajectoryTime;
    private final YoInteger numberOfWaypoints;
    private final YoInteger currentWaypointIndex;
    private final ArrayList<YoOneDoFTrajectoryPoint> waypoints;
    private final YoDouble currentPosition;
    private final YoDouble currentVelocity;
    private final YoDouble currentAcceleration;
    private final YoPolynomial subTrajectory;

    public MultipleWaypointsTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry) {
        this(namePrefix, 30, parentRegistry);
    }

    public MultipleWaypointsTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfWaypoints = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.numberOfWaypoints = new YoInteger(namePrefix + "NumberOfWaypoints", this.registry);
        this.numberOfWaypoints.set(0);
        this.currentTrajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentWaypointIndex = new YoInteger(namePrefix + "CurrentWaypointIndex", this.registry);
        this.waypoints = new ArrayList(maximumNumberOfWaypoints);
        for (int i = 0; i < maximumNumberOfWaypoints; ++i) {
            YoOneDoFTrajectoryPoint waypoint = new YoOneDoFTrajectoryPoint(namePrefix, "AtWaypoint" + i, this.registry);
            this.waypoints.add(waypoint);
        }
        namePrefix = namePrefix + "SubTrajectory";
        String currentPositionName = namePrefix + "CurrentPosition";
        String currentVelocityName = namePrefix + "CurrentVelocity";
        String currentAccelerationName = namePrefix + "CurrentAcceleration";
        this.currentPosition = new YoDouble(currentPositionName, this.registry);
        this.currentVelocity = new YoDouble(currentVelocityName, this.registry);
        this.currentAcceleration = new YoDouble(currentAccelerationName, this.registry);
        this.subTrajectory = new YoPolynomial(namePrefix, 4, this.registry);
        this.clear();
    }

    public void clear() {
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
        for (int i = 0; i < this.maximumNumberOfWaypoints; ++i) {
            this.waypoints.get(i).setToNaN();
        }
    }

    public void appendWaypoint(double timeAtWaypoint, double position, double velocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, position, velocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, double position, double velocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, position, velocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoints(double[] timeAtWaypoints, double[] positions, double[] velocities) {
        if (timeAtWaypoints.length != positions.length || positions.length != velocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], positions[i], velocities[i]);
        }
    }

    public void appendWaypoint(OneDoFTrajectoryPointBasics waypoint1D) {
        this.appendWaypoint(waypoint1D.getTime(), waypoint1D.getPosition(), waypoint1D.getVelocity());
    }

    public void appendWaypoints(OneDoFTrajectoryPointBasics[] waypoints1D) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + waypoints1D.length);
        for (int i = 0; i < waypoints1D.length; ++i) {
            this.appendWaypointUnsafe(waypoints1D[i].getTime(), waypoints1D[i].getPosition(), waypoints1D[i].getVelocity());
        }
    }

    public void appendWaypoints(RecyclingArrayList<? extends OneDoFTrajectoryPointBasics> waypoints1D) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + waypoints1D.size());
        for (int i = 0; i < waypoints1D.size(); ++i) {
            this.appendWaypointUnsafe(((OneDoFTrajectoryPointBasics)waypoints1D.get(i)).getTime(), ((OneDoFTrajectoryPointBasics)waypoints1D.get(i)).getPosition(), ((OneDoFTrajectoryPointBasics)waypoints1D.get(i)).getVelocity());
        }
    }

    public <W extends OneDoFTrajectoryPointBasics> void appendWaypoints(TrajectoryPointListBasics<W> trajectoryWaypoint1DData) {
        for (int i = 0; i < trajectoryWaypoint1DData.getNumberOfTrajectoryPoints(); ++i) {
            this.appendWaypoint((OneDoFTrajectoryPointBasics)trajectoryWaypoint1DData.getTrajectoryPoint(i));
        }
    }

    private void checkNumberOfWaypoints(int length) {
        if (length > this.maximumNumberOfWaypoints) {
            throw new RuntimeException("Cannot exceed the maximum number of waypoints. Number of waypoints provided: " + length);
        }
    }

    @Override
    public void initialize() {
        if (this.isEmpty()) {
            throw new RuntimeException("Trajectory has no waypoints.");
        }
        this.currentWaypointIndex.set(0);
        if (this.numberOfWaypoints.getIntegerValue() == 1) {
            this.subTrajectory.setConstant(this.waypoints.get(0).getPosition());
        } else {
            this.initializeSubTrajectory(0);
        }
    }

    private void initializeSubTrajectory(int waypointIndex) {
        int secondWaypointIndex = Math.min(waypointIndex + 1, this.numberOfWaypoints.getValue() - 1);
        YoOneDoFTrajectoryPoint start = this.waypoints.get(waypointIndex);
        YoOneDoFTrajectoryPoint end = this.waypoints.get(secondWaypointIndex);
        double subTrajectoryDuration = end.getTime() - start.getTime();
        this.subTrajectory.setCubic(0.0, subTrajectoryDuration, start.getPosition(), start.getVelocity(), end.getPosition(), end.getVelocity());
    }

    @Override
    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentTrajectoryTime.set(time);
        boolean changedSubTrajectory = false;
        if (time < this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime()) {
            this.currentWaypointIndex.set(0);
            changedSubTrajectory = true;
        }
        while (this.currentWaypointIndex.getIntegerValue() < this.numberOfWaypoints.getIntegerValue() - 2 && time >= this.waypoints.get(this.currentWaypointIndex.getIntegerValue() + 1).getTime()) {
            this.currentWaypointIndex.increment();
            changedSubTrajectory = true;
        }
        if (changedSubTrajectory) {
            this.initializeSubTrajectory(this.currentWaypointIndex.getIntegerValue());
        }
        int secondWaypointIndex = Math.min(this.currentWaypointIndex.getValue() + 1, this.numberOfWaypoints.getValue() - 1);
        YoOneDoFTrajectoryPoint start = this.waypoints.get(this.currentWaypointIndex.getValue());
        YoOneDoFTrajectoryPoint end = this.waypoints.get(secondWaypointIndex);
        if (time < start.getTime()) {
            this.currentPosition.set(start.getPosition());
            this.currentVelocity.set(0.0);
            this.currentAcceleration.set(0.0);
            return;
        }
        if (time > end.getTime()) {
            this.currentPosition.set(end.getPosition());
            this.currentVelocity.set(0.0);
            this.currentAcceleration.set(0.0);
            return;
        }
        if (Precision.equals((double)start.getTime(), (double)end.getTime())) {
            this.currentPosition.set(start.getPosition());
            this.currentVelocity.set(start.getVelocity());
            this.currentAcceleration.set(0.0);
            return;
        }
        double subTrajectoryTime = time - this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime();
        this.subTrajectory.compute(subTrajectoryTime);
        this.currentPosition.set(this.subTrajectory.getValue());
        this.currentVelocity.set(this.subTrajectory.getVelocity());
        this.currentAcceleration.set(this.subTrajectory.getAcceleration());
    }

    @Override
    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentWaypointIndex.getIntegerValue() >= this.numberOfWaypoints.getIntegerValue() - 2;
        if (!isLastWaypoint) {
            return false;
        }
        boolean subTrajectoryIsDone = this.subTrajectory.isDone();
        return subTrajectoryIsDone;
    }

    public boolean isEmpty() {
        return this.numberOfWaypoints.getIntegerValue() == 0;
    }

    public double getValue() {
        return this.currentPosition.getValue();
    }

    @Override
    public double getVelocity() {
        return this.currentVelocity.getDoubleValue();
    }

    @Override
    public double getAcceleration() {
        return this.currentAcceleration.getDoubleValue();
    }

    public int getCurrentNumberOfWaypoints() {
        return this.numberOfWaypoints.getIntegerValue();
    }

    public int getMaximumNumberOfWaypoints() {
        return this.maximumNumberOfWaypoints;
    }

    public double getLastWaypointTime() {
        return this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime();
    }

    public void getLastWaypoint(OneDoFTrajectoryPointBasics pointToPack) {
        YoOneDoFTrajectoryPoint lastWaypoint = this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1);
        pointToPack.setPosition(lastWaypoint.getPosition());
        pointToPack.setVelocity(lastWaypoint.getVelocity());
        pointToPack.setTime(lastWaypoint.getTime());
    }

    public double getFirstWaypointTime() {
        return this.waypoints.get(0).getTime();
    }

    public void getFirstWaypoint(OneDoFTrajectoryPointBasics pointToPack) {
        YoOneDoFTrajectoryPoint firstWaypoint = this.waypoints.get(0);
        pointToPack.setPosition(firstWaypoint.getPosition());
        pointToPack.setVelocity(firstWaypoint.getVelocity());
        pointToPack.setTime(firstWaypoint.getTime());
    }

    public String toString() {
        if (this.isEmpty()) {
            return this.namePrefix + ": Has no waypoints.";
        }
        return this.namePrefix + ": number of waypoints = " + this.numberOfWaypoints.getIntegerValue() + ", current waypoint index = " + this.currentWaypointIndex.getIntegerValue() + "\nFirst waypoint: " + this.waypoints.get(0) + ", last waypoint: " + this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1);
    }
}

