/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.ArrayList;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.PositionTrajectoryGeneratorInMultipleFrames;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoFrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MultipleWaypointsPositionTrajectoryGenerator
extends PositionTrajectoryGeneratorInMultipleFrames {
    private final String namePrefix;
    private final int maximumNumberOfWaypoints;
    private final YoRegistry registry;
    private final YoDouble currentTrajectoryTime;
    private final YoInteger numberOfWaypoints;
    private final YoInteger currentWaypointIndex;
    private final ArrayList<YoFrameEuclideanTrajectoryPoint> waypoints;
    private final FramePoint3DBasics currentPosition;
    private final FrameVector3DBasics currentVelocity;
    private final FrameVector3DBasics currentAcceleration;
    private final YoPolynomial3D subTrajectory;

    public MultipleWaypointsPositionTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, 30, referenceFrame, parentRegistry);
    }

    public MultipleWaypointsPositionTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfWaypoints = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.numberOfWaypoints = new YoInteger(namePrefix + "NumberOfWaypoints", this.registry);
        this.numberOfWaypoints.set(0);
        this.waypoints = new ArrayList(maximumNumberOfWaypoints);
        this.currentTrajectoryTime = new YoDouble(namePrefix + "CurrentTrajectoryTime", this.registry);
        this.currentWaypointIndex = new YoInteger(namePrefix + "CurrentWaypointIndex", this.registry);
        String currentPositionName = namePrefix + "CurrentPosition";
        String currentVelocityName = namePrefix + "CurrentVelocity";
        String currentAccelerationName = namePrefix + "CurrentAcceleration";
        this.currentPosition = new YoMutableFramePoint3D(currentPositionName, "", this.registry, referenceFrame);
        this.currentVelocity = new YoMutableFrameVector3D(currentVelocityName, "", this.registry, referenceFrame);
        this.currentAcceleration = new YoMutableFrameVector3D(currentAccelerationName, "", this.registry, referenceFrame);
        this.registerFrameChangeables(new FrameChangeable[]{this.currentPosition, this.currentVelocity, this.currentAcceleration});
        this.subTrajectory = new YoPolynomial3D(namePrefix, 4, this.registry);
        for (int i = 0; i < maximumNumberOfWaypoints; ++i) {
            YoFrameEuclideanTrajectoryPoint waypoint = new YoFrameEuclideanTrajectoryPoint(namePrefix, "AtWaypoint" + i, this.registry);
            this.registerFrameChangeables(waypoint);
            this.waypoints.add(waypoint);
        }
        this.clear(referenceFrame);
        parentRegistry.addChild(this.registry);
    }

    public void clear() {
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
        for (int i = 0; i < this.maximumNumberOfWaypoints; ++i) {
            this.waypoints.get(i).setToNaN();
        }
    }

    public void clear(ReferenceFrame referenceFrame) {
        this.clear();
        this.setReferenceFrame(referenceFrame);
    }

    public void appendWaypoint(double timeAtWaypoint, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, position, linearVelocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, position, linearVelocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(double timeAtWaypoint, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, position, linearVelocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, position, linearVelocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(EuclideanTrajectoryPointBasics euclideanWaypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(euclideanWaypoint);
    }

    public void appendWaypoint(FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameEuclideanTrajectoryPoint);
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(frameEuclideanTrajectoryPoint);
    }

    public void appendWaypoint(FrameSE3TrajectoryPoint frameSE3TrajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameSE3TrajectoryPoint);
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(frameSE3TrajectoryPoint);
    }

    private void appendWaypointUnsafe(EuclideanTrajectoryPointBasics euclideanWaypoint) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(euclideanWaypoint);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoints(double[] timeAtWaypoints, FramePoint3DReadOnly[] positions, FrameVector3DReadOnly[] linearVelocities) {
        if (timeAtWaypoints.length != positions.length || linearVelocities != null && positions.length != linearVelocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], positions[i], linearVelocities[i]);
        }
    }

    public void appendWaypoints(double[] timeAtWaypoints, Point3DReadOnly[] positions, Vector3DReadOnly[] linearVelocities) {
        if (timeAtWaypoints.length != positions.length || positions.length != linearVelocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], positions[i], linearVelocities[i]);
        }
    }

    public void appendWaypoints(EuclideanTrajectoryPointBasics[] euclideanWaypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + euclideanWaypoint.length);
        for (int i = 0; i < euclideanWaypoint.length; ++i) {
            this.appendWaypointUnsafe(euclideanWaypoint[i]);
        }
    }

    public void appendWaypoints(RecyclingArrayList<? extends EuclideanTrajectoryPointBasics> euclideanWaypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + euclideanWaypoint.size());
        for (int i = 0; i < euclideanWaypoint.size(); ++i) {
            this.appendWaypointUnsafe((EuclideanTrajectoryPointBasics)euclideanWaypoint.get(i));
        }
    }

    public void appendWaypoints(TrajectoryPointListBasics<? extends EuclideanTrajectoryPointBasics> trajectoryPointList) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + trajectoryPointList.getNumberOfTrajectoryPoints());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.appendWaypointUnsafe(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    private void checkNumberOfWaypoints(int length) {
        if (length > this.maximumNumberOfWaypoints) {
            throw new RuntimeException("Cannot exceed the maximum number of waypoints. Number of waypoints provided: " + length);
        }
    }

    @Override
    public void initialize() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            throw new RuntimeException("Trajectory has no waypoints.");
        }
        this.currentWaypointIndex.set(0);
        if (this.numberOfWaypoints.getIntegerValue() == 1) {
            this.subTrajectory.setConstant((Point3DReadOnly)this.waypoints.get(0).getPosition());
        } else {
            this.initializeSubTrajectory(0);
        }
    }

    private void initializeSubTrajectory(int waypointIndex) {
        int secondWaypointIndex = Math.min(waypointIndex + 1, this.numberOfWaypoints.getValue() - 1);
        YoFrameEuclideanTrajectoryPoint start = this.waypoints.get(waypointIndex);
        YoFrameEuclideanTrajectoryPoint end = this.waypoints.get(secondWaypointIndex);
        this.subTrajectory.setCubic(0.0, end.getTime() - start.getTime(), (Point3DReadOnly)start.getPosition(), (Vector3DReadOnly)start.getLinearVelocity(), (Point3DReadOnly)end.getPosition(), (Vector3DReadOnly)end.getLinearVelocity());
    }

    @Override
    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentTrajectoryTime.set(time);
        boolean changedSubTrajectory = false;
        if (time < this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime()) {
            this.currentWaypointIndex.set(0);
            changedSubTrajectory = true;
        }
        while (this.currentWaypointIndex.getIntegerValue() < this.numberOfWaypoints.getIntegerValue() - 2 && time >= this.waypoints.get(this.currentWaypointIndex.getIntegerValue() + 1).getTime()) {
            this.currentWaypointIndex.increment();
            changedSubTrajectory = true;
        }
        if (changedSubTrajectory) {
            this.initializeSubTrajectory(this.currentWaypointIndex.getIntegerValue());
        }
        int secondWaypointIndex = Math.min(this.currentWaypointIndex.getValue() + 1, this.numberOfWaypoints.getValue() - 1);
        YoFrameEuclideanTrajectoryPoint start = this.waypoints.get(this.currentWaypointIndex.getValue());
        YoFrameEuclideanTrajectoryPoint end = this.waypoints.get(secondWaypointIndex);
        if (time < start.getTime()) {
            this.currentPosition.set((FrameTuple3DReadOnly)start.getPosition());
            this.currentVelocity.setToZero();
            this.currentAcceleration.setToZero();
            return;
        }
        if (time > end.getTime()) {
            this.currentPosition.set((FrameTuple3DReadOnly)end.getPosition());
            this.currentVelocity.setToZero();
            this.currentAcceleration.setToZero();
            return;
        }
        if (Precision.equals((double)start.getTime(), (double)end.getTime())) {
            this.currentPosition.set((FrameTuple3DReadOnly)start.getPosition());
            this.currentVelocity.set((FrameTuple3DReadOnly)start.getLinearVelocity());
            this.currentAcceleration.setToZero();
            return;
        }
        double subTrajectoryTime = MathTools.clamp((double)(time - start.getTime()), (double)0.0, (double)(end.getTime() - start.getTime()));
        this.subTrajectory.compute(subTrajectoryTime);
        this.currentPosition.set((Tuple3DReadOnly)this.subTrajectory.getPosition());
        this.currentVelocity.set((Tuple3DReadOnly)this.subTrajectory.getVelocity());
        this.currentAcceleration.set((Tuple3DReadOnly)this.subTrajectory.getAcceleration());
    }

    @Override
    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentWaypointIndex.getIntegerValue() >= this.numberOfWaypoints.getIntegerValue() - 2;
        if (!isLastWaypoint) {
            return false;
        }
        return this.currentTrajectoryTime.getValue() >= this.waypoints.get(this.currentWaypointIndex.getValue() + 1).getTime();
    }

    public boolean isEmpty() {
        return this.numberOfWaypoints.getIntegerValue() == 0;
    }

    public int getCurrentWaypointIndex() {
        return this.currentWaypointIndex.getIntegerValue();
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.currentPosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.currentVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.currentAcceleration;
    }

    public int getCurrentNumberOfWaypoints() {
        return this.numberOfWaypoints.getIntegerValue();
    }

    public YoFrameEuclideanTrajectoryPoint getWaypoint(int idx) {
        return this.waypoints.get(idx);
    }

    public int getMaximumNumberOfWaypoints() {
        return this.maximumNumberOfWaypoints;
    }

    public double getLastWaypointTime() {
        return this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime();
    }

    public String toString() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            return this.namePrefix + ": Has no waypoints.";
        }
        return this.namePrefix + ": number of waypoints = " + this.numberOfWaypoints.getIntegerValue() + ", current waypoint index = " + this.currentWaypointIndex.getIntegerValue() + "\nFirst waypoint: " + this.waypoints.get(0) + ", last waypoint: " + this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1);
    }
}

