/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MultipleWaypointsPoseTrajectoryGenerator
implements FixedFramePoseTrajectoryGenerator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final MultipleWaypointsPositionTrajectoryGenerator positionTrajectory;
    private final MultipleWaypointsOrientationTrajectoryGenerator orientationTrajectory;
    private ReferenceFrame activeFrame;
    private final FramePose3DReadOnly pose;

    public MultipleWaypointsPoseTrajectoryGenerator(String namePrefix, int maxNumberOfWaypoints, YoRegistry parentRegistry) {
        this.positionTrajectory = new MultipleWaypointsPositionTrajectoryGenerator(namePrefix, maxNumberOfWaypoints, worldFrame, parentRegistry);
        this.orientationTrajectory = new MultipleWaypointsOrientationTrajectoryGenerator(namePrefix, maxNumberOfWaypoints, worldFrame, parentRegistry);
        this.activeFrame = worldFrame;
        this.pose = new FramePose3DReadOnly(){

            public FramePoint3DReadOnly getPosition() {
                return MultipleWaypointsPoseTrajectoryGenerator.this.positionTrajectory.getPosition();
            }

            public FrameQuaternionReadOnly getOrientation() {
                return MultipleWaypointsPoseTrajectoryGenerator.this.orientationTrajectory.getOrientation();
            }

            public ReferenceFrame getReferenceFrame() {
                return MultipleWaypointsPoseTrajectoryGenerator.this.activeFrame;
            }
        };
    }

    public void clear(ReferenceFrame referenceFrame) {
        this.positionTrajectory.clear(referenceFrame);
        this.orientationTrajectory.clear(referenceFrame);
        this.activeFrame = referenceFrame;
    }

    public MultipleWaypointsPositionTrajectoryGenerator getPositionTrajectory() {
        return this.positionTrajectory;
    }

    public void appendPoseWaypoint(FrameSE3TrajectoryPoint waypoint) {
        waypoint.changeFrame(this.activeFrame);
        this.positionTrajectory.appendWaypoint(waypoint);
        this.orientationTrajectory.appendWaypoint(waypoint);
    }

    public void appendPoseWaypoint(double timeAtWaypoint, FramePose3D pose, FrameVector3D linearVelocity, FrameVector3D angularVelocity) {
        pose.changeFrame(this.activeFrame);
        linearVelocity.changeFrame(this.activeFrame);
        angularVelocity.changeFrame(this.activeFrame);
        this.positionTrajectory.appendWaypoint(timeAtWaypoint, (FramePoint3DReadOnly)pose.getPosition(), (FrameVector3DReadOnly)linearVelocity);
        this.orientationTrajectory.appendWaypoint(timeAtWaypoint, (FrameQuaternionReadOnly)pose.getOrientation(), (FrameVector3DReadOnly)angularVelocity);
    }

    public void appendPositionWaypoint(double timeAtWaypoint, FramePoint3D position, FrameVector3D linearVelocity) {
        position.changeFrame(this.activeFrame);
        linearVelocity.changeFrame(this.activeFrame);
        this.positionTrajectory.appendWaypoint(timeAtWaypoint, (FramePoint3DReadOnly)position, (FrameVector3DReadOnly)linearVelocity);
    }

    public void appendPositionWaypoint(FrameEuclideanTrajectoryPoint positionWaypoint) {
        positionWaypoint.changeFrame(this.activeFrame);
        this.positionTrajectory.appendWaypoint(positionWaypoint);
    }

    public void appendOrientationWaypoint(double timeAtWaypoint, FrameQuaternion orientation, FrameVector3D angularVelocity) {
        orientation.changeFrame(this.activeFrame);
        angularVelocity.changeFrame(this.activeFrame);
        this.orientationTrajectory.appendWaypoint(timeAtWaypoint, (FrameQuaternionReadOnly)orientation, (FrameVector3DReadOnly)angularVelocity);
    }

    public void changeFrame(ReferenceFrame referenceFrame) {
        this.positionTrajectory.changeFrame(referenceFrame);
        this.orientationTrajectory.changeFrame(referenceFrame);
        this.activeFrame = referenceFrame;
    }

    public int getCurrentPositionWaypointIndex() {
        return this.positionTrajectory.getCurrentWaypointIndex();
    }

    @Override
    public void initialize() {
        this.positionTrajectory.initialize();
        this.orientationTrajectory.initialize();
    }

    @Override
    public void compute(double time) {
        this.positionTrajectory.compute(time);
        this.orientationTrajectory.compute(time);
    }

    @Override
    public boolean isDone() {
        return this.positionTrajectory.isDone() && this.orientationTrajectory.isDone();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.activeFrame;
    }

    @Override
    public FramePose3DReadOnly getPose() {
        return this.pose;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.positionTrajectory.getVelocity();
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.positionTrajectory.getAcceleration();
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.orientationTrajectory.getAngularVelocity();
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.orientationTrajectory.getAngularAcceleration();
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }
}

