/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.ArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.HermiteCurveBasedOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.OrientationTrajectoryGeneratorInMultipleFrames;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoFrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSO3TrajectoryPointList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MultipleWaypointsOrientationTrajectoryGenerator
extends OrientationTrajectoryGeneratorInMultipleFrames {
    private final String namePrefix;
    private final int maximumNumberOfWaypoints;
    private final YoRegistry registry;
    private final YoDouble currentTrajectoryTime;
    private final YoInteger numberOfWaypoints;
    private final YoInteger currentWaypointIndex;
    private final ArrayList<YoFrameSO3TrajectoryPoint> waypoints;
    private final HermiteCurveBasedOrientationTrajectoryGenerator subTrajectory;

    public MultipleWaypointsOrientationTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, 30, referenceFrame, parentRegistry);
    }

    public MultipleWaypointsOrientationTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfWaypoints = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.numberOfWaypoints = new YoInteger(namePrefix + "NumberOfWaypoints", this.registry);
        this.numberOfWaypoints.set(0);
        this.waypoints = new ArrayList(maximumNumberOfWaypoints);
        this.currentTrajectoryTime = new YoDouble(namePrefix + "CurrentTrajectoryTime", this.registry);
        this.currentWaypointIndex = new YoInteger(namePrefix + "CurrentWaypointIndex", this.registry);
        this.subTrajectory = new HermiteCurveBasedOrientationTrajectoryGenerator(namePrefix + "SubTrajectory", referenceFrame, this.registry);
        this.registerFrameChangeables(this.subTrajectory);
        for (int i = 0; i < maximumNumberOfWaypoints; ++i) {
            YoFrameSO3TrajectoryPoint waypoint = new YoFrameSO3TrajectoryPoint(namePrefix, "AtWaypoint" + i, this.registry);
            this.registerFrameChangeables(waypoint);
            this.waypoints.add(waypoint);
        }
        this.clear(referenceFrame);
        parentRegistry.addChild(this.registry);
    }

    public void clear() {
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
        for (int i = 0; i < this.maximumNumberOfWaypoints; ++i) {
            this.waypoints.get(i).setToNaN();
        }
    }

    public void clear(ReferenceFrame referenceFrame) {
        this.clear();
        this.setReferenceFrame(referenceFrame);
    }

    public void appendWaypoint(double timeAtWaypoint, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, orientation, angularVelocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, QuaternionReadOnly orientation, Vector3DReadOnly angularVelocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, orientation, angularVelocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(double timeAtWaypoint, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, orientation, angularVelocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, FrameQuaternionReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, orientation, angularVelocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoint(SO3TrajectoryPointBasics so3Waypoint) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(so3Waypoint);
    }

    public void appendWaypoint(FrameSO3TrajectoryPoint frameSO3TrajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameSO3TrajectoryPoint);
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(frameSO3TrajectoryPoint);
    }

    public void appendWaypoint(FrameSE3TrajectoryPoint frameSE3TrajectoryPoint) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameSE3TrajectoryPoint);
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(frameSE3TrajectoryPoint);
    }

    private void appendWaypointUnsafe(SO3TrajectoryPointBasics so3Waypoint) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(so3Waypoint);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoints(double[] timeAtWaypoints, QuaternionReadOnly[] orientations, Vector3DReadOnly[] angularVelocities) {
        if (timeAtWaypoints.length != orientations.length || angularVelocities != null && orientations.length != angularVelocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], orientations[i], angularVelocities[i]);
        }
    }

    public void appendWaypoints(double[] timeAtWaypoints, FrameQuaternionReadOnly[] orientations, FrameVector3DReadOnly[] angularVelocities) {
        if (timeAtWaypoints.length != orientations.length || orientations.length != angularVelocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], orientations[i], angularVelocities[i]);
        }
    }

    public void appendWaypoints(SO3TrajectoryPointBasics[] so3Waypoints) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + so3Waypoints.length);
        for (int i = 0; i < so3Waypoints.length; ++i) {
            this.appendWaypointUnsafe(so3Waypoints[i]);
        }
    }

    public void appendWaypoints(TrajectoryPointListBasics<? extends SO3TrajectoryPointBasics> trajectoryPointList) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + trajectoryPointList.getNumberOfTrajectoryPoints());
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            this.appendWaypointUnsafe(trajectoryPointList.getTrajectoryPoint(i));
        }
    }

    public void appendWaypoints(FrameSO3TrajectoryPointList trajectoryPointList) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + trajectoryPointList.getNumberOfTrajectoryPoints());
        this.checkReferenceFrameMatch((ReferenceFrameHolder)trajectoryPointList);
        for (int i = 0; i < trajectoryPointList.getNumberOfTrajectoryPoints(); ++i) {
            FrameSO3TrajectoryPoint trajectoryPoint = trajectoryPointList.getTrajectoryPoint(i);
            this.checkReferenceFrameMatch((ReferenceFrameHolder)trajectoryPoint);
            this.appendWaypointUnsafe(trajectoryPoint);
        }
    }

    private void checkNumberOfWaypoints(int length) {
        if (length > this.maximumNumberOfWaypoints) {
            throw new RuntimeException("Cannot exceed the maximum number of waypoints. Number of waypoints provided: " + length);
        }
    }

    @Override
    public void initialize() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            throw new RuntimeException("Trajectory has no waypoints.");
        }
        this.currentWaypointIndex.set(0);
        this.initializeSubTrajectory(0);
    }

    private void initializeSubTrajectory(int waypointIndex) {
        int secondWaypointIndex = Math.min(waypointIndex + 1, this.numberOfWaypoints.getValue() - 1);
        this.subTrajectory.setTrajectoryParameters(this.waypoints.get(waypointIndex), this.waypoints.get(secondWaypointIndex));
        this.subTrajectory.initialize();
    }

    @Override
    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentTrajectoryTime.set(time);
        boolean changedSubTrajectory = false;
        if (time < this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime()) {
            this.currentWaypointIndex.set(0);
            changedSubTrajectory = true;
        }
        while (this.currentWaypointIndex.getIntegerValue() < this.numberOfWaypoints.getIntegerValue() - 2 && time >= this.waypoints.get(this.currentWaypointIndex.getIntegerValue() + 1).getTime()) {
            this.currentWaypointIndex.increment();
            changedSubTrajectory = true;
        }
        if (changedSubTrajectory) {
            this.initializeSubTrajectory(this.currentWaypointIndex.getIntegerValue());
        }
        double subTrajectoryTime = time - this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime();
        this.subTrajectory.compute(subTrajectoryTime);
    }

    @Override
    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentWaypointIndex.getIntegerValue() >= this.numberOfWaypoints.getIntegerValue() - 2;
        if (!isLastWaypoint) {
            return false;
        }
        boolean subTrajectoryIsDone = this.subTrajectory.isDone();
        return subTrajectoryIsDone;
    }

    public boolean isEmpty() {
        return this.numberOfWaypoints.getIntegerValue() == 0;
    }

    public int getCurrentWaypointIndex() {
        return this.currentWaypointIndex.getIntegerValue();
    }

    public FrameQuaternionReadOnly getOrientation() {
        return this.subTrajectory.getOrientation();
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.subTrajectory.getAngularVelocity();
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.subTrajectory.getAngularAcceleration();
    }

    public int getCurrentNumberOfWaypoints() {
        return this.numberOfWaypoints.getIntegerValue();
    }

    public int getMaximumNumberOfWaypoints() {
        return this.maximumNumberOfWaypoints;
    }

    public double getLastWaypointTime() {
        return this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime();
    }

    public void getLastWaypoint(FrameSO3TrajectoryPointBasics pointToPack) {
        pointToPack.set(this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1));
    }

    public FrameSO3TrajectoryPointBasics getWaypoint(int index) {
        return this.waypoints.get(index);
    }

    public void removeLastWaypoint() {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).setToNaN();
        this.numberOfWaypoints.decrement();
    }

    public String toString() {
        if (this.numberOfWaypoints.getIntegerValue() == 0) {
            return this.namePrefix + ": Has no waypoints.";
        }
        return this.namePrefix + ": number of waypoints = " + this.numberOfWaypoints.getIntegerValue() + ", current waypoint index = " + this.currentWaypointIndex.getIntegerValue() + "\nFirst waypoint: " + this.waypoints.get(0) + ", last waypoint: " + this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1);
    }
}

