/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import gnu.trove.list.array.TDoubleArrayList;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;

public class MultiCubicSpline1DSolver {
    public static final int coefficients = 4;
    private static final double regularizationWeight = 1.0E-10;
    private double x0;
    private double x1;
    private double xd0;
    private double xd1;
    private final TDoubleArrayList xi = new TDoubleArrayList();
    private final TDoubleArrayList ti = new TDoubleArrayList();
    private double w0;
    private double w1;
    private double wd0;
    private double wd1;
    private final TDoubleArrayList wi = new TDoubleArrayList();
    private final DMatrixRMaj H_minAccel = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj H = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj f = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj A = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj ATranspose = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj b = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj E = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj d = new DMatrixRMaj(1, 1);

    public MultiCubicSpline1DSolver() {
        this.clearWeights();
    }

    public void clearWeights() {
        this.w0 = Double.POSITIVE_INFINITY;
        this.w1 = Double.POSITIVE_INFINITY;
        this.wd0 = Double.POSITIVE_INFINITY;
        this.wd1 = Double.POSITIVE_INFINITY;
        this.wi.fill(0, this.xi.size(), Double.POSITIVE_INFINITY);
    }

    public void setEndpoints(double startPosition, double startVelocity, double targetPosition, double targetVelocity) {
        this.x0 = startPosition;
        this.x1 = targetPosition;
        this.xd0 = startVelocity;
        this.xd1 = targetVelocity;
    }

    public void setEndpointWeights(double startPositionWeight, double startVelocityWeight, double targetPositionWeight, double targetVelocityWeight) {
        MultiCubicSpline1DSolver.checkWeightValue(startPositionWeight);
        MultiCubicSpline1DSolver.checkWeightValue(targetPositionWeight);
        MultiCubicSpline1DSolver.checkWeightValue(startVelocityWeight);
        MultiCubicSpline1DSolver.checkWeightValue(targetVelocityWeight);
        this.w0 = startPositionWeight;
        this.w1 = targetPositionWeight;
        this.wd0 = startVelocityWeight;
        this.wd1 = targetVelocityWeight;
    }

    public void clearWaypoints() {
        this.xi.reset();
        this.ti.reset();
        this.wi.clear();
    }

    public void addWaypoint(double position, double time) {
        this.addWaypoint(position, time, Double.POSITIVE_INFINITY);
    }

    public void addWaypoint(double position, double time, double weight) {
        if (time <= 0.0 || time >= 1.0) {
            throw new IllegalArgumentException("The time for a waypoint should be in ]0, 1[, was: " + time);
        }
        MultiCubicSpline1DSolver.checkWeightValue(weight);
        this.xi.add(position);
        this.ti.add(time);
        this.wi.add(weight);
    }

    private static void checkWeightValue(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("A weight should be in [0, +Infinity[, was: " + weight);
        }
    }

    public double solve(DMatrixRMaj solutionToPack) {
        this.buildCostFunction(this.H_minAccel, this.H, this.f);
        this.buildKnotEqualityConstraints(this.A, this.b);
        int subProblemSize = 4 * (this.xi.size() + 1);
        int constraints = this.computeNumberOfEqualityConstraints();
        int size = subProblemSize + constraints;
        this.E.reshape(size, size);
        this.d.reshape(size, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.E, (double)0.0);
        CommonOps_DDRM.insert((DMatrix)this.H, (DMatrix)this.E, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.A, (DMatrix)this.E, (int)subProblemSize, (int)0);
        this.ATranspose.reshape(this.A.getNumCols(), this.A.getNumRows());
        CommonOps_DDRM.transpose((DMatrixRMaj)this.A, (DMatrixRMaj)this.ATranspose);
        CommonOps_DDRM.insert((DMatrix)this.ATranspose, (DMatrix)this.E, (int)0, (int)subProblemSize);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.f);
        CommonOps_DDRM.insert((DMatrix)this.f, (DMatrix)this.d, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.b, (DMatrix)this.d, (int)subProblemSize, (int)0);
        NativeCommonOps.solve((DMatrix1Row)this.E, (DMatrix1Row)this.d, (DMatrix1Row)solutionToPack);
        solutionToPack.reshape(subProblemSize, 1);
        NativeCommonOps.multQuad((DMatrix1Row)solutionToPack, (DMatrix1Row)this.H_minAccel, (DMatrix1Row)this.b);
        return 0.5 * this.b.get(0, 0);
    }

    private void buildKnotEqualityConstraints(DMatrixRMaj A, DMatrixRMaj b) {
        int constraints = this.computeNumberOfEqualityConstraints();
        int subProblemSize = 4 * (this.xi.size() + 1);
        A.reshape(constraints, subProblemSize);
        b.reshape(constraints, 1);
        CommonOps_DDRM.fill((DMatrixD1)A, (double)0.0);
        int line = 0;
        if (this.w0 == Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.getPositionConstraintABlock(0.0, line, 0, A);
            b.set(line, this.x0);
            ++line;
        }
        if (this.wd0 == Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.getVelocityConstraintABlock(0.0, line, 0, A);
            b.set(line, this.xd0);
            ++line;
        }
        for (int i = 0; i < this.xi.size(); ++i) {
            int colOffset = i * 4;
            if (this.wi.get(i) == Double.POSITIVE_INFINITY) {
                MultiCubicSpline1DSolver.getPositionConstraintABlock(this.ti.get(i), line, colOffset, A);
                b.set(line, this.xi.get(i));
                CommonOps_DDRM.extract((DMatrix)A, (int)line, (int)(line + 1), (int)colOffset, (int)(colOffset + 4), (DMatrix)A, (int)(line + 1), (int)(colOffset + 4));
                b.set(++line, this.xi.get(i));
                ++line;
            }
            MultiCubicSpline1DSolver.getVelocityConstraintABlock(this.ti.get(i), line, colOffset, A);
            MatrixTools.setMatrixBlock((DMatrix)A, (int)line, (int)(colOffset + 4), (DMatrix)A, (int)line, (int)colOffset, (int)1, (int)4, (double)-1.0);
            b.set(line, 0.0);
            ++line;
        }
        if (this.w1 == Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.getPositionConstraintABlock(1.0, line, subProblemSize - 4, A);
            b.set(line, this.x1);
            ++line;
        }
        if (this.wd1 == Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.getVelocityConstraintABlock(1.0, line, subProblemSize - 4, A);
            b.set(line, this.xd1);
        }
    }

    private int computeNumberOfEqualityConstraints() {
        int constraints = 0;
        if (this.w0 == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        if (this.w1 == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        if (this.wd0 == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        if (this.wd1 == Double.POSITIVE_INFINITY) {
            ++constraints;
        }
        for (int i = 0; i < this.xi.size(); ++i) {
            if (this.wi.get(i) == Double.POSITIVE_INFINITY) {
                constraints += 2;
            }
            ++constraints;
        }
        return constraints;
    }

    private void buildCostFunction(DMatrixRMaj H_minAccel, DMatrixRMaj H, DMatrixRMaj f) {
        int size = 4 * (this.xi.size() + 1);
        H_minAccel.reshape(size, size);
        CommonOps_DDRM.fill((DMatrixD1)H_minAccel, (double)0.0);
        f.reshape(size, 1);
        CommonOps_DDRM.fill((DMatrixD1)f, (double)1.0E-10);
        this.getMinAccelerationCostFunction(H_minAccel);
        H.set((DMatrixD1)H_minAccel);
        this.addKnotsCostFunction(H, f);
    }

    private void getMinAccelerationCostFunction(DMatrixRMaj H) {
        double t0 = 0.0;
        double t1 = 0.0;
        for (int i = 0; i < this.xi.size(); ++i) {
            t0 = t1;
            t1 = this.ti.get(i);
            int offset = i * 4;
            MultiCubicSpline1DSolver.getMinAccelerationHBlock(t0, t1, offset, offset, H);
        }
        t0 = t1;
        t1 = 1.0;
        int offset = this.xi.size() * 4;
        MultiCubicSpline1DSolver.getMinAccelerationHBlock(t0, t1, offset, offset, H);
    }

    private void addKnotsCostFunction(DMatrixRMaj H, DMatrixRMaj f) {
        int offset = 0;
        if (this.w0 != Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.addPositionObjective(0.0, this.x0, this.w0, offset, offset, H, f);
        }
        if (this.wd0 != Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.addVelocityObjective(0.0, this.xd0, this.wd0, offset, offset, H, f);
        }
        for (int i = 0; i < this.xi.size(); ++i) {
            if (this.wi.get(i) != Double.POSITIVE_INFINITY) {
                MultiCubicSpline1DSolver.addPositionObjective(this.ti.get(i), this.xi.get(i), this.wi.get(i), offset, offset, H, f);
                MultiCubicSpline1DSolver.addPositionObjective(this.ti.get(i), this.xi.get(i), this.wi.get(i), offset += 4, offset, H, f);
                continue;
            }
            offset += 4;
        }
        if (this.w1 != Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.addPositionObjective(1.0, this.x1, this.w1, offset, offset, H, f);
        }
        if (this.wd1 != Double.POSITIVE_INFINITY) {
            MultiCubicSpline1DSolver.addVelocityObjective(1.0, this.xd1, this.wd1, offset, offset, H, f);
        }
    }

    static void getPositionConstraintABlock(double t, int row, int startColumn, DMatrixRMaj A) {
        A.set(row, startColumn + 3, 1.0);
        double tpow = t;
        A.set(row, startColumn + 2, tpow);
        A.set(row, startColumn + 1, tpow *= t);
        A.set(row, startColumn, tpow *= t);
    }

    static void getVelocityConstraintABlock(double t, int row, int startColumn, DMatrixRMaj A) {
        A.set(row, startColumn + 3, 0.0);
        A.set(row, startColumn + 2, 1.0);
        double tpow = t;
        A.set(row, startColumn + 1, 2.0 * tpow);
        A.set(row, startColumn, 3.0 * (tpow *= t));
    }

    static void getMinAccelerationHBlock(double t0, double t1, int startRow, int startColumn, DMatrixRMaj H) {
        double t0pow = t0;
        double t1pow = t1;
        H.set(startRow + 1, startColumn + 1, 4.0 * (t1pow - t0pow));
        H.set(startRow + 1, startColumn + 0, 6.0 * ((t1pow *= t1) - (t0pow *= t0)));
        H.set(startRow + 0, startColumn + 1, 6.0 * (t1pow - t0pow));
        H.set(startRow + 0, startColumn + 0, 12.0 * ((t1pow *= t1) - (t0pow *= t0)));
    }

    static void addPositionObjective(double t, double x, double weight, int startRow, int startColumn, DMatrixRMaj H, DMatrixRMaj f) {
        double tpow = weight;
        H.add(startRow + 3, startColumn + 3, tpow);
        H.add(startRow + 3, startColumn + 2, tpow *= t);
        H.add(startRow + 2, startColumn + 3, tpow);
        H.add(startRow + 3, startColumn + 1, tpow *= t);
        H.add(startRow + 2, startColumn + 2, tpow);
        H.add(startRow + 1, startColumn + 3, tpow);
        H.add(startRow + 3, startColumn + 0, tpow *= t);
        H.add(startRow + 2, startColumn + 1, tpow);
        H.add(startRow + 1, startColumn + 2, tpow);
        H.add(startRow + 0, startColumn + 3, tpow);
        H.add(startRow + 2, startColumn + 0, tpow *= t);
        H.add(startRow + 1, startColumn + 1, tpow);
        H.add(startRow + 0, startColumn + 2, tpow);
        H.add(startRow + 1, startColumn + 0, tpow *= t);
        H.add(startRow + 0, startColumn + 1, tpow);
        H.add(startRow + 0, startColumn + 0, tpow *= t);
        tpow = -weight * x;
        f.add(startRow + 3, 0, tpow);
        f.add(startRow + 2, 0, tpow *= t);
        f.add(startRow + 1, 0, tpow *= t);
        f.add(startRow, 0, tpow *= t);
    }

    static void addVelocityObjective(double t, double xd, double weight, int startRow, int startColumn, DMatrixRMaj H, DMatrixRMaj f) {
        double tpow = weight;
        H.add(startRow + 2, startColumn + 2, tpow);
        H.add(startRow + 2, startColumn + 1, 2.0 * (tpow *= t));
        H.add(startRow + 1, startColumn + 2, 2.0 * tpow);
        H.add(startRow + 2, startColumn + 0, 3.0 * (tpow *= t));
        H.add(startRow + 1, startColumn + 1, 4.0 * tpow);
        H.add(startRow + 0, startColumn + 2, 3.0 * tpow);
        H.add(startRow + 1, startColumn + 0, 6.0 * (tpow *= t));
        H.add(startRow + 0, startColumn + 1, 6.0 * tpow);
        H.add(startRow + 0, startColumn + 0, 9.0 * (tpow *= t));
        tpow = -weight * xd;
        f.add(startRow + 2, 0, tpow);
        f.add(startRow + 1, 0, 2.0 * (tpow *= t));
        f.add(startRow, 0, 3.0 * (tpow *= t));
    }
}

