/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.core;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Polynomial3DFrameFactories {
    public static FramePoint3DReadOnly newLinkedFramePoint3DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Tuple3DReadOnly originalPoint) {
        return new FramePoint3DReadOnly(){

            public double getX() {
                return originalPoint.getX();
            }

            public double getY() {
                return originalPoint.getY();
            }

            public double getZ() {
                return originalPoint.getZ();
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FramePoint3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)((FramePoint3DReadOnly)object));
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return EuclidFrameIOTools.getFrameTuple3DString((FrameTuple3DReadOnly)this);
            }
        };
    }

    public static FramePoint3DBasics newLinkedFramePoint3DBasics(final ReferenceFrameHolder referenceFrameHolder, final Tuple3DBasics originalPoint) {
        return new FramePoint3DBasics(){

            public void setReferenceFrame(ReferenceFrame referenceFrame) {
            }

            public void setX(double x) {
                originalPoint.setX(x);
            }

            public void setY(double y) {
                originalPoint.setY(y);
            }

            public void setZ(double z) {
                originalPoint.setZ(z);
            }

            public double getX() {
                return originalPoint.getX();
            }

            public double getY() {
                return originalPoint.getY();
            }

            public double getZ() {
                return originalPoint.getZ();
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FramePoint3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)((FramePoint3DReadOnly)object));
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return EuclidFrameIOTools.getFrameTuple3DString((FrameTuple3DReadOnly)this);
            }
        };
    }

    public static FrameVector3DReadOnly newLinkedFrameVector3DReadOnly(final ReferenceFrameHolder referenceFrameHolder, final Vector3DReadOnly originalVector) {
        return new FrameVector3DReadOnly(){

            public double getX() {
                return originalVector.getX();
            }

            public double getY() {
                return originalVector.getY();
            }

            public double getZ() {
                return originalVector.getZ();
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameVector3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)((FrameVector3DReadOnly)object));
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return EuclidFrameIOTools.getFrameTuple3DString((FrameTuple3DReadOnly)this);
            }
        };
    }

    public static FrameVector3DBasics newLinkedFrameVector3DBasics(final ReferenceFrameHolder referenceFrameHolder, final Tuple3DBasics originalPoint) {
        return new FrameVector3DBasics(){

            public void setReferenceFrame(ReferenceFrame referenceFrame) {
            }

            public void setX(double x) {
                originalPoint.setX(x);
            }

            public void setY(double y) {
                originalPoint.setY(y);
            }

            public void setZ(double z) {
                originalPoint.setZ(z);
            }

            public double getX() {
                return originalPoint.getX();
            }

            public double getY() {
                return originalPoint.getY();
            }

            public double getZ() {
                return originalPoint.getZ();
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FramePoint3DReadOnly) {
                    return this.equals((FrameTuple3DReadOnly)((FramePoint3DReadOnly)object));
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()), (Object)this.getReferenceFrame());
            }

            public String toString() {
                return EuclidFrameIOTools.getFrameTuple3DString((FrameTuple3DReadOnly)this);
            }
        };
    }
}

