/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.interpolators.OrientationInterpolationCalculator;
import us.ihmc.robotics.math.trajectories.OrientationTrajectoryGeneratorInMultipleFrames;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimpleOrientationTrajectoryGenerator
extends OrientationTrajectoryGeneratorInMultipleFrames {
    private final YoRegistry registry;
    private final YoDouble currentTime;
    private final YoDouble trajectoryTime;
    private final YoPolynomial parameterPolynomial;
    private final FrameQuaternionBasics initialOrientation;
    private final FrameQuaternionBasics finalOrientation;
    private final FrameQuaternionBasics currentOrientation;
    private final FrameVector3DBasics currentAngularVelocity;
    private final FrameVector3DBasics currentAngularAcceleration;
    private final OrientationInterpolationCalculator orientationInterpolationCalculator = new OrientationInterpolationCalculator();

    public SimpleOrientationTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, false, referenceFrame, parentRegistry);
    }

    public SimpleOrientationTrajectoryGenerator(String namePrefix, boolean allowMultipleFrames, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentTime = new YoDouble(namePrefix + "Time", this.registry);
        this.parameterPolynomial = new YoPolynomial(namePrefix + "ParameterPolynomial", 6, this.registry);
        String initialOrientationName = namePrefix + "InitialOrientation";
        String finalOrientationName = namePrefix + "FinalOrientation";
        String currentOrientationName = namePrefix + "CurrentOrientation";
        String currentAngularVelocityName = namePrefix + "CurrentAngularVelocity";
        String currentAngularAccelerationName = namePrefix + "CurrentAngularAcceleration";
        this.initialOrientation = new YoMutableFrameQuaternion(initialOrientationName, "", this.registry, referenceFrame);
        this.finalOrientation = new YoMutableFrameQuaternion(finalOrientationName, "", this.registry, referenceFrame);
        this.currentOrientation = new YoMutableFrameQuaternion(currentOrientationName, "", this.registry, referenceFrame);
        this.currentAngularVelocity = new YoMutableFrameVector3D(currentAngularVelocityName, "", this.registry, referenceFrame);
        this.currentAngularAcceleration = new YoMutableFrameVector3D(currentAngularAccelerationName, "", this.registry, referenceFrame);
        this.registerFrameChangeables(new FrameChangeable[]{this.initialOrientation, this.finalOrientation, this.currentOrientation, this.currentAngularVelocity, this.currentAngularAcceleration});
        parentRegistry.addChild(this.registry);
    }

    public void setInitialOrientation(FrameQuaternionReadOnly initialOrientation) {
        this.initialOrientation.setMatchingFrame(initialOrientation);
    }

    public void setFinalOrientation(FrameQuaternionReadOnly finalOrientation) {
        this.finalOrientation.setMatchingFrame(finalOrientation);
    }

    public void setTrajectoryTime(double newTrajectoryTime) {
        this.trajectoryTime.set(newTrajectoryTime);
    }

    @Override
    public void initialize() {
        this.currentTime.set(0.0);
        MathTools.checkIntervalContains((double)this.trajectoryTime.getDoubleValue(), (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.parameterPolynomial.setQuintic(0.0, this.trajectoryTime.getDoubleValue(), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.currentOrientation.set((FrameQuaternionReadOnly)this.initialOrientation);
        this.currentAngularVelocity.setToZero();
        this.currentAngularAcceleration.setToZero();
    }

    @Override
    public void compute(double time) {
        double alphaDDot;
        this.currentTime.set(time);
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.parameterPolynomial.compute(time);
        boolean shouldBeZero = this.isDone() || this.currentTime.getDoubleValue() < 0.0;
        double alphaDot = shouldBeZero ? 0.0 : this.parameterPolynomial.getVelocity();
        double d = alphaDDot = shouldBeZero ? 0.0 : this.parameterPolynomial.getAcceleration();
        if (!this.isDone() && this.trajectoryTime.getValue() >= 1.0E-6) {
            this.currentOrientation.interpolate((FrameQuaternionReadOnly)this.initialOrientation, (FrameQuaternionReadOnly)this.finalOrientation, this.parameterPolynomial.getValue());
            this.orientationInterpolationCalculator.computeAngularVelocity(this.currentAngularVelocity, this.initialOrientation, this.finalOrientation, alphaDot);
            this.orientationInterpolationCalculator.computeAngularAcceleration(this.currentAngularAcceleration, this.initialOrientation, this.finalOrientation, alphaDDot);
        } else {
            this.currentOrientation.set((FrameQuaternionReadOnly)this.finalOrientation);
            this.currentAngularVelocity.setToZero();
            this.currentAngularAcceleration.setToZero();
        }
    }

    @Override
    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    public FrameQuaternionReadOnly getOrientation() {
        return this.currentOrientation;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.currentAngularVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.currentAngularAcceleration;
    }

    public String toString() {
        String ret = "";
        ret = ret + "Current time: " + this.currentTime.getDoubleValue() + ", trajectory time: " + this.trajectoryTime.getDoubleValue();
        ret = ret + "\nCurrent orientation: " + this.currentOrientation.toString();
        ret = ret + "\nCurrent angular velocity: " + this.currentAngularVelocity.toString();
        ret = ret + "\nCurrent angular acceleration: " + this.currentAngularAcceleration.toString();
        return ret;
    }
}

