/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class SimpleHermiteCurvedBasedOrientationTrajectoryCalculator {
    private double trajectoryTime;
    private int numberOfRevolutions;
    private double[] cumulativeBeziers;
    private double[] cumulativeBeziersDot;
    private double[] cumulativeBeziersDDot;
    private final Vector3DBasics[] controlRotations;
    private final QuaternionBasics currentOrientation;
    private final Vector3DBasics currentAngularVelocity;
    private final Vector3DBasics currentAngularAcceleration;
    private final QuaternionBasics initialOrientation;
    private final Vector3DBasics initialAngularVelocity;
    private final QuaternionBasics finalOrientation;
    private final Vector3DBasics finalAngularVelocity;
    private static final double EPS = 1.0E-11;
    private boolean convertAngularVelocity = false;
    private boolean convertAngularAcceleration = true;
    Quaternion qProduct = new Quaternion();
    Vector4D qDot = new Vector4D();
    Vector4D qDot1 = new Vector4D();
    Vector4D qDot2 = new Vector4D();
    Vector4D qDot3 = new Vector4D();
    Vector4D qProductDot = new Vector4D();
    Vector4D qDDot = new Vector4D();
    Vector4D qDDot1 = new Vector4D();
    Vector4D qDDot2 = new Vector4D();
    Vector4D qDDot3 = new Vector4D();
    Vector4D qDDotTemp = new Vector4D();
    Vector4D qProductDDot = new Vector4D();
    Vector3D d1 = new Vector3D();
    Vector3D d2 = new Vector3D();
    Vector3D d3 = new Vector3D();
    Quaternion expD1B1 = new Quaternion();
    Quaternion expD2B2 = new Quaternion();
    Quaternion expD1B1_expD2B2 = new Quaternion();
    Quaternion expD3B3 = new Quaternion();
    Vector4D d1B1Dot = new Vector4D();
    Vector4D d2B2Dot = new Vector4D();
    Vector4D d3B3Dot = new Vector4D();
    Vector4D d1B1DDot = new Vector4D();
    Vector4D d2B2DDot = new Vector4D();
    Vector4D d3B3DDot = new Vector4D();
    Quaternion qInterpolated = new Quaternion();
    Vector3D angularVelocityInterpolated = new Vector3D();
    Vector3D angularAccelerationInterpolated = new Vector3D();
    Quaternion tempQuaternion = new Quaternion();
    Vector3D wa = new Vector3D();
    Vector3D wb = new Vector3D();
    Vector3D delta = new Vector3D();

    public SimpleHermiteCurvedBasedOrientationTrajectoryCalculator() {
        this.cumulativeBeziers = new double[4];
        this.cumulativeBeziersDot = new double[4];
        this.cumulativeBeziersDDot = new double[4];
        this.controlRotations = new Vector3D[4];
        for (int i = 0; i < 4; ++i) {
            this.controlRotations[i] = new Vector3D();
        }
        this.currentOrientation = new Quaternion();
        this.currentAngularVelocity = new Vector3D();
        this.currentAngularAcceleration = new Vector3D();
        this.initialOrientation = new Quaternion();
        this.initialAngularVelocity = new Vector3D();
        this.finalOrientation = new Quaternion();
        this.finalAngularVelocity = new Vector3D();
    }

    public void setNumberOfRevolutions(int numberOfRevolutions) {
        this.numberOfRevolutions = numberOfRevolutions;
    }

    public void setTrajectoryTime(double duration) {
        MathTools.checkIntervalContains((double)duration, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.trajectoryTime = duration;
    }

    public void setInitialConditions(QuaternionReadOnly initialOrientation, Vector3DReadOnly initialAngularVelocity) {
        this.initialOrientation.set(initialOrientation);
        this.initialAngularVelocity.set((Tuple3DReadOnly)initialAngularVelocity);
    }

    public void setFinalConditions(QuaternionReadOnly finalOrientation, Vector3DReadOnly finalAngularVelocity) {
        this.finalOrientation.set(finalOrientation);
        this.finalAngularVelocity.set((Tuple3DReadOnly)finalAngularVelocity);
    }

    public void initialize() {
        if (this.initialOrientation.dot((Tuple4DReadOnly)this.finalOrientation) < 0.0) {
            this.finalOrientation.negate();
        }
        this.updateControlQuaternions();
        this.compute(0.0);
    }

    private void updateControlQuaternions() {
        double TOverThree = this.trajectoryTime / 3.0;
        QuaternionBasics qa = this.initialOrientation;
        QuaternionBasics qb = this.finalOrientation;
        this.wa.set((Tuple3DReadOnly)this.initialAngularVelocity);
        this.wb.set((Tuple3DReadOnly)this.finalAngularVelocity);
        qa.inverseTransform((Tuple3DBasics)this.wa);
        qb.inverseTransform((Tuple3DBasics)this.wb);
        this.delta.setAndScale(TOverThree, (Tuple3DReadOnly)this.wa);
        this.controlRotations[1].set((Tuple3DReadOnly)this.delta);
        this.tempQuaternion.difference((QuaternionReadOnly)qa, (QuaternionReadOnly)qb);
        this.tempQuaternion.preMultiply(this.exp(-TOverThree, (Vector3DReadOnly)this.wa));
        this.tempQuaternion.multiply(this.exp(-TOverThree, (Vector3DReadOnly)this.wb));
        this.controlRotations[2].set((Tuple3DReadOnly)this.log((QuaternionReadOnly)this.tempQuaternion));
        if (this.numberOfRevolutions != 0) {
            this.delta.set((Tuple3DReadOnly)this.controlRotations[2]);
            if (this.delta.lengthSquared() > 1.0E-10) {
                this.delta.normalize();
                this.delta.scale((double)this.numberOfRevolutions * 2.0 * Math.PI);
                this.controlRotations[2].add((Tuple3DReadOnly)this.delta);
            }
        }
        this.delta.setAndScale(TOverThree, (Tuple3DReadOnly)this.wb);
        this.controlRotations[3].set((Tuple3DReadOnly)this.delta);
    }

    public void setConvertingAngularVelocity(boolean use) {
        this.convertAngularVelocity = use;
    }

    public void setConvertingAngularAcceleration(boolean use) {
        this.convertAngularAcceleration = use;
    }

    public void compute(double time) {
        if (Double.isNaN(time)) {
            throw new RuntimeException("Can not call compute on trajectory generator with time NaN.");
        }
        if (time < 0.0) {
            this.currentOrientation.set((QuaternionReadOnly)this.initialOrientation);
            this.currentAngularVelocity.setToZero();
            this.currentAngularAcceleration.setToZero();
            return;
        }
        if (time > this.trajectoryTime) {
            this.currentOrientation.set((QuaternionReadOnly)this.finalOrientation);
            this.currentAngularVelocity.setToZero();
            this.currentAngularAcceleration.setToZero();
            return;
        }
        if (this.trajectoryTime < 1.0E-11 && this.trajectoryTime >= 0.0) {
            this.currentOrientation.set((QuaternionReadOnly)this.initialOrientation);
            this.currentAngularVelocity.set((Tuple3DReadOnly)this.initialAngularVelocity);
            this.currentAngularAcceleration.setToZero();
            return;
        }
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime);
        this.computeBezierBasedCurve(time, (QuaternionBasics)this.qInterpolated, this.angularVelocityInterpolated, this.angularAccelerationInterpolated);
        this.currentOrientation.set((QuaternionReadOnly)this.qInterpolated);
        this.currentAngularVelocity.set((Tuple3DReadOnly)this.angularVelocityInterpolated);
        this.currentAngularAcceleration.set((Tuple3DReadOnly)this.angularAccelerationInterpolated);
    }

    private void computeBezierBasedCurve(double time, QuaternionBasics q, Vector3D angularVelocity, Vector3D angularAcceleration) {
        this.updateBezierCoefficients(time);
        QuaternionBasics q0 = this.initialOrientation;
        this.d1.set((Tuple3DReadOnly)this.controlRotations[1]);
        this.d2.set((Tuple3DReadOnly)this.controlRotations[2]);
        this.d3.set((Tuple3DReadOnly)this.controlRotations[3]);
        this.expD1B1.set(this.exp(this.cumulativeBeziers[1], (Vector3DReadOnly)this.d1));
        this.expD2B2.set(this.exp(this.cumulativeBeziers[2], (Vector3DReadOnly)this.d2));
        this.expD3B3.set(this.exp(this.cumulativeBeziers[3], (Vector3DReadOnly)this.d3));
        this.expD1B1_expD2B2.set(this.expD1B1);
        this.expD1B1_expD2B2.multiply((QuaternionReadOnly)this.expD2B2);
        this.d1B1Dot.set((Vector3DReadOnly)this.d1);
        this.d2B2Dot.set((Vector3DReadOnly)this.d2);
        this.d3B3Dot.set((Vector3DReadOnly)this.d3);
        this.d1B1Dot.scale(0.5 * this.cumulativeBeziersDot[1]);
        this.d2B2Dot.scale(0.5 * this.cumulativeBeziersDot[2]);
        this.d3B3Dot.scale(0.5 * this.cumulativeBeziersDot[3]);
        this.d1B1DDot.set((Vector3DReadOnly)this.d1);
        this.d2B2DDot.set((Vector3DReadOnly)this.d2);
        this.d3B3DDot.set((Vector3DReadOnly)this.d3);
        this.d1B1DDot.scale(0.5 * this.cumulativeBeziersDDot[1]);
        this.d2B2DDot.scale(0.5 * this.cumulativeBeziersDDot[2]);
        this.d3B3DDot.scale(0.5 * this.cumulativeBeziersDDot[3]);
        this.qProduct.set(this.expD1B1);
        this.qProduct.multiply((QuaternionReadOnly)this.expD2B2);
        this.qProduct.multiply((QuaternionReadOnly)this.expD3B3);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1Dot, (Tuple4DReadOnly)this.qProduct, (Vector4DBasics)this.qDot1);
        QuaternionTools.multiply((Tuple4DReadOnly)this.expD1B1_expD2B2, (Tuple4DReadOnly)this.d2B2Dot, (Vector4DBasics)this.qDot2);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qDot2, (Tuple4DReadOnly)this.expD3B3, (Vector4DBasics)this.qDot2);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qProduct, (Tuple4DReadOnly)this.d3B3Dot, (Vector4DBasics)this.qDot3);
        this.qProductDot.add((Tuple4DReadOnly)this.qDot1, (Tuple4DReadOnly)this.qDot2);
        this.qProductDot.add((Tuple4DReadOnly)this.qDot3);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1DDot, (Tuple4DReadOnly)this.qProduct, (Vector4DBasics)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1Dot, (Tuple4DReadOnly)this.qProductDot, (Vector4DBasics)this.qDDot1);
        this.qDDot1.add((Tuple4DReadOnly)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d2B2Dot, (Tuple4DReadOnly)this.d2B2Dot, (Vector4DBasics)this.qDDot2);
        this.qDDot2.add((Tuple4DReadOnly)this.d2B2DDot);
        QuaternionTools.multiply((Tuple4DReadOnly)this.expD1B1_expD2B2, (Tuple4DReadOnly)this.qDDot2, (Vector4DBasics)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qDDotTemp, (Tuple4DReadOnly)this.expD3B3, (Vector4DBasics)this.qDDotTemp);
        this.qDDot2.set(this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1Dot, (Tuple4DReadOnly)this.qDot2, (Vector4DBasics)this.qDDotTemp);
        this.qDDot2.add((Tuple4DReadOnly)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qDot2, (Tuple4DReadOnly)this.d3B3Dot, (Vector4DBasics)this.qDDotTemp);
        this.qDDot2.add((Tuple4DReadOnly)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qProduct, (Tuple4DReadOnly)this.d3B3DDot, (Vector4DBasics)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qProductDot, (Tuple4DReadOnly)this.d3B3Dot, (Vector4DBasics)this.qDDot3);
        this.qDDot3.add((Tuple4DReadOnly)this.qDDotTemp);
        this.qProductDDot.add((Tuple4DReadOnly)this.qDDot1, (Tuple4DReadOnly)this.qDDot2);
        this.qProductDDot.add((Tuple4DReadOnly)this.qDDot3);
        q.multiply((QuaternionReadOnly)q0, (QuaternionReadOnly)this.qProduct);
        QuaternionTools.multiply((Tuple4DReadOnly)q0, (Tuple4DReadOnly)this.qProductDot, (Vector4DBasics)this.qDot);
        QuaternionTools.multiply((Tuple4DReadOnly)q0, (Tuple4DReadOnly)this.qProductDDot, (Vector4DBasics)this.qDDot);
        if (this.convertAngularVelocity) {
            SimpleHermiteCurvedBasedOrientationTrajectoryCalculator.convertToAngularVelocity((QuaternionReadOnly)q, (Vector4DReadOnly)this.qDot, angularVelocity);
        }
        if (this.convertAngularAcceleration) {
            SimpleHermiteCurvedBasedOrientationTrajectoryCalculator.convertToAngularAcceleration((QuaternionReadOnly)q, (Vector4DReadOnly)this.qDot, (Vector4DReadOnly)this.qDDot, angularAcceleration);
        }
    }

    private void updateBezierCoefficients(double t) {
        double oneOverT = 1.0 / this.trajectoryTime;
        double tOverT = t * oneOverT;
        this.cumulativeBeziers[1] = 1.0 - this.cube(1.0 - tOverT);
        this.cumulativeBeziers[2] = 3.0 * this.square(tOverT) - 2.0 * this.cube(tOverT);
        this.cumulativeBeziers[3] = this.cube(tOverT);
        this.cumulativeBeziersDot[1] = 3.0 * oneOverT * this.square(1.0 - tOverT);
        this.cumulativeBeziersDot[2] = 6.0 * tOverT * oneOverT * (1.0 - tOverT);
        this.cumulativeBeziersDot[3] = 3.0 * this.square(tOverT) * oneOverT;
        this.cumulativeBeziersDDot[1] = -6.0 * this.square(oneOverT) * (1.0 - tOverT);
        this.cumulativeBeziersDDot[2] = 6.0 * this.square(oneOverT) * (1.0 - 2.0 * tOverT);
        this.cumulativeBeziersDDot[3] = 6.0 * t * this.cube(oneOverT);
    }

    private static void convertToAngularVelocity(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector3D angularVelocityToPack) {
        Vector4D tempConvertVector4D = new Vector4D();
        QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)qDot, (Tuple4DReadOnly)q, (Vector4DBasics)tempConvertVector4D);
        angularVelocityToPack.setX(tempConvertVector4D.getX());
        angularVelocityToPack.setY(tempConvertVector4D.getY());
        angularVelocityToPack.setZ(tempConvertVector4D.getZ());
        angularVelocityToPack.scale(2.0);
    }

    private static void convertToAngularAcceleration(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector4DReadOnly qDDot, Vector3D angularAccelerationToPack) {
        Vector4D tempConvertVector4D = new Vector4D();
        QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)qDDot, (Tuple4DReadOnly)q, (Vector4DBasics)tempConvertVector4D);
        angularAccelerationToPack.setX(tempConvertVector4D.getX());
        angularAccelerationToPack.setY(tempConvertVector4D.getY());
        angularAccelerationToPack.setZ(tempConvertVector4D.getZ());
        QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)qDot, (Tuple4DReadOnly)qDot, (Vector4DBasics)tempConvertVector4D);
        angularAccelerationToPack.addX(tempConvertVector4D.getX());
        angularAccelerationToPack.addY(tempConvertVector4D.getY());
        angularAccelerationToPack.addZ(tempConvertVector4D.getZ());
        angularAccelerationToPack.scale(2.0);
    }

    private double square(double value) {
        return value * value;
    }

    private double cube(double value) {
        return value * value * value;
    }

    private QuaternionReadOnly exp(double alpha, Vector3DReadOnly rotation) {
        Quaternion tempLogExpQuaternion = new Quaternion();
        Vector3D tempLogExpVector3D = new Vector3D();
        tempLogExpVector3D.setAndScale(alpha, (Tuple3DReadOnly)rotation);
        tempLogExpQuaternion.setRotationVector((Vector3DReadOnly)tempLogExpVector3D);
        return tempLogExpQuaternion;
    }

    private Vector3DReadOnly log(QuaternionReadOnly q) {
        Vector3D tempLogExpVector3D = new Vector3D();
        q.getRotationVector((Vector3DBasics)tempLogExpVector3D);
        return tempLogExpVector3D;
    }

    public void getOrientation(QuaternionBasics angularOrientationToPack) {
        angularOrientationToPack.set((QuaternionReadOnly)this.currentOrientation);
    }

    public void getAngularVelocity(Vector3D angularVelocityToPack) {
        angularVelocityToPack.set((Tuple3DReadOnly)this.currentAngularVelocity);
    }

    public void getAngularAcceleration(Vector3D angularAccelerationToPack) {
        angularAccelerationToPack.set((Tuple3DReadOnly)this.currentAngularAcceleration);
    }
}

