/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.math.trajectories.FrameNDoFTrapezoidalVelocityTrajectory;
import us.ihmc.robotics.math.trajectories.NDoFTrapezoidalVelocityTrajectory;

public class FramePointTrapezoidalVelocityTrajectory
extends FrameNDoFTrapezoidalVelocityTrajectory {
    public FramePointTrapezoidalVelocityTrajectory(double t0, FramePoint3DReadOnly x0, FramePoint3DReadOnly xF, FrameVector3DReadOnly v0, FrameVector3DReadOnly vF, FrameVector3DReadOnly vMax, FrameVector3DReadOnly aMax, NDoFTrapezoidalVelocityTrajectory.AlphaToAlphaType alphaToAlphaType) {
        super(x0.getReferenceFrame(), t0, FramePointTrapezoidalVelocityTrajectory.toArray((FrameTuple3DReadOnly)x0), FramePointTrapezoidalVelocityTrajectory.toArray((FrameTuple3DReadOnly)xF), FramePointTrapezoidalVelocityTrajectory.toArray((FrameTuple3DReadOnly)v0), FramePointTrapezoidalVelocityTrajectory.toArray((FrameTuple3DReadOnly)vF), FramePointTrapezoidalVelocityTrajectory.toArray((FrameTuple3DReadOnly)vMax), FramePointTrapezoidalVelocityTrajectory.toArray((FrameTuple3DReadOnly)aMax), alphaToAlphaType);
        FramePointTrapezoidalVelocityTrajectory.doReferenceFrameChecks((ReferenceFrameHolder)x0, (ReferenceFrameHolder)xF, (ReferenceFrameHolder)v0, (ReferenceFrameHolder)vF, (ReferenceFrameHolder)vMax, (ReferenceFrameHolder)aMax);
    }

    private static double[] toArray(FrameTuple3DReadOnly tuple) {
        return new double[]{tuple.getX(), tuple.getY(), tuple.getZ()};
    }

    public FramePoint3D getPosition(double t) {
        return new FramePoint3D(this.getReferenceFrame(), this.getPositionArray(t));
    }

    public FrameVector3D getVelocity(double t) {
        return new FrameVector3D(this.getReferenceFrame(), this.getVelocityArray(t));
    }

    public FrameVector3D getAcceleration(double t) {
        return new FrameVector3D(this.getReferenceFrame(), this.getAccelerationArray(t));
    }

    public FrameVector3D getMaximumVelocity() {
        return new FrameVector3D(this.getReferenceFrame(), this.getMaximumVelocityArray());
    }

    public FrameVector3D getMaximumAcceleration() {
        return new FrameVector3D(this.getReferenceFrame(), this.getMaximumAccelerationArray());
    }

    public FramePoint3D getInitialPosition() {
        return new FramePoint3D(this.getReferenceFrame(), this.getX0Array());
    }

    public FrameVector3D getInitialVelocity() {
        return new FrameVector3D(this.getReferenceFrame(), this.getV0Array());
    }
}

