/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.math.trajectories.BlendedPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.BlendedPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoGraphicTrajectory3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BlendedPositionTrajectoryGeneratorVisualizer {
    private final YoGraphicTrajectory3D trajectoryViz;

    public BlendedPositionTrajectoryGeneratorVisualizer(String namePrefix, BlendedPoseTrajectoryGenerator trajectory, DoubleProvider swingDuration, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this(namePrefix, trajectory.getPositionTrajectoryGenerator(), swingDuration, registry, graphicsListRegistry);
    }

    public BlendedPositionTrajectoryGeneratorVisualizer(String namePrefix, BlendedPositionTrajectoryGenerator trajectory, DoubleProvider swingDuration, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.trajectoryViz = new YoGraphicTrajectory3D(namePrefix + "BlendedTrajectory", null, trajectory, swingDuration, 0.01, 25, 8, registry);
        graphicsListRegistry.registerYoGraphic(namePrefix + "Trajectory", (YoGraphic)this.trajectoryViz);
        this.trajectoryViz.setColorType(YoGraphicTrajectory3D.TrajectoryColorType.ACCELERATION_BASED);
    }

    public void visualize() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.showGraphic();
        this.trajectoryViz.update();
    }

    public void showVisualization() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.showGraphic();
    }

    public void hideVisualization() {
        if (this.trajectoryViz == null) {
            return;
        }
        this.trajectoryViz.hideGraphic();
    }
}

