/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.math.trajectories.HermiteCurveBasedOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFrameOrientationTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BlendedOrientationTrajectoryGenerator
implements FixedFrameOrientationTrajectoryGenerator {
    private final FixedFrameOrientationTrajectoryGenerator trajectory;
    private final HermiteCurveBasedOrientationTrajectoryGenerator initialConstraintTrajectory;
    private final HermiteCurveBasedOrientationTrajectoryGenerator finalConstraintTrajectory;
    private final ReferenceFrame trajectoryFrame;
    private final YoDouble initialBlendStartTime;
    private final YoDouble initialBlendEndTime;
    private final YoDouble finalBlendStartTime;
    private final YoDouble finalBlendEndTime;
    private final Quaternion initialConstraintOrientationError = new Quaternion();
    private final Vector3D initialConstraintAngularVelocityError = new Vector3D();
    private final Quaternion finalConstraintOrientationError = new Quaternion();
    private final Vector3D finalConstraintAngularVelocityError = new Vector3D();
    private final FrameQuaternion initialConstraintOrientationOffset = new FrameQuaternion();
    private final FrameVector3D initialConstraintAngularVelocityOffset = new FrameVector3D();
    private final FrameVector3D initialConstraintAngularAccelerationOffset = new FrameVector3D();
    private final FrameQuaternion finalConstraintOrientationOffset = new FrameQuaternion();
    private final FrameVector3D finalConstraintAngularVelocityOffset = new FrameVector3D();
    private final FrameVector3D finalConstraintAngularAccelerationOffset = new FrameVector3D();
    private final DMatrixRMaj rotationMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj rotationMatrixDerivative = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj relativeConstraintAngularVelocityOffset = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj relativeConstraintAngularVelocityOffsetSkewSymmetricMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj constraintAngularAccelerationOffsetDueToVelocity = new DMatrixRMaj(3, 1);
    private final FrameQuaternion orientation = new FrameQuaternion();
    private final FrameVector3D angularVelocity = new FrameVector3D();
    private final FrameVector3D angularAcceleration = new FrameVector3D();
    private final FrameQuaternion tempOrientation = new FrameQuaternion();
    private final FrameVector3D tempAngularVelocity = new FrameVector3D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();

    public BlendedOrientationTrajectoryGenerator(String prefix, FixedFrameOrientationTrajectoryGenerator trajectory, ReferenceFrame trajectoryFrame, YoRegistry parentRegistry) {
        this.trajectory = trajectory;
        this.trajectoryFrame = trajectoryFrame;
        this.initialConstraintTrajectory = new HermiteCurveBasedOrientationTrajectoryGenerator(prefix + "InitialConstraintTrajectory", trajectoryFrame, parentRegistry);
        this.finalConstraintTrajectory = new HermiteCurveBasedOrientationTrajectoryGenerator(prefix + "FinalConstraintTrajectory", trajectoryFrame, parentRegistry);
        this.initialBlendStartTime = new YoDouble(prefix + "InitialBlendStartTime", parentRegistry);
        this.initialBlendEndTime = new YoDouble(prefix + "InitialBlendEndTime", parentRegistry);
        this.finalBlendStartTime = new YoDouble(prefix + "FinalBlendStartTime", parentRegistry);
        this.finalBlendEndTime = new YoDouble(prefix + "FinalBlendEndTime", parentRegistry);
        this.initialConstraintOrientationOffset.changeFrame(trajectoryFrame);
        this.initialConstraintAngularVelocityOffset.changeFrame(trajectoryFrame);
        this.initialConstraintAngularAccelerationOffset.changeFrame(trajectoryFrame);
        this.finalConstraintOrientationOffset.changeFrame(trajectoryFrame);
        this.finalConstraintAngularVelocityOffset.changeFrame(trajectoryFrame);
        this.finalConstraintAngularAccelerationOffset.changeFrame(trajectoryFrame);
        this.orientation.changeFrame(trajectoryFrame);
        this.angularVelocity.changeFrame(trajectoryFrame);
        this.angularAcceleration.changeFrame(trajectoryFrame);
        this.tempOrientation.changeFrame(trajectoryFrame);
        this.tempAngularVelocity.changeFrame(trajectoryFrame);
        this.clear();
    }

    public void clear() {
        this.clearInitialConstraint();
        this.clearFinalConstraint();
    }

    public void clearInitialConstraint() {
        this.initialConstraintOrientationError.setToZero();
        this.initialConstraintAngularVelocityError.setToZero();
        this.tempOrientation.set((QuaternionReadOnly)this.initialConstraintOrientationError);
        this.tempAngularVelocity.set((Tuple3DReadOnly)this.initialConstraintAngularVelocityError);
        this.initialConstraintTrajectory.setTrajectoryTime(0.0);
        this.initialConstraintTrajectory.setInitialConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.initialConstraintTrajectory.setFinalConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.initialConstraintTrajectory.initialize();
    }

    public void clearFinalConstraint() {
        this.finalConstraintOrientationError.setToZero();
        this.finalConstraintAngularVelocityError.setToZero();
        this.tempOrientation.set((QuaternionReadOnly)this.finalConstraintOrientationError);
        this.tempAngularVelocity.set((Tuple3DReadOnly)this.finalConstraintAngularVelocityError);
        this.finalConstraintTrajectory.setTrajectoryTime(0.0);
        this.finalConstraintTrajectory.setInitialConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.finalConstraintTrajectory.setFinalConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.finalConstraintTrajectory.initialize();
    }

    public void blendInitialConstraint(FrameQuaternionReadOnly initialPose, double initialTime, double blendDuration) {
        this.clearInitialConstraint();
        this.computeInitialConstraintError(initialPose, initialTime);
        this.computeInitialConstraintTrajectory(initialTime, blendDuration);
    }

    public void blendInitialConstraint(FrameQuaternionReadOnly initialPose, FrameVector3DReadOnly initialAngularVelocity, double initialTime, double blendDuration) {
        this.clearInitialConstraint();
        this.computeInitialConstraintError(initialPose, initialAngularVelocity, initialTime);
        this.computeInitialConstraintTrajectory(initialTime, blendDuration);
    }

    public void blendFinalConstraint(FrameQuaternionReadOnly finalOrientation, double finalTime, double blendDuration) {
        this.clearFinalConstraint();
        this.computeFinalConstraintError(finalOrientation, finalTime);
        this.computeFinalConstraintTrajectory(finalTime, blendDuration);
    }

    public void blendFinalConstraint(FrameQuaternionReadOnly finalOrientation, FrameVector3DReadOnly finalAngularVelocity, double finalTime, double blendDuration) {
        this.clearFinalConstraint();
        this.computeFinalConstraintError(finalOrientation, finalAngularVelocity, finalTime);
        this.computeFinalConstraintTrajectory(finalTime, blendDuration);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.trajectoryFrame;
    }

    public FrameQuaternionReadOnly getOrientation() {
        return this.orientation;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.angularVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.angularAcceleration;
    }

    @Override
    public void initialize() {
        this.trajectory.initialize();
    }

    @Override
    public void compute(double time) {
        this.trajectory.compute(time);
        this.orientation.setIncludingFrame(this.trajectory.getOrientation());
        this.angularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAngularVelocity());
        this.angularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAngularAcceleration());
        this.orientation.changeFrame(this.trajectoryFrame);
        this.angularVelocity.changeFrame(this.trajectoryFrame);
        this.angularAcceleration.changeFrame(this.trajectoryFrame);
        this.tempTransform.getRotation().set((Orientation3DReadOnly)this.orientation);
        this.tempTransform.getRotation().get((DMatrix)this.rotationMatrix);
        MatrixTools.vectorToSkewSymmetricMatrix((DMatrix1Row)this.relativeConstraintAngularVelocityOffsetSkewSymmetricMatrix, (Tuple3DReadOnly)this.angularVelocity);
        CommonOps_DDRM.mult((DMatrix1Row)this.relativeConstraintAngularVelocityOffsetSkewSymmetricMatrix, (DMatrix1Row)this.rotationMatrix, (DMatrix1Row)this.rotationMatrixDerivative);
        this.computeInitialConstraintOffset(time, this.rotationMatrix, this.rotationMatrixDerivative);
        this.orientation.multiply((FrameQuaternionReadOnly)this.initialConstraintOrientationOffset);
        this.angularVelocity.add((FrameTuple3DReadOnly)this.initialConstraintAngularVelocityOffset);
        this.angularAcceleration.add((FrameTuple3DReadOnly)this.initialConstraintAngularAccelerationOffset);
        this.computeFinalConstraintOffset(time, this.rotationMatrix, this.rotationMatrixDerivative);
        this.orientation.multiply((FrameQuaternionReadOnly)this.finalConstraintOrientationOffset);
        this.angularVelocity.add((FrameTuple3DReadOnly)this.finalConstraintAngularVelocityOffset);
        this.angularAcceleration.add((FrameTuple3DReadOnly)this.finalConstraintAngularAccelerationOffset);
    }

    @Override
    public boolean isDone() {
        return this.trajectory.isDone();
    }

    private void computeInitialConstraintError(FrameQuaternionReadOnly initialOrientation, double initialTime) {
        this.trajectory.compute(initialTime);
        this.trajectoryFrame.checkReferenceFrameMatch(initialOrientation.getReferenceFrame());
        this.tempOrientation.setIncludingFrame(this.trajectory.getOrientation());
        this.tempOrientation.changeFrame(this.trajectoryFrame);
        this.initialConstraintOrientationError.difference((QuaternionReadOnly)this.tempOrientation, (QuaternionReadOnly)initialOrientation);
    }

    private void computeInitialConstraintError(FrameQuaternionReadOnly initialOrientation, FrameVector3DReadOnly initialAngularVelocity, double initialTime) {
        this.computeInitialConstraintError(initialOrientation, initialTime);
        this.trajectoryFrame.checkReferenceFrameMatch(initialAngularVelocity.getReferenceFrame());
        this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAngularVelocity());
        this.tempAngularVelocity.changeFrame(this.trajectoryFrame);
        this.initialConstraintAngularVelocityError.set((Tuple3DReadOnly)initialAngularVelocity);
        this.initialConstraintAngularVelocityError.sub((Tuple3DReadOnly)this.tempAngularVelocity);
    }

    private void computeFinalConstraintError(FrameQuaternionReadOnly finalOrientation, double finalTime) {
        this.trajectory.compute(finalTime);
        this.trajectoryFrame.checkReferenceFrameMatch(finalOrientation.getReferenceFrame());
        this.tempOrientation.setIncludingFrame(this.trajectory.getOrientation());
        this.tempOrientation.changeFrame(this.trajectoryFrame);
        this.finalConstraintOrientationError.difference((QuaternionReadOnly)this.tempOrientation, (QuaternionReadOnly)finalOrientation);
    }

    private void computeFinalConstraintError(FrameQuaternionReadOnly finalOrientation, FrameVector3DReadOnly finalAngularVelocity, double finalTime) {
        this.computeFinalConstraintError(finalOrientation, finalTime);
        this.trajectoryFrame.checkReferenceFrameMatch(finalAngularVelocity.getReferenceFrame());
        this.tempAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAngularVelocity());
        this.tempAngularVelocity.changeFrame(this.trajectoryFrame);
        this.finalConstraintAngularVelocityError.set((Tuple3DReadOnly)finalAngularVelocity);
        this.finalConstraintAngularVelocityError.sub((Tuple3DReadOnly)this.tempAngularVelocity);
    }

    private void computeInitialConstraintTrajectory(double initialTime, double blendDuration) {
        this.initialBlendStartTime.set(initialTime);
        this.initialBlendEndTime.set(initialTime + blendDuration);
        this.initialConstraintTrajectory.setTrajectoryTime(blendDuration);
        this.trajectory.compute(initialTime);
        this.tempOrientation.setIncludingFrame(this.trajectory.getOrientation());
        this.tempTransform.getRotation().set((Orientation3DReadOnly)this.tempOrientation);
        this.tempOrientation.set((QuaternionReadOnly)this.initialConstraintOrientationError);
        this.tempAngularVelocity.set((Tuple3DReadOnly)this.initialConstraintAngularVelocityError);
        this.tempTransform.inverseTransform((Vector3DBasics)this.tempAngularVelocity);
        this.initialConstraintTrajectory.setInitialConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.tempOrientation.setToZero();
        this.tempAngularVelocity.setToZero();
        this.initialConstraintTrajectory.setFinalConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.initialConstraintTrajectory.initialize();
    }

    private void computeFinalConstraintTrajectory(double finalTime, double blendDuration) {
        this.finalBlendStartTime.set(finalTime - blendDuration);
        this.finalBlendEndTime.set(finalTime);
        this.finalConstraintTrajectory.setTrajectoryTime(blendDuration);
        this.trajectory.compute(finalTime);
        this.tempOrientation.setIncludingFrame(this.trajectory.getOrientation());
        this.tempTransform.getRotation().set((Orientation3DReadOnly)this.tempOrientation);
        this.tempOrientation.set((QuaternionReadOnly)this.finalConstraintOrientationError);
        this.tempAngularVelocity.set((Tuple3DReadOnly)this.finalConstraintAngularVelocityError);
        this.tempTransform.inverseTransform((Vector3DBasics)this.tempAngularVelocity);
        this.finalConstraintTrajectory.setFinalConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.tempOrientation.setToZero();
        this.tempAngularVelocity.setToZero();
        this.finalConstraintTrajectory.setInitialConditions((FrameQuaternionReadOnly)this.tempOrientation, (FrameVector3DReadOnly)this.tempAngularVelocity);
        this.finalConstraintTrajectory.initialize();
    }

    private void computeInitialConstraintOffset(double time, DMatrixRMaj rotationMatrix, DMatrixRMaj rotationMatrixDerivative) {
        double startTime = this.initialBlendStartTime.getDoubleValue();
        this.initialConstraintTrajectory.compute(time - startTime);
        this.initialConstraintOrientationOffset.setIncludingFrame(this.initialConstraintTrajectory.getOrientation());
        this.initialConstraintAngularVelocityOffset.setIncludingFrame((FrameTuple3DReadOnly)this.initialConstraintTrajectory.getAngularVelocity());
        this.initialConstraintAngularAccelerationOffset.setIncludingFrame((FrameTuple3DReadOnly)this.initialConstraintTrajectory.getAngularAcceleration());
        this.tempTransform.getRotation().set((DMatrix)rotationMatrix);
        this.tempTransform.getTranslation().set(0.0, 0.0, 0.0);
        this.initialConstraintOrientationOffset.changeFrame(this.trajectoryFrame);
        this.initialConstraintAngularVelocityOffset.changeFrame(this.trajectoryFrame);
        this.initialConstraintAngularVelocityOffset.get((DMatrix)this.relativeConstraintAngularVelocityOffset);
        this.initialConstraintAngularVelocityOffset.applyTransform((Transform)this.tempTransform);
        CommonOps_DDRM.mult((DMatrix1Row)rotationMatrixDerivative, (DMatrix1Row)this.relativeConstraintAngularVelocityOffset, (DMatrix1Row)this.constraintAngularAccelerationOffsetDueToVelocity);
        this.initialConstraintAngularAccelerationOffset.changeFrame(this.trajectoryFrame);
        this.initialConstraintAngularAccelerationOffset.applyTransform((Transform)this.tempTransform);
        this.initialConstraintAngularAccelerationOffset.addX(this.constraintAngularAccelerationOffsetDueToVelocity.get(0, 0));
        this.initialConstraintAngularAccelerationOffset.addY(this.constraintAngularAccelerationOffsetDueToVelocity.get(1, 0));
        this.initialConstraintAngularAccelerationOffset.addZ(this.constraintAngularAccelerationOffsetDueToVelocity.get(2, 0));
    }

    private void computeFinalConstraintOffset(double time, DMatrixRMaj rotationMatrix, DMatrixRMaj rotationMatrixDerivative) {
        double startTime = this.finalBlendStartTime.getDoubleValue();
        this.finalConstraintTrajectory.compute(time - startTime);
        this.finalConstraintOrientationOffset.setIncludingFrame(this.finalConstraintTrajectory.getOrientation());
        this.finalConstraintAngularVelocityOffset.setIncludingFrame((FrameTuple3DReadOnly)this.finalConstraintTrajectory.getAngularVelocity());
        this.finalConstraintAngularAccelerationOffset.setIncludingFrame((FrameTuple3DReadOnly)this.finalConstraintTrajectory.getAngularAcceleration());
        this.tempTransform.getRotation().set((DMatrix)rotationMatrix);
        this.tempTransform.getTranslation().set(0.0, 0.0, 0.0);
        this.finalConstraintOrientationOffset.changeFrame(this.trajectoryFrame);
        this.finalConstraintAngularVelocityOffset.changeFrame(this.trajectoryFrame);
        this.finalConstraintAngularVelocityOffset.get((DMatrix)this.relativeConstraintAngularVelocityOffset);
        this.finalConstraintAngularVelocityOffset.applyTransform((Transform)this.tempTransform);
        CommonOps_DDRM.mult((DMatrix1Row)rotationMatrixDerivative, (DMatrix1Row)this.relativeConstraintAngularVelocityOffset, (DMatrix1Row)this.constraintAngularAccelerationOffsetDueToVelocity);
        this.finalConstraintAngularAccelerationOffset.changeFrame(this.trajectoryFrame);
        this.finalConstraintAngularAccelerationOffset.applyTransform((Transform)this.tempTransform);
        this.finalConstraintAngularAccelerationOffset.addX(this.constraintAngularAccelerationOffsetDueToVelocity.get(0, 0));
        this.finalConstraintAngularAccelerationOffset.addY(this.constraintAngularAccelerationOffsetDueToVelocity.get(1, 0));
        this.finalConstraintAngularAccelerationOffset.addZ(this.constraintAngularAccelerationOffsetDueToVelocity.get(2, 0));
    }

    public HermiteCurveBasedOrientationTrajectoryGenerator getInitialConstraintTrajectory() {
        return this.initialConstraintTrajectory;
    }
}

