/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.interpolators;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.robotics.math.QuaternionCalculus;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public class OrientationInterpolationCalculator {
    private final Quaternion startRotationQuaternion = new Quaternion();
    private final Quaternion endRotationQuaternion = new Quaternion();
    private final Quaternion relativeRotationQuaternion = new Quaternion();
    private final Vector3D angularVelocity = new Vector3D();
    private final QuaternionCalculus quaternionCalculus = new QuaternionCalculus();

    public void computeAngularVelocity(FrameVector3DBasics angularVelocityToPack, FrameQuaternionBasics startOrientation, FrameQuaternionBasics endOrientation, double alphaDot) {
        startOrientation.checkReferenceFrameMatch((ReferenceFrameHolder)endOrientation);
        ReferenceFrame frame = startOrientation.getReferenceFrame();
        this.startRotationQuaternion.set((QuaternionReadOnly)startOrientation);
        this.endRotationQuaternion.set((QuaternionReadOnly)endOrientation);
        this.computeAngularVelocity(this.angularVelocity, this.startRotationQuaternion, this.endRotationQuaternion, alphaDot);
        angularVelocityToPack.setIncludingFrame(frame, (Tuple3DReadOnly)this.angularVelocity);
    }

    public void computeAngularVelocity(YoFrameVector3D angularVelocityToPack, YoFrameQuaternion startOrientation, YoFrameQuaternion endOrientation, double alphaDot) {
        angularVelocityToPack.checkReferenceFrameMatch((ReferenceFrameHolder)startOrientation);
        startOrientation.checkReferenceFrameMatch((ReferenceFrameHolder)endOrientation);
        this.startRotationQuaternion.set((QuaternionReadOnly)startOrientation);
        this.endRotationQuaternion.set((QuaternionReadOnly)endOrientation);
        this.computeAngularVelocity(this.angularVelocity, this.startRotationQuaternion, this.endRotationQuaternion, alphaDot);
        angularVelocityToPack.set((Tuple3DReadOnly)this.angularVelocity);
    }

    public void computeAngularAcceleration(FrameVector3DBasics angularAccelerationToPack, FrameQuaternionBasics startOrientation, FrameQuaternionBasics endOrientation, double alphaDoubleDot) {
        this.computeAngularVelocity(angularAccelerationToPack, startOrientation, endOrientation, alphaDoubleDot);
    }

    public void computeAngularAcceleration(YoFrameVector3D angularAccelerationToPack, YoFrameQuaternion startOrientation, YoFrameQuaternion endOrientation, double alphaDoubleDot) {
        this.computeAngularVelocity(angularAccelerationToPack, startOrientation, endOrientation, alphaDoubleDot);
    }

    private void computeAngularVelocity(Vector3D angularVelocityToPack, Quaternion startRotationQuaternion, Quaternion endRotationQuaternion, double alphaDot) {
        if (startRotationQuaternion.dot((Tuple4DReadOnly)endRotationQuaternion) < 0.0) {
            endRotationQuaternion.negate();
        }
        this.relativeRotationQuaternion.set(startRotationQuaternion);
        this.relativeRotationQuaternion.conjugate();
        this.relativeRotationQuaternion.multiply((QuaternionReadOnly)endRotationQuaternion);
        this.quaternionCalculus.log((QuaternionReadOnly)this.relativeRotationQuaternion, (Vector3DBasics)angularVelocityToPack);
        angularVelocityToPack.scale(alphaDot);
        endRotationQuaternion.transform((Tuple3DBasics)angularVelocityToPack);
    }
}

