/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import java.util.Random;
import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoRandomPulseGenerator {
    private YoRegistry registry;
    private YoDouble time;
    private final YoDouble percentChancePerSecond;
    private final YoDouble amplitudeMax;
    private final YoDouble amplitudeUsed;
    private final YoDouble durationMax;
    private final YoDouble durationUsed;
    private final YoDouble timeStartPulse;
    private final YoDouble timeLastRolledTheDie;
    private final YoBoolean pulseStarted;
    private final YoDouble value;
    private final YoDouble randomNumber;
    private final Random random = new Random();

    public YoRandomPulseGenerator(String name, YoRegistry parentRegistry) {
        this(name, null, parentRegistry);
    }

    public YoRandomPulseGenerator(String name, YoDouble time, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(name + "YoPulseGen");
        this.percentChancePerSecond = new YoDouble(name + "PercentChancePerSecond", this.registry);
        this.amplitudeMax = new YoDouble(name + "AmplitudeMax", this.registry);
        this.amplitudeUsed = new YoDouble(name + "AmplitudeUsed", this.registry);
        this.durationMax = new YoDouble(name + "DurationMax", this.registry);
        this.durationUsed = new YoDouble(name + "DurationUsed", this.registry);
        this.timeStartPulse = new YoDouble(name + "TimeStartPulse", this.registry);
        this.timeLastRolledTheDie = new YoDouble(name + "TimeLastRolledTheDie", this.registry);
        this.pulseStarted = new YoBoolean(name + "PulseStarted", this.registry);
        this.value = new YoDouble(name + "Value", this.registry);
        this.randomNumber = new YoDouble(name + "RandomNumber", this.registry);
        this.time = time;
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public void setPercentChancePerSecond(double percentChancePerSecond) {
        this.percentChancePerSecond.set(percentChancePerSecond);
    }

    public void setAmplitudeMax(double amplitudeMax) {
        this.amplitudeMax.set(amplitudeMax);
    }

    public void setDuration(double durationMax) {
        this.durationMax.set(durationMax);
    }

    public double getValue() {
        if (this.time == null) {
            throw new RuntimeException("YoRandomPulseGenerator wasn't created with a time YoVariable. Need to create with a time variable or call getValue(double time) instead");
        }
        return this.getValue(this.time.getDoubleValue());
    }

    public double getValue(double time) {
        if (this.pulseStarted.getBooleanValue()) {
            double percentIntoPulse = this.durationUsed.getDoubleValue() > 0.0 ? (time - this.timeStartPulse.getDoubleValue()) / this.durationUsed.getDoubleValue() : 1.0;
            percentIntoPulse = MathTools.clamp((double)percentIntoPulse, (double)0.0, (double)1.0);
            double temp = (Math.sin(Math.PI * 2 * (percentIntoPulse - 0.25)) + 1.0) / 2.0;
            this.value.set(this.amplitudeUsed.getDoubleValue() * temp);
            if (percentIntoPulse >= 1.0) {
                this.pulseStarted.set(false);
            }
        } else {
            double period = time - this.timeLastRolledTheDie.getDoubleValue();
            if (period >= 1.0) {
                double randomNumber = this.random.nextDouble();
                this.timeLastRolledTheDie.set(time);
                this.randomNumber.set(randomNumber);
                if (randomNumber <= this.percentChancePerSecond.getDoubleValue()) {
                    this.pulseStarted.set(true);
                    this.timeStartPulse.set(time);
                    double alpha = 0.3;
                    this.amplitudeUsed.set(this.amplitudeMax.getDoubleValue() * (alpha + (1.0 - alpha) * this.random.nextDouble()));
                    alpha = 0.1;
                    this.durationUsed.set(this.durationMax.getDoubleValue() * (alpha + (1.0 - alpha) * this.random.nextDouble()));
                    this.timeLastRolledTheDie.set(time - 1.0);
                }
            }
            this.value.set(0.0);
        }
        return this.value.getDoubleValue();
    }
}

