/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.math.YoSignalDerivative;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorMode;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoFunctionGenerator {
    private static final double TWO_PI = Math.PI * 2;
    private final double MIN_EXPONENTIAL_SWEEP_TIME = 1.0;
    private final double MIN_LINEAR_SWEEP_TIME = 0.001;
    private YoRegistry registry;
    private final Random random = new Random(1776L);
    private final YoDouble value;
    private final YoDouble offset;
    private final YoDouble amplitude;
    private final YoDouble frequency;
    private final YoDouble phase;
    private final YoDouble resetTime;
    private final YoDouble pauseTime;
    private final YoDouble chirpRate;
    private final YoDouble chirpFrequency;
    private final YoDouble chirpFrequencyMax;
    private final YoDouble valueDot;
    private final FilteredVelocityYoVariable valueDotFromFilter;
    private final YoDouble timeModeChanged;
    private final YoDouble timeInCurrentMode;
    private final YoDouble kRateForExponentialChirp;
    private final YoBoolean chirpUpAndDown;
    private final YoBoolean stopAfterResetTime;
    private final YoEnum<YoFunctionGeneratorMode> mode;
    private final YoEnum<YoFunctionGeneratorMode> modePrevious;
    private final YoVariable[] createdVariables;
    private final YoSignalDerivative signalDerivative;
    private final DoubleProvider time;
    private double sweepFrequencyLowHz = 0.001;
    private double previousResetTime;
    private double previousChirpFrequency;
    private boolean previousChirpUpAndDown;
    private boolean smoothParameters = false;
    private boolean modeChanged;
    private final AlphaFilteredYoVariable offsetFiltered;
    private final AlphaFilteredYoVariable amplitudeFiltered;
    private final YoDouble frequencyFiltered;
    private final YoDouble phaseFiltered;
    private final YoDouble alphaFilter;

    public YoFunctionGenerator(String name, YoRegistry registry) {
        this(name, null, registry, false, -1.0);
    }

    public YoFunctionGenerator(String name, YoRegistry registry, boolean smoothParameters) {
        this(name, null, registry, smoothParameters, -1.0);
    }

    public YoFunctionGenerator(String name, DoubleProvider time, YoRegistry parentRegistry) {
        this(name, time, parentRegistry, false, -1.0);
    }

    public YoFunctionGenerator(String name, DoubleProvider time, YoRegistry parentRegistry, boolean smoothParameters, double dT) {
        this.smoothParameters = smoothParameters;
        this.registry = new YoRegistry(name + "YoFunGen");
        this.time = time;
        this.value = new YoDouble(name + "Value", this.registry);
        this.valueDot = new YoDouble(name + "ValueDot", this.registry);
        this.valueDotFromFilter = dT != -1.0 ? new FilteredVelocityYoVariable(name + "ValueDotFromFilter", "", 0.0, this.value, dT, this.registry) : null;
        this.offset = new YoDouble(name + "Offset", this.registry);
        this.amplitude = new YoDouble(name + "Amp", this.registry);
        this.frequency = new YoDouble(name + "Freq", this.registry);
        this.phase = new YoDouble(name + "Phase", this.registry);
        this.alphaFilter = new YoDouble(name + "SmoothingAlphaFilter", this.registry);
        if (!smoothParameters) {
            this.alphaFilter.set(0.0);
        } else {
            this.alphaFilter.set(0.999);
        }
        this.offsetFiltered = new AlphaFilteredYoVariable("offsetFiltered", this.registry, (DoubleProvider)this.alphaFilter, this.offset);
        this.amplitudeFiltered = new AlphaFilteredYoVariable("amplitudeFiltered", this.registry, (DoubleProvider)this.alphaFilter, this.amplitude);
        this.frequencyFiltered = new YoDouble("frequencyFiltered", this.registry);
        this.phaseFiltered = new YoDouble("phaseFiltered", this.registry);
        this.pauseTime = new YoDouble(name + "PauseTime", this.registry);
        this.resetTime = new YoDouble(name + "ResetTime", this.registry);
        this.chirpRate = new YoDouble(name + "ChirpRate", this.registry);
        this.chirpUpAndDown = new YoBoolean(name + "ChirpUpAndDown", this.registry);
        this.stopAfterResetTime = new YoBoolean(name + "StopAfterResetTime", this.registry);
        this.stopAfterResetTime.set(false);
        this.chirpFrequency = new YoDouble(name + "ChirpFrequency", this.registry);
        this.chirpFrequencyMax = new YoDouble(name + "ChirpFrequencyMax", this.registry);
        this.timeModeChanged = new YoDouble(name + "TimeModeChanged", this.registry);
        this.timeInCurrentMode = new YoDouble(name + "TimeInCurrentMode", this.registry);
        this.kRateForExponentialChirp = new YoDouble(name + "KRateForExponentialChirp", this.registry);
        this.mode = new YoEnum(name + "Mode", this.registry, YoFunctionGeneratorMode.class);
        this.modePrevious = new YoEnum(name + "ModePrevious", this.registry, YoFunctionGeneratorMode.class);
        this.mode.set((Enum)YoFunctionGeneratorMode.OFF);
        this.modePrevious.set(this.mode.getEnumValue());
        this.resetTime.set(10.0);
        this.frequency.set(1.0);
        this.chirpRate.set(1.0);
        this.chirpFrequencyMax.set(1.0);
        this.createdVariables = new YoVariable[]{this.value, this.offset, this.amplitude, this.frequency, this.phase, this.resetTime, this.chirpRate, this.mode};
        this.signalDerivative = new YoSignalDerivative(name, this.registry);
        this.signalDerivative.setDifferentiationMode(YoSignalDerivative.DifferentiationMode.USING_DT);
        this.signalDerivative.resetToZero();
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public String[] getCreatedVariableNames() {
        String[] ret = new String[this.createdVariables.length];
        for (int i = 0; i < this.createdVariables.length; ++i) {
            ret[i] = this.createdVariables[i].getName();
        }
        return ret;
    }

    public void setOffset(double offset) {
        this.offset.set(offset);
    }

    public void setOffsetFiltered(double offset) {
        this.offsetFiltered.reset();
        this.offsetFiltered.set(offset);
        this.offset.set(offset);
    }

    public double getOffset() {
        return this.offset.getDoubleValue();
    }

    public void setAmplitude(double amplitude) {
        this.amplitude.set(amplitude);
    }

    public double getAmplitude() {
        return this.amplitude.getDoubleValue();
    }

    public void setFrequencyWithContinuousOutput(double frequency) {
        this.setPhase(this.getPhase() + Math.PI * 2 * (this.getFrequency() - frequency) * this.timeInCurrentMode.getDoubleValue());
        this.setFrequency(frequency);
    }

    public void setFrequency(double frequency) {
        this.frequency.set(frequency);
    }

    public double getFrequency() {
        return this.frequency.getDoubleValue();
    }

    public double getFrequencyFiltered() {
        return this.frequencyFiltered.getDoubleValue();
    }

    public void setChirpFrequencyMaxHz(double frequencyHz) {
        this.chirpFrequencyMax.set(frequencyHz);
    }

    public double getChirpFrequencyMax() {
        return this.chirpFrequencyMax.getDoubleValue();
    }

    public double getChirpFrequency() {
        return this.chirpFrequency.getDoubleValue();
    }

    public void setPhase(double phase) {
        this.phase.set(phase);
    }

    public double getPhase() {
        return this.phase.getDoubleValue();
    }

    public void setMode(YoFunctionGeneratorMode mode) {
        this.mode.set((Enum)mode);
    }

    public YoFunctionGeneratorMode getMode() {
        return (YoFunctionGeneratorMode)this.mode.getEnumValue();
    }

    public void setResetTime(double resetTime) {
        this.resetTime.set(resetTime);
    }

    public double getResetTime() {
        return this.resetTime.getDoubleValue();
    }

    public void setPauseTime(double pauseTime) {
        this.pauseTime.set(pauseTime);
    }

    public double getPauseTime() {
        return this.pauseTime.getDoubleValue();
    }

    public void setChirpRate(double frequencyRate) {
        this.chirpRate.set(frequencyRate);
    }

    public double getChirpRate() {
        return this.chirpRate.getDoubleValue();
    }

    public double getKRateForExponentialChirp() {
        return this.kRateForExponentialChirp.getDoubleValue();
    }

    public void setChirpUpAndDown(boolean value) {
        this.chirpUpAndDown.set(value);
    }

    public double getValue() {
        if (this.time == null) {
            throw new RuntimeException("Function Generator wasn't created with a time YoVariable. Need to create with a time variable or call getValue(double time) instead");
        }
        return this.getValue(this.time.getValue());
    }

    public double getValueDot() {
        return this.valueDot.getDoubleValue();
    }

    public boolean getStopAfterResetTime() {
        return this.stopAfterResetTime.getBooleanValue();
    }

    public void setStopAfterResetTime(boolean stopAfterResetTime) {
        this.stopAfterResetTime.set(stopAfterResetTime);
    }

    public void resetTimeModeChanged() {
        this.timeModeChanged.set(0.0);
    }

    public double getValue(double time) {
        this.updateFilteredValues();
        if (((YoFunctionGeneratorMode)this.mode.getEnumValue()).equals(this.modePrevious.getEnumValue())) {
            this.modeChanged = false;
        } else {
            this.performModeChangeAction(time);
        }
        this.timeInCurrentMode.set(time - this.timeModeChanged.getDoubleValue());
        double effectiveResetTime = this.resetTime.getDoubleValue();
        if (this.chirpUpAndDown.getBooleanValue() && (((YoFunctionGeneratorMode)this.mode.getEnumValue()).equals((Object)YoFunctionGeneratorMode.CHIRP_EXPONENTIAL) || ((YoFunctionGeneratorMode)this.mode.getEnumValue()).equals((Object)YoFunctionGeneratorMode.CHIRP_LINEAR))) {
            effectiveResetTime *= 2.0;
        }
        effectiveResetTime += this.pauseTime.getDoubleValue();
        if (this.timeInCurrentMode.getDoubleValue() > effectiveResetTime && this.stopAfterResetTime.getBooleanValue()) {
            this.mode.set((Enum)YoFunctionGeneratorMode.OFF);
        }
        switch ((YoFunctionGeneratorMode)this.mode.getEnumValue()) {
            case OFF: {
                this.value.set(this.offsetFiltered.getDoubleValue());
                break;
            }
            case SINE: {
                this.value.set(this.offsetFiltered.getDoubleValue() + this.amplitudeFiltered.getDoubleValue() * Math.sin(Math.PI * 2 * this.frequencyFiltered.getDoubleValue() * this.timeInCurrentMode.getDoubleValue() + this.phaseFiltered.getDoubleValue()));
                this.valueDot.set(this.amplitudeFiltered.getDoubleValue() * Math.PI * 2.0 * this.frequencyFiltered.getDoubleValue() * Math.cos(Math.PI * 2 * this.frequencyFiltered.getDoubleValue() * this.timeInCurrentMode.getDoubleValue() + this.phaseFiltered.getDoubleValue()));
                if (this.valueDotFromFilter == null) break;
                this.valueDotFromFilter.update();
                break;
            }
            case CHIRP_LINEAR: {
                this.verifyChirpParametersAreInRange();
                if (this.previousResetTime != this.resetTime.getDoubleValue()) {
                    this.performModeChangeAction(time);
                }
                if (this.previousChirpFrequency != this.chirpFrequencyMax.getDoubleValue()) {
                    this.performModeChangeAction(time);
                }
                if (this.previousChirpUpAndDown != this.chirpUpAndDown.getBooleanValue()) {
                    this.performModeChangeAction(time);
                }
                if (this.modeChanged) {
                    this.previousResetTime = this.resetTime.getDoubleValue();
                    this.previousChirpFrequency = this.chirpFrequencyMax.getDoubleValue();
                    this.previousChirpUpAndDown = this.chirpUpAndDown.getBooleanValue();
                    this.chirpRate.set(this.chirpFrequencyMax.getDoubleValue() / this.resetTime.getDoubleValue());
                }
                if (this.resetTime.getDoubleValue() < 0.001) {
                    this.resetTime.set(0.001);
                }
                double chirpTime = this.chirpUpAndDown.getBooleanValue() ? this.timeInCurrentMode.getDoubleValue() % (this.pauseTime.getDoubleValue() + 2.0 * this.resetTime.getDoubleValue()) : this.timeInCurrentMode.getDoubleValue() % (this.pauseTime.getDoubleValue() + this.resetTime.getDoubleValue());
                double phaseForWayDown = 0.0;
                if (chirpTime < this.pauseTime.getDoubleValue()) {
                    this.chirpFrequency.set(0.0);
                    chirpTime = 0.0;
                } else {
                    chirpTime -= this.pauseTime.getDoubleValue();
                    if (this.chirpUpAndDown.getBooleanValue() && chirpTime > this.resetTime.getDoubleValue()) {
                        chirpTime = 2.0 * this.resetTime.getDoubleValue() - chirpTime;
                        phaseForWayDown = Math.PI;
                    }
                    this.chirpFrequency.set(this.chirpRate.getDoubleValue() * chirpTime);
                }
                this.value.set(this.offsetFiltered.getDoubleValue() + this.amplitudeFiltered.getDoubleValue() * Math.sin(Math.PI * this.chirpFrequency.getDoubleValue() * chirpTime + phaseForWayDown));
                this.valueDot.set(this.amplitudeFiltered.getDoubleValue() * Math.PI * 2.0 * chirpTime * this.chirpRate.getDoubleValue() * Math.cos(Math.PI * this.chirpFrequency.getDoubleValue() * chirpTime));
                if (this.valueDotFromFilter == null) break;
                this.valueDotFromFilter.update();
                break;
            }
            case CHIRP_EXPONENTIAL: {
                double effectiveFrequency;
                double chirpTime;
                this.verifyChirpParametersAreInRange();
                if (this.previousResetTime != this.resetTime.getDoubleValue()) {
                    this.performModeChangeAction(time);
                }
                if (this.previousChirpFrequency != this.chirpFrequencyMax.getDoubleValue()) {
                    this.performModeChangeAction(time);
                }
                if (this.previousChirpUpAndDown != this.chirpUpAndDown.getBooleanValue()) {
                    this.performModeChangeAction(time);
                }
                if (this.modeChanged) {
                    this.kRateForExponentialChirp.set(YoFunctionGenerator.getkRate(this.sweepFrequencyLowHz, this.chirpFrequencyMax.getDoubleValue(), this.resetTime.getDoubleValue()));
                    this.previousResetTime = this.resetTime.getDoubleValue();
                    this.previousChirpFrequency = this.chirpFrequencyMax.getDoubleValue();
                    this.previousChirpUpAndDown = this.chirpUpAndDown.getBooleanValue();
                }
                if (this.resetTime.getDoubleValue() < 1.0) {
                    this.resetTime.set(1.0);
                }
                if ((chirpTime = this.chirpUpAndDown.getBooleanValue() ? this.timeInCurrentMode.getDoubleValue() % (this.pauseTime.getDoubleValue() + 2.0 * this.resetTime.getDoubleValue()) : this.timeInCurrentMode.getDoubleValue() % (this.pauseTime.getDoubleValue() + this.resetTime.getDoubleValue())) < this.pauseTime.getDoubleValue()) {
                    effectiveFrequency = 0.0;
                } else {
                    chirpTime -= this.pauseTime.getDoubleValue();
                    if (this.chirpUpAndDown.getBooleanValue() && chirpTime > this.resetTime.getDoubleValue()) {
                        chirpTime = 2.0 * this.resetTime.getDoubleValue() - chirpTime;
                    }
                    if ((effectiveFrequency = chirpTime == 0.0 ? 0.0 : this.sweepFrequencyLowHz * (Math.pow(this.kRateForExponentialChirp.getDoubleValue(), chirpTime) - 1.0) / (Math.log(this.kRateForExponentialChirp.getDoubleValue()) * chirpTime)) > this.chirpFrequencyMax.getDoubleValue()) {
                        effectiveFrequency = 0.0;
                    }
                }
                this.value.set(this.offsetFiltered.getDoubleValue() + this.amplitudeFiltered.getDoubleValue() * Math.sin(Math.PI * 2 * effectiveFrequency * chirpTime));
                double velocity = this.signalDerivative.getDerivative(this.value.getDoubleValue(), this.timeInCurrentMode.getDoubleValue());
                if (velocity > Double.MAX_VALUE || velocity < -1.7976931348623157E308) {
                    velocity = 0.0;
                }
                this.valueDot.set(velocity);
                break;
            }
            case SQUARE: {
                double square;
                if (this.timeInCurrentMode.getDoubleValue() < this.pauseTime.getDoubleValue()) {
                    square = 0.0;
                } else {
                    double timeAfterPause = this.timeInCurrentMode.getDoubleValue() - this.pauseTime.getDoubleValue();
                    square = Math.sin(Math.PI * 2 * this.frequencyFiltered.getDoubleValue() * timeAfterPause + this.phaseFiltered.getDoubleValue());
                    square = square > 0.0 ? 1.0 : -1.0;
                }
                this.value.set(this.offsetFiltered.getDoubleValue() + this.amplitudeFiltered.getDoubleValue() * square);
                break;
            }
            case SAWTOOTH: {
                double angle = (Math.PI * 2 * this.frequencyFiltered.getDoubleValue() * this.timeInCurrentMode.getDoubleValue() + this.phaseFiltered.getDoubleValue()) % (Math.PI * 2);
                if (angle < 0.0) {
                    angle += Math.PI * 2;
                }
                double percentUp = angle / (Math.PI * 2);
                double sawtoothValue = EuclidCoreTools.interpolate((double)(-this.amplitudeFiltered.getValue()), (double)this.amplitudeFiltered.getValue(), (double)percentUp);
                this.value.set(this.offsetFiltered.getDoubleValue() + sawtoothValue);
                break;
            }
            case TRIANGLE: {
                double p = 1.0 / (2.0 * this.frequencyFiltered.getDoubleValue());
                this.value.set(2.0 * this.amplitudeFiltered.getDoubleValue() / p * (p - Math.abs(this.timeInCurrentMode.getDoubleValue() % (2.0 * p) - p)) - this.amplitudeFiltered.getDoubleValue() + this.offsetFiltered.getDoubleValue());
                this.valueDot.set(-1.0 * Math.signum(this.timeInCurrentMode.getDoubleValue() % (2.0 * p) - p) * Math.abs(2.0 * this.amplitudeFiltered.getDoubleValue() / (1.0 / this.frequencyFiltered.getDoubleValue() / 2.0)));
                this.signalDerivative.getDerivative(this.value.getDoubleValue(), this.timeInCurrentMode.getDoubleValue());
                break;
            }
            case WHITE_NOISE: {
                double randomDouble = 2.0 * this.random.nextDouble() - 1.0;
                this.value.set(this.offsetFiltered.getDoubleValue() + this.amplitudeFiltered.getDoubleValue() * randomDouble);
                break;
            }
            case DC: {
                this.value.set(this.offsetFiltered.getDoubleValue() + this.amplitudeFiltered.getDoubleValue());
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't get here!");
            }
        }
        this.modePrevious.set(this.mode.getEnumValue());
        return this.value.getDoubleValue();
    }

    private void verifyChirpParametersAreInRange() {
        if (this.chirpFrequencyMax.getDoubleValue() <= this.sweepFrequencyLowHz) {
            this.chirpFrequencyMax.set(2.0 * this.sweepFrequencyLowHz + 1.0);
        }
        if (this.resetTime.getDoubleValue() <= 0.01) {
            this.resetTime.set(0.01);
        }
    }

    private void updateFilteredValues() {
        this.offsetFiltered.update();
        this.amplitudeFiltered.update();
        if (!this.smoothParameters) {
            this.frequencyFiltered.set(this.frequency.getDoubleValue());
            this.phaseFiltered.set(this.phase.getDoubleValue());
        } else if (Math.abs(Math.sin(Math.PI * 2 * this.frequencyFiltered.getDoubleValue() * this.timeInCurrentMode.getDoubleValue() + this.phaseFiltered.getDoubleValue())) < 0.01) {
            this.frequencyFiltered.set(this.frequency.getDoubleValue());
            this.phaseFiltered.set(this.phase.getDoubleValue());
        }
    }

    private void performModeChangeAction(double time) {
        this.modeChanged = true;
        this.timeModeChanged.set(time);
        this.timeInCurrentMode.set(time - this.timeModeChanged.getDoubleValue());
        this.signalDerivative.initialize(YoSignalDerivative.DifferentiationMode.USING_DT, this.value.getDoubleValue(), this.timeInCurrentMode.getDoubleValue(), this.valueDot.getDoubleValue());
    }

    private static double getkRate(double sweepFreqLow, double sweepFreqHigh, double sweepTime) {
        boolean DEBUG = false;
        if (sweepFreqHigh <= sweepFreqLow) {
            System.err.println("sweepFreqHigh must be greater than sweepFreqLow. Setting sweepFreqHigh to 2*sweepFreqLow + 1.0");
            sweepFreqHigh = 2.0 * sweepFreqLow + 1.0;
        }
        if (sweepTime <= 0.0) {
            System.err.println("sweep time must be greater than 0.0. Using 1.0");
            sweepTime = 1.0;
        }
        double lowerBound = 1.0E-4;
        double upperBound = 1.0E12;
        boolean keepTrying = true;
        int numberOfIterations = 0;
        while (keepTrying) {
            double midpoint = (upperBound + lowerBound) / 2.0;
            double midPointValue = YoFunctionGenerator.computeExpressionForChirpRate(sweepFreqLow, sweepFreqHigh, sweepTime, midpoint);
            if (DEBUG) {
                double lowPointValue = YoFunctionGenerator.computeExpressionForChirpRate(sweepFreqLow, sweepFreqHigh, sweepTime, lowerBound);
                double upperPointValue = YoFunctionGenerator.computeExpressionForChirpRate(sweepFreqLow, sweepFreqHigh, sweepTime, upperBound);
                System.out.println("");
                System.out.println(numberOfIterations + ", " + lowPointValue + ", " + midPointValue + ", " + upperPointValue);
                System.out.println(numberOfIterations + ", " + lowerBound + ", " + midpoint + ", " + upperBound);
            }
            if (midPointValue < 0.0) {
                lowerBound = midpoint;
            } else if (midPointValue > 0.0) {
                upperBound = midpoint;
            } else {
                keepTrying = false;
                upperBound = midpoint;
            }
            if (++numberOfIterations <= 100) continue;
            keepTrying = false;
        }
        return upperBound;
    }

    private static double computeExpressionForChirpRate(double sweepFreqLow, double sweepFreqHigh, double sweepTime, double kRate) {
        return sweepFreqLow * (Math.pow(kRate, sweepTime) - 1.0) / (sweepFreqHigh * Math.log(kRate) * sweepTime) - 1.0;
    }

    public static void generateTestData(YoFunctionGenerator yoFunctionGenerator) {
        System.out.println("starting generateTestData()");
        yoFunctionGenerator.setMode(YoFunctionGeneratorMode.CHIRP_EXPONENTIAL);
        double sweepFreqHigh = 50.0;
        double sweepTime = 20.0;
        yoFunctionGenerator.setChirpFrequencyMaxHz(sweepFreqHigh);
        yoFunctionGenerator.setResetTime(sweepTime);
        yoFunctionGenerator.setAmplitude(1.0);
        double deltaTime = 0.01;
        ArrayList<Double> timeArray = new ArrayList<Double>();
        ArrayList<Double> valueArray = new ArrayList<Double>();
        for (double time = 0.0; time < 1.03 * sweepTime; time += deltaTime) {
            timeArray.add(time);
            valueArray.add(yoFunctionGenerator.getValue(time));
        }
        for (int i = 0; i < timeArray.size(); ++i) {
            System.out.println(timeArray.get(i) + ", " + valueArray.get(i));
        }
        System.out.println("KRateForExponentialChirp=" + yoFunctionGenerator.getKRateForExponentialChirp());
    }

    public void setAlphaForSmoothing(double alpha) {
        this.alphaFilter.set(alpha);
    }

    public void resetSmoothing() {
        this.offsetFiltered.reset();
        this.amplitudeFiltered.reset();
        this.frequencyFiltered.set(this.frequency.getValue());
        this.phaseFiltered.set(this.phase.getValue());
    }

    public static void main(String[] args) {
        YoFunctionGenerator yoFunctionGenerator = new YoFunctionGenerator("test", null);
        YoFunctionGenerator.generateTestData(yoFunctionGenerator);
    }
}

