/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.frames;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoMatrix {
    private final int maxNumberOfRows;
    private final int maxNumberOfColumns;
    private final YoInteger numberOfRows;
    private final YoInteger numberOfColumns;
    private final YoDouble[][] variables;

    public YoMatrix(String name, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        this.maxNumberOfRows = maxNumberOfRows;
        this.maxNumberOfColumns = maxNumberOfColumns;
        this.numberOfRows = new YoInteger(name + "NumRows", registry);
        this.numberOfColumns = new YoInteger(name + "NumCols", registry);
        this.numberOfRows.set(maxNumberOfRows);
        this.numberOfColumns.set(maxNumberOfColumns);
        this.variables = new YoDouble[maxNumberOfRows][maxNumberOfColumns];
        for (int row = 0; row < maxNumberOfRows; ++row) {
            for (int column = 0; column < maxNumberOfColumns; ++column) {
                this.variables[row][column] = new YoDouble(name + "_" + row + "_" + column, registry);
            }
        }
    }

    public void set(DMatrixRMaj matrix) {
        int numRows = matrix.getNumRows();
        int numCols = matrix.getNumCols();
        if ((numRows > this.maxNumberOfRows || numCols > this.maxNumberOfColumns) && numRows > 0 && numCols > 0) {
            throw new RuntimeException("Not enough rows or columns. matrix to set is " + matrix.getNumRows() + " by " + matrix.getNumCols());
        }
        this.numberOfRows.set(numRows);
        this.numberOfColumns.set(numCols);
        for (int row = 0; row < this.maxNumberOfRows; ++row) {
            for (int column = 0; column < this.maxNumberOfColumns; ++column) {
                if (row < numRows && column < numCols) {
                    this.variables[row][column].set(matrix.get(row, column));
                    continue;
                }
                this.variables[row][column].set(Double.NaN);
            }
        }
    }

    public void getAndReshape(DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(this.getNumberOfRows(), this.getNumberOfColumns());
        this.get(matrixToPack);
    }

    public void get(DMatrixRMaj matrixToPack) {
        int numRows = matrixToPack.getNumRows();
        int numCols = matrixToPack.getNumCols();
        if ((numRows > this.maxNumberOfRows || numCols > this.maxNumberOfColumns) && numRows > 0 && numCols > 0) {
            throw new RuntimeException("Not enough rows or columns. matrixToPack is " + matrixToPack.getNumRows() + " by " + matrixToPack.getNumCols());
        }
        if (numRows != this.numberOfRows.getIntegerValue() || numCols != this.numberOfColumns.getIntegerValue()) {
            throw new RuntimeException("Numer of rows and columns must be the same. Call getAndReshape() if you want to reshape the matrixToPack");
        }
        for (int row = 0; row < numRows; ++row) {
            for (int column = 0; column < numCols; ++column) {
                matrixToPack.set(row, column, this.variables[row][column].getDoubleValue());
            }
        }
    }

    public int getNumberOfRows() {
        return this.numberOfRows.getIntegerValue();
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns.getIntegerValue();
    }

    public void setToZero(int numberOfRows, int numberOfColumns) {
        if ((numberOfRows > this.maxNumberOfRows || numberOfColumns > this.maxNumberOfColumns) && numberOfRows > 0 && numberOfColumns > 0) {
            throw new RuntimeException("Not enough rows or columns: " + numberOfRows + " by " + numberOfColumns);
        }
        this.numberOfRows.set(numberOfRows);
        this.numberOfColumns.set(numberOfColumns);
        for (int row = 0; row < this.maxNumberOfRows; ++row) {
            for (int column = 0; column < this.maxNumberOfColumns; ++column) {
                if (row < numberOfRows && column < numberOfColumns) {
                    this.variables[row][column].set(0.0);
                    continue;
                }
                this.variables[row][column].set(Double.NaN);
            }
        }
    }

    public void setToNaN(int numberOfRows, int numberOfColumns) {
        if ((numberOfRows > this.maxNumberOfRows || numberOfColumns > this.maxNumberOfColumns) && numberOfRows > 0 && numberOfColumns > 0) {
            throw new RuntimeException("Not enough rows or columns: " + numberOfRows + " by " + numberOfColumns);
        }
        this.numberOfRows.set(numberOfRows);
        this.numberOfColumns.set(numberOfColumns);
        for (int row = 0; row < this.maxNumberOfRows; ++row) {
            for (int column = 0; column < this.maxNumberOfColumns; ++column) {
                this.variables[row][column].set(Double.NaN);
            }
        }
    }
}

