/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.ArrayList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class TwoVariableTransitionFilter
extends YoDouble {
    private final YoDouble transitionStartTime;
    private final YoDouble time;
    private double lengthOfTransitionTime = 0.0;

    public TwoVariableTransitionFilter(String name, YoRegistry registry, YoDouble time) {
        super(name, registry);
        this.transitionStartTime = new YoDouble("transStartTime_" + name, registry);
        this.time = time;
    }

    public void update(double initialVariableValue, double finalVariableValue) {
        double finalValueScale;
        double initialValueScale;
        if (this.lengthOfTransitionTime > 0.0) {
            double timeSinceLastStartTransition = this.time.getDoubleValue() - this.transitionStartTime.getDoubleValue();
            if (timeSinceLastStartTransition < 0.0) {
                initialValueScale = 1.0;
                finalValueScale = 0.0;
            } else if (timeSinceLastStartTransition < this.lengthOfTransitionTime) {
                initialValueScale = 0.5 * (1.0 + Math.cos(timeSinceLastStartTransition * Math.PI / this.lengthOfTransitionTime));
                finalValueScale = 1.0 - initialValueScale;
            } else {
                initialValueScale = 0.0;
                finalValueScale = 1.0;
            }
        } else {
            initialValueScale = 0.0;
            finalValueScale = 1.0;
        }
        this.set(initialValueScale * initialVariableValue + finalValueScale * finalVariableValue);
    }

    public void startTransition(double lengthOfTransitionTime) {
        this.transitionStartTime.set(this.time.getDoubleValue());
        this.lengthOfTransitionTime = lengthOfTransitionTime;
    }

    public static void main(String[] args) {
        YoRegistry reg = new YoRegistry("main");
        YoDouble time = new YoDouble("time", "", null);
        TwoVariableTransitionFilter testVariable = new TwoVariableTransitionFilter("testVariable", reg, time);
        double deltaT = 0.05;
        double endT = 4.0;
        int numberOfPoints = (int)(endT / deltaT);
        double[][] initialData = new double[2][numberOfPoints];
        double[][] finalData = new double[2][numberOfPoints];
        double[][] filteredData = new double[2][numberOfPoints];
        boolean setStart = false;
        double initialValue = 0.0;
        double finalValue = 1.0;
        double t = 0.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            if (t > 0.7 && !setStart) {
                testVariable.startTransition(2.5);
                setStart = true;
            }
            initialValue = Math.sin(t * 2.0 * Math.PI / 0.7);
            finalValue = 3.0 * Math.sin(t * 2.0 * Math.PI / 0.5);
            testVariable.update(initialValue, finalValue);
            initialData[0][i] = t;
            initialData[1][i] = initialValue;
            finalData[0][i] = t;
            finalData[1][i] = finalValue;
            filteredData[0][i] = t;
            filteredData[1][i] = testVariable.getDoubleValue();
            time.set(t += deltaT);
        }
        ArrayList<double[][]> listOfCurves = new ArrayList<double[][]>();
        listOfCurves.add(initialData);
        listOfCurves.add(finalData);
        listOfCurves.add(filteredData);
    }
}

