/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.robotics.math.filters.SecondOrderFilterType;
import us.ihmc.robotics.math.filters.SecondOrderFilteredYoVariableParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SecondOrderFilteredYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private final double dt;
    private final SecondOrderFilteredYoVariableParameters parameters;
    protected final YoBoolean hasBeenCalled;
    private final YoDouble inputVariable;
    private final YoDouble[] input;
    private final YoDouble[] output;
    private final double[] a;
    private final double[] b;

    public SecondOrderFilteredYoVariable(String name, YoRegistry registry, double dt, double naturalFrequencyInHz, double dampingRatio, SecondOrderFilterType filterType) {
        this(name, registry, dt, new SecondOrderFilteredYoVariableParameters(name, registry, naturalFrequencyInHz, dampingRatio, filterType), null);
    }

    public SecondOrderFilteredYoVariable(String name, YoRegistry registry, double dt, SecondOrderFilteredYoVariableParameters parameters) {
        this(name, registry, dt, parameters, null);
    }

    public SecondOrderFilteredYoVariable(String name, YoRegistry registry, double dt, double naturalFrequencyInHz, double dampingRatio, SecondOrderFilterType filterType, YoDouble inputVariable) {
        this(name, registry, dt, new SecondOrderFilteredYoVariableParameters(name, registry, naturalFrequencyInHz, dampingRatio, filterType), inputVariable);
    }

    public SecondOrderFilteredYoVariable(String name, YoRegistry registry, double dt, SecondOrderFilteredYoVariableParameters parameters, YoDouble inputVariable) {
        super(name, registry);
        this.dt = dt;
        this.parameters = parameters;
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.inputVariable = inputVariable;
        this.input = new YoDouble[3];
        this.output = new YoDouble[3];
        this.a = new double[3];
        this.b = new double[3];
        for (int i = 0; i < 3; ++i) {
            this.input[i] = new YoDouble(name + "input" + i, registry);
            this.output[i] = new YoDouble(name + "output" + i, registry);
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
        this.computeCoefficients();
    }

    @Override
    public void update() {
        if (this.inputVariable == null) {
            throw new NullPointerException("SecondOrderFilteredYoVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.inputVariable.getDoubleValue());
    }

    public void update(double currentInputValue) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(currentInputValue);
            for (int i = 0; i < 3; ++i) {
                this.input[i].set(currentInputValue);
                this.output[i].set(currentInputValue);
            }
            return;
        }
        for (int i = 2; i > 0; --i) {
            this.input[i].set(this.input[i - 1].getDoubleValue());
            this.output[i].set(this.output[i - 1].getDoubleValue());
        }
        this.input[0].set(currentInputValue);
        double currentOutputValue = 0.0;
        currentOutputValue += this.b[2] * this.input[2].getDoubleValue();
        currentOutputValue += this.b[1] * this.input[1].getDoubleValue();
        currentOutputValue += this.b[0] * this.input[0].getDoubleValue();
        currentOutputValue -= this.a[2] * this.output[2].getDoubleValue();
        currentOutputValue -= this.a[1] * this.output[1].getDoubleValue();
        this.output[0].set(currentOutputValue /= this.a[0]);
        this.set(currentOutputValue);
    }

    public void setNaturalFrequencyInHz(double naturalFrequencyInHz) {
        this.parameters.getNaturalFrequencyInHz().set(Math.min(Math.max(naturalFrequencyInHz, 0.0), 1.0 / (2.0 * this.dt)));
        this.computeCoefficients();
    }

    public void setDampingRatio(double dampingRatio) {
        this.parameters.getDampingRatio().set(Math.max(dampingRatio, 0.0));
        this.computeCoefficients();
    }

    public boolean getHasBeenCalled() {
        return this.hasBeenCalled.getBooleanValue();
    }

    public void getFilterCoefficients(double[] b, double[] a) {
        int i;
        if (b.length < 3) {
            throw new RuntimeException("b must be of length 3 or greater");
        }
        if (a.length < 3) {
            throw new RuntimeException("a must be of length 3 or greater");
        }
        for (i = 0; i < 3; ++i) {
            b[i] = this.b[i];
        }
        for (i = 3; i < b.length; ++i) {
            b[i] = 0.0;
        }
        for (i = 0; i < 3; ++i) {
            a[i] = this.a[i];
        }
        for (i = 3; i < a.length; ++i) {
            a[i] = 0.0;
        }
    }

    private void computeCoefficients() {
        double omega = Math.PI * 2 * this.parameters.getNaturalFrequencyInHz().getDoubleValue();
        double xi = this.parameters.getDampingRatio().getDoubleValue();
        switch (this.parameters.getFilterType()) {
            case LOW_PASS: {
                this.b[0] = omega * omega;
                this.b[1] = 2.0 * omega * omega;
                this.b[2] = omega * omega;
                break;
            }
            case NOTCH: {
                this.b[0] = 4.0 / (this.dt * this.dt) + omega * omega;
                this.b[1] = 2.0 * omega * omega - 8.0 / (this.dt * this.dt);
                this.b[2] = 4.0 / (this.dt * this.dt) + omega * omega;
                break;
            }
            case HIGH_PASS: {
                this.b[0] = 4.0 / (this.dt * this.dt);
                this.b[1] = -8.0 / (this.dt * this.dt);
                this.b[2] = 4.0 / (this.dt * this.dt);
            }
        }
        this.a[0] = 4.0 / (this.dt * this.dt) + 4.0 / this.dt * xi * omega + omega * omega;
        this.a[1] = 2.0 * omega * omega - 8.0 / (this.dt * this.dt);
        this.a[2] = 4.0 / (this.dt * this.dt) - 4.0 / this.dt * xi * omega + omega * omega;
    }
}

