/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoVariable
extends YoDouble {
    private final DoubleProvider maxRateVariable;
    private final YoDouble position;
    private final YoBoolean limited;
    private final double dt;
    private final YoBoolean hasBeenCalled;

    public RateLimitedYoVariable(String name, YoRegistry registry, double maxRate, double dt) {
        super(name, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.limited = new YoBoolean(name + "Limited", registry);
        YoDouble maxRateVariable = new YoDouble(name + "MaxRate", registry);
        maxRateVariable.set(maxRate);
        this.maxRateVariable = maxRateVariable;
        this.position = null;
        this.dt = dt;
        this.reset();
    }

    public RateLimitedYoVariable(String name, YoRegistry registry, DoubleProvider maxRateVariable, double dt) {
        super(name, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.limited = new YoBoolean(name + "Limited", registry);
        this.maxRateVariable = maxRateVariable;
        this.position = null;
        this.dt = dt;
        this.reset();
    }

    public RateLimitedYoVariable(String name, YoRegistry registry, double maxRate, YoDouble positionVariable, double dt) {
        super(name, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.limited = new YoBoolean(name + "Limited", registry);
        this.position = positionVariable;
        YoDouble maxRateVariable = new YoDouble(name + "MaxRate", registry);
        maxRateVariable.set(maxRate);
        this.maxRateVariable = maxRateVariable;
        this.dt = dt;
        this.reset();
    }

    public RateLimitedYoVariable(String name, YoRegistry registry, DoubleProvider maxRateVariable, YoDouble positionVariable, double dt) {
        super(name, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.limited = new YoBoolean(name + "Limited", registry);
        this.position = positionVariable;
        this.maxRateVariable = maxRateVariable;
        this.dt = dt;
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(currentPosition);
        }
        if (this.maxRateVariable.getValue() < 0.0) {
            throw new RuntimeException("The maxRate parameter in the RateLimitedYoVariable cannot be negative.");
        }
        double difference = currentPosition - this.getDoubleValue();
        if (Math.abs(difference) > this.maxRateVariable.getValue() * this.dt) {
            difference = Math.signum(difference) * this.maxRateVariable.getValue() * this.dt;
            this.limited.set(true);
        } else {
            this.limited.set(false);
        }
        this.set(this.getDoubleValue() + difference);
    }
}

