/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.robotics.dataStructures.YoMutableFrameSpatialVector;
import us.ihmc.robotics.math.filters.RateLimitedYoMutableFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RateLimitedYoMutableSpatialVector
extends YoMutableFrameSpatialVector {
    private final RateLimitedYoMutableFrameVector3D rateLimitedAngularPart;
    private final RateLimitedYoMutableFrameVector3D rateLimitedLinearPart;

    public RateLimitedYoMutableSpatialVector(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maximumAngularRate, DoubleProvider maximumLinearRate, double dt, FrameVector3DReadOnly rawAngularPart, FrameVector3DReadOnly rawLinearPart) {
        super(new RateLimitedYoMutableFrameVector3D(namePrefix, nameSuffix, registry, maximumAngularRate, dt, (FrameTuple3DReadOnly)rawAngularPart), new RateLimitedYoMutableFrameVector3D(namePrefix, nameSuffix, registry, maximumLinearRate, dt, (FrameTuple3DReadOnly)rawLinearPart));
        this.rateLimitedAngularPart = (RateLimitedYoMutableFrameVector3D)this.getAngularPart();
        this.rateLimitedLinearPart = (RateLimitedYoMutableFrameVector3D)this.getLinearPart();
    }

    public RateLimitedYoMutableSpatialVector(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maximumAngularRate, DoubleProvider maximumLinearRate, double dt, YoFixedFrameSpatialVector rawSpatialVector) {
        super(new RateLimitedYoMutableFrameVector3D(namePrefix, nameSuffix, registry, maximumAngularRate, dt, (FrameTuple3DReadOnly)rawSpatialVector.getAngularPart()), new RateLimitedYoMutableFrameVector3D(namePrefix, nameSuffix, registry, maximumLinearRate, dt, (FrameTuple3DReadOnly)rawSpatialVector.getLinearPart()));
        this.rateLimitedAngularPart = (RateLimitedYoMutableFrameVector3D)this.getAngularPart();
        this.rateLimitedLinearPart = (RateLimitedYoMutableFrameVector3D)this.getLinearPart();
    }

    public RateLimitedYoMutableSpatialVector(RateLimitedYoMutableFrameVector3D yoAngularPart, RateLimitedYoMutableFrameVector3D yoLinearPart) {
        super(yoAngularPart, yoLinearPart);
        this.rateLimitedAngularPart = yoAngularPart;
        this.rateLimitedLinearPart = yoLinearPart;
    }

    public void reset() {
        this.rateLimitedAngularPart.reset();
        this.rateLimitedLinearPart.reset();
    }

    public void update() {
        this.rateLimitedAngularPart.update();
        this.rateLimitedLinearPart.update();
    }

    public void update(FrameVector3DReadOnly rawAngularPart, FrameVector3DReadOnly rawLinearPart) {
        this.rateLimitedAngularPart.update((FrameTuple3DReadOnly)rawAngularPart);
        this.rateLimitedLinearPart.update((FrameTuple3DReadOnly)rawLinearPart);
    }

    public void update(Vector3DReadOnly rawAngularPart, Vector3DReadOnly rawLinearPart) {
        this.rateLimitedAngularPart.update((Tuple3DReadOnly)rawAngularPart);
        this.rateLimitedLinearPart.update((Tuple3DReadOnly)rawLinearPart);
    }

    public void update(double rawAngularX, double rawAngularY, double rawAngularZ, double rawLinearX, double rawLinearY, double rawLinearZ) {
        this.rateLimitedAngularPart.update(rawAngularX, rawAngularY, rawAngularZ);
        this.rateLimitedLinearPart.update(rawLinearX, rawLinearY, rawLinearZ);
    }
}

