/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoFrameOrientation
extends YoFrameYawPitchRoll {
    private final DoubleProvider maxRateVariable;
    private final YoFrameYawPitchRoll rawOrientation;
    private final YoBoolean limited;
    private final YoBoolean hasBeenCalled;
    private final double dt;
    private final Quaternion quaternionUnfiltered = new Quaternion();
    private final Quaternion quaternionFiltered = new Quaternion();
    private final Quaternion difference = new Quaternion();
    private final Vector3D limitedRotationVector = new Vector3D();

    private static DoubleProvider createMaxRateYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxRate" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public RateLimitedYoFrameOrientation(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, YoFrameYawPitchRoll rawOrientation) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, rawOrientation, rawOrientation.getReferenceFrame());
    }

    public RateLimitedYoFrameOrientation(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, null, referenceFrame);
    }

    public RateLimitedYoFrameOrientation(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, YoFrameYawPitchRoll rawOrientation) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFrameOrientation.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, rawOrientation, rawOrientation.getReferenceFrame());
    }

    public RateLimitedYoFrameOrientation(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFrameOrientation.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, null, referenceFrame);
    }

    private RateLimitedYoFrameOrientation(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, YoFrameYawPitchRoll rawOrientation, ReferenceFrame referenceFrame) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.hasBeenCalled = new YoBoolean(namePrefix + "HasBeenCalled" + nameSuffix, registry);
        this.limited = new YoBoolean(namePrefix + "Limited" + nameSuffix, registry);
        if (maxRate == null) {
            maxRate = RateLimitedYoFrameOrientation.createMaxRateYoDouble(namePrefix, nameSuffix, Double.POSITIVE_INFINITY, registry);
        }
        this.maxRateVariable = maxRate;
        this.rawOrientation = rawOrientation;
        this.dt = dt;
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.rawOrientation == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.rawOrientation);
    }

    public void update(YoFrameYawPitchRoll yoFrameVectorUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)yoFrameVectorUnfiltered);
        this.update(yoFrameVectorUnfiltered.getYaw(), yoFrameVectorUnfiltered.getPitch(), yoFrameVectorUnfiltered.getRoll());
    }

    public void update(FrameQuaternion frameOrientationUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameOrientationUnfiltered);
        this.update((QuaternionReadOnly)frameOrientationUnfiltered);
    }

    public void update(double yawUnfiltered, double pitchUnfiltered, double rollUnfiltered) {
        this.quaternionUnfiltered.setYawPitchRoll(yawUnfiltered, pitchUnfiltered, rollUnfiltered);
        this.update((QuaternionReadOnly)this.quaternionUnfiltered);
    }

    public void update(QuaternionReadOnly quaternionUnfiltered) {
        if (!this.hasBeenCalled.getBooleanValue() || this.containsNaN()) {
            this.hasBeenCalled.set(true);
            this.limited.set(false);
            this.set((Orientation3DReadOnly)quaternionUnfiltered);
            return;
        }
        this.quaternionFiltered.set((Orientation3DReadOnly)this);
        if (this.quaternionFiltered.dot((Tuple4DReadOnly)quaternionUnfiltered) > 0.0) {
            this.difference.difference((QuaternionReadOnly)this.quaternionFiltered, quaternionUnfiltered);
        } else {
            this.difference.setAndNegate(quaternionUnfiltered);
            this.difference.preMultiplyConjugateOther((QuaternionReadOnly)this.quaternionFiltered);
        }
        this.difference.getRotationVector((Vector3DBasics)this.limitedRotationVector);
        boolean clipped = this.limitedRotationVector.clipToMaxLength(this.dt * this.maxRateVariable.getValue());
        this.limited.set(clipped);
        if (clipped) {
            this.difference.setRotationVector((Vector3DReadOnly)this.limitedRotationVector);
            this.quaternionFiltered.multiply((QuaternionReadOnly)this.difference);
            this.set((Orientation3DReadOnly)this.quaternionFiltered);
        } else {
            this.set((Orientation3DReadOnly)quaternionUnfiltered);
        }
    }
}

