/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FirstOrderFilteredYoVariable
extends YoDouble {
    private boolean hasBeenCalled = false;
    private double filterInputOld;
    private double filterUpdateTimeOld;
    private final YoDouble cutoffFrequency_Hz;
    private final YoDouble yoTime;
    private double dt;
    private FirstOrderFilterType highOrLowPass;

    public FirstOrderFilteredYoVariable(String name, String description, double cutoffFrequency_Hz, YoDouble yoTime, FirstOrderFilterType highOrLowPass, YoRegistry registry) {
        super(name, description, registry);
        String cutoffFrequencyName;
        switch (highOrLowPass) {
            case LOW_PASS: {
                cutoffFrequencyName = name + "_LowPassCutoff_Hz";
                break;
            }
            case HIGH_PASS: {
                cutoffFrequencyName = name + "_HighPassCutoff_Hz";
                break;
            }
            default: {
                throw new RuntimeException("Must Specify Filter Type as Low or High Pass.  Current Specification : " + (Object)((Object)highOrLowPass));
            }
        }
        this.cutoffFrequency_Hz = new YoDouble(cutoffFrequencyName, registry);
        this.cutoffFrequency_Hz.set(cutoffFrequency_Hz);
        this.yoTime = yoTime;
        this.highOrLowPass = highOrLowPass;
    }

    public FirstOrderFilteredYoVariable(String name, String description, double cutoffFrequency_Hz, double DT, FirstOrderFilterType highOrLowPass, YoRegistry registry) {
        this(name, description, cutoffFrequency_Hz, null, highOrLowPass, registry);
        this.dt = DT;
    }

    private double computeLowPassUpdate(double filterInput, double dt) {
        double alpha = this.computeAlpha(dt, this.cutoffFrequency_Hz.getDoubleValue());
        double ret = alpha * this.getDoubleValue() + (1.0 - alpha) * filterInput;
        return ret;
    }

    private double computeHighPassUpdate(double filterInput, double dt) {
        double alpha = this.computeAlpha(dt, this.cutoffFrequency_Hz.getDoubleValue());
        double ret = alpha * (this.getDoubleValue() + filterInput - this.filterInputOld);
        return ret;
    }

    private double computeAlpha(double dt, double cutoffFrequencyHz) {
        if (cutoffFrequencyHz <= 0.0) {
            throw new RuntimeException("Cutoff Frequency must be greater than zero.  Cutoff = " + cutoffFrequencyHz);
        }
        double cutoff_radPerSec = cutoffFrequencyHz * 2.0 * Math.PI;
        double RC = 1.0 / cutoff_radPerSec;
        double alpha = RC / (RC + dt);
        if (alpha <= 0.0 || alpha >= 1.0 && dt != 0.0) {
            throw new RuntimeException("Alpha value must be between 0 and 1.  Alpha = " + alpha);
        }
        return alpha;
    }

    public void reset() {
        this.hasBeenCalled = false;
    }

    public void setCutoffFrequencyHz(double cutoffHz) {
        this.cutoffFrequency_Hz.set(cutoffHz);
    }

    public void update(double filterInput) {
        if (!this.hasBeenCalled) {
            this.hasBeenCalled = true;
            this.filterInputOld = 0.0;
            this.filterUpdateTimeOld = 0.0;
            this.set(filterInput);
        } else {
            double filterOutput;
            if (this.yoTime != null) {
                double timeSinceLastUpdate = this.yoTime.getDoubleValue() - this.filterUpdateTimeOld;
                if (timeSinceLastUpdate > 0.0) {
                    this.dt = timeSinceLastUpdate;
                } else {
                    this.reset();
                }
            }
            switch (this.highOrLowPass) {
                case LOW_PASS: {
                    filterOutput = this.computeLowPassUpdate(filterInput, this.dt);
                    break;
                }
                case HIGH_PASS: {
                    filterOutput = this.computeHighPassUpdate(filterInput, this.dt);
                    break;
                }
                default: {
                    filterOutput = filterInput;
                }
            }
            this.set(filterOutput);
        }
        this.filterInputOld = filterInput;
        if (this.yoTime != null) {
            this.filterUpdateTimeOld = this.yoTime.getDoubleValue();
        }
    }

    public static enum FirstOrderFilterType {
        LOW_PASS,
        HIGH_PASS;

    }
}

