/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class FilteredVelocityYoFrameVector
extends YoFrameVector3D {
    private final double dt;
    private final DoubleProvider alphaProvider;
    private final YoBoolean hasBeenCalled;
    private final FrameTuple3DReadOnly currentPosition;
    private final YoFrameVector3D lastPosition;
    private final Vector3D currentRawDerivative = new Vector3D();

    @Deprecated
    public static FilteredVelocityYoFrameVector createFilteredVelocityYoFrameVector(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, FrameTuple3DReadOnly frameTuple3DToDifferentiate) {
        return new FilteredVelocityYoFrameVector(namePrefix, nameSuffix, alpha, dt, registry, frameTuple3DToDifferentiate);
    }

    @Deprecated
    public static FilteredVelocityYoFrameVector createFilteredVelocityYoFrameVector(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, ReferenceFrame referenceFrame) {
        return new FilteredVelocityYoFrameVector(namePrefix, nameSuffix, alpha, dt, registry, referenceFrame);
    }

    public FilteredVelocityYoFrameVector(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, FrameTuple3DReadOnly frameTuple3DToDifferentiate) {
        super(namePrefix, nameSuffix, frameTuple3DToDifferentiate.getReferenceFrame(), registry);
        this.alphaProvider = alpha;
        this.dt = dt;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
        this.currentPosition = frameTuple3DToDifferentiate;
        this.lastPosition = new YoFrameVector3D(namePrefix + "_lastPosition", nameSuffix, this.getReferenceFrame(), registry);
        this.reset();
    }

    public FilteredVelocityYoFrameVector(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, ReferenceFrame referenceFrame) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.alphaProvider = alpha;
        this.dt = dt;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
        this.currentPosition = null;
        this.lastPosition = new YoFrameVector3D(namePrefix + "_lastPosition", nameSuffix, this.getReferenceFrame(), registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.currentPosition == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(FrameTuple3DReadOnly)");
        }
        this.update(this.currentPosition);
    }

    public void update(FrameTuple3DReadOnly frameTuple) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameTuple);
        this.update((Tuple3DReadOnly)frameTuple);
    }

    public void update(Tuple3DReadOnly currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.lastPosition.set(currentPosition);
            this.setToZero();
        }
        this.currentRawDerivative.sub(currentPosition, (Tuple3DReadOnly)this.lastPosition);
        this.currentRawDerivative.scale(1.0 / this.dt);
        double alpha = this.alphaProvider.getValue();
        this.interpolate((Tuple3DReadOnly)this.currentRawDerivative, (FrameTuple3DReadOnly)this, alpha);
        this.lastPosition.set(currentPosition);
    }
}

