/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.math.TimestampedVelocityYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class FilteredDiscreteVelocityYoVariable2
extends YoDouble {
    private final double alpha;
    private final YoDouble time;
    private final YoDouble alphaVariable;
    private final YoDouble position;
    private final YoDouble lastPosChangeTimeInterval;
    private final YoEnum<Direction> lastPosChangeDirection;
    private final TimestampedVelocityYoVariable finiteDifferenceVelocity;
    private final YoDouble unfilteredVelocity;
    private final TimestampedVelocityYoVariable finiteDifferenceAccel;
    private boolean updateHasBeenCalled;
    private final YoDouble timeSinceLastPosChange;
    private final YoDouble lastPositionIncrement;
    private final YoDouble positionPredicted;
    private final YoDouble velocityIfEncoderTicksNow;
    private final YoDouble velocityIfEncoderTicksNowConstantAccel;
    private final YoBoolean useDecay;

    public FilteredDiscreteVelocityYoVariable2(String name, String description, double alpha, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.alpha = alpha;
        this.alphaVariable = null;
        this.position = null;
        this.time = time;
        this.lastPosChangeTimeInterval = new YoDouble(name + "_lastUpdateTimeInterval", registry);
        this.lastPosChangeDirection = new YoEnum(name + "_lastUpdateDirection", registry, Direction.class);
        this.finiteDifferenceVelocity = new TimestampedVelocityYoVariable(name + "_finiteDiff", "", this.position, time, registry, 1.0E-20);
        this.unfilteredVelocity = new YoDouble(name + "_unfiltered", registry);
        this.finiteDifferenceAccel = new TimestampedVelocityYoVariable(name + "_finiteDiffAccel", "", this.finiteDifferenceVelocity, time, registry, 1.0E-20);
        this.timeSinceLastPosChange = new YoDouble(name + "_timeSinceLastTick", registry);
        this.lastPositionIncrement = new YoDouble(name + "_lastPositionIncrement", registry);
        this.positionPredicted = new YoDouble(name + "_positionPredicted", registry);
        this.velocityIfEncoderTicksNow = new YoDouble(name + "_velocityIfEncoderTicksNow", registry);
        this.velocityIfEncoderTicksNowConstantAccel = new YoDouble(name + "_velocityIfEncoderTicksNowConstantAccel", registry);
        this.useDecay = new YoBoolean(name + "_useDecay", registry);
        this.reset();
    }

    public FilteredDiscreteVelocityYoVariable2(String name, String description, double alpha, YoDouble positionVariable, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.alpha = alpha;
        this.position = positionVariable;
        this.alphaVariable = null;
        this.time = time;
        this.lastPosChangeTimeInterval = new YoDouble(name + "_lastUpdateTimeInterval", registry);
        this.lastPosChangeDirection = new YoEnum(name + "_lastUpdateDirection", registry, Direction.class);
        this.finiteDifferenceVelocity = new TimestampedVelocityYoVariable(name + "_finiteDiff", "", this.position, time, registry, 1.0E-20);
        this.unfilteredVelocity = new YoDouble(name + "_unfiltered", registry);
        this.finiteDifferenceAccel = new TimestampedVelocityYoVariable(name + "_finiteDiffAccel", "", this.finiteDifferenceVelocity, time, registry, 1.0E-20);
        this.timeSinceLastPosChange = new YoDouble(name + "_timeSinceLastTick", registry);
        this.lastPositionIncrement = new YoDouble(name + "_lastPositionIncrement", registry);
        this.positionPredicted = new YoDouble(name + "_positionPredicted", registry);
        this.velocityIfEncoderTicksNow = new YoDouble(name + "_velocityIfEncoderTicksNow", registry);
        this.velocityIfEncoderTicksNowConstantAccel = new YoDouble(name + "_velocityIfEncoderTicksNowConstantAccel", registry);
        this.useDecay = new YoBoolean(name + "_useDecay", registry);
        this.reset();
    }

    public FilteredDiscreteVelocityYoVariable2(String name, String description, YoDouble alphaVariable, YoDouble positionVariable, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.position = positionVariable;
        this.alphaVariable = alphaVariable;
        this.alpha = 0.0;
        this.time = time;
        this.lastPosChangeTimeInterval = new YoDouble(name + "_lastUpdateTimeInterval", registry);
        this.lastPosChangeDirection = new YoEnum(name + "_lastUpdateDirection", registry, Direction.class);
        this.finiteDifferenceVelocity = new TimestampedVelocityYoVariable(name + "_finiteDiff", "", this.position, time, registry, 1.0E-20);
        this.unfilteredVelocity = new YoDouble(name + "_unfiltered", registry);
        this.finiteDifferenceAccel = new TimestampedVelocityYoVariable(name + "_finiteDiffAccel", "", this.unfilteredVelocity, time, registry, 1.0E-20);
        this.timeSinceLastPosChange = new YoDouble(name + "_timeSinceLastTick", registry);
        this.lastPositionIncrement = new YoDouble(name + "_lastPositionIncrement", registry);
        this.positionPredicted = new YoDouble(name + "_positionPredicted", registry);
        this.velocityIfEncoderTicksNow = new YoDouble(name + "_velocityIfEncoderTicksNow", registry);
        this.velocityIfEncoderTicksNowConstantAccel = new YoDouble(name + "_velocityIfEncoderTicksNowConstantAccel", registry);
        this.useDecay = new YoBoolean(name + "_useDecay", registry);
        this.reset();
    }

    public void reset() {
        this.updateHasBeenCalled = false;
        this.useDecay.set(true);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.updateHasBeenCalled) {
            this.updateHasBeenCalled = true;
            this.lastPosChangeDirection.set((Enum)Direction.NONE);
        }
        this.timeSinceLastPosChange.set(this.time.getDoubleValue() - this.finiteDifferenceVelocity.getPreviousTimestamp());
        double previousPositon = this.finiteDifferenceVelocity.getPreviousPosition();
        this.velocityIfEncoderTicksNow.set((this.positionPredicted.getDoubleValue() - previousPositon) / this.timeSinceLastPosChange.getDoubleValue());
        if (currentPosition != previousPositon) {
            this.finiteDifferenceVelocity.update();
            this.finiteDifferenceAccel.update();
            if (this.determineIfDirectionChanged(currentPosition)) {
                this.unfilteredVelocity.set(0.0);
                this.positionPredicted.set(currentPosition - this.lastPositionIncrement.getDoubleValue());
            } else {
                this.unfilteredVelocity.set(this.finiteDifferenceVelocity.getDoubleValue());
                this.positionPredicted.set(currentPosition + this.lastPositionIncrement.getDoubleValue());
            }
            this.lastPosChangeTimeInterval.set(this.timeSinceLastPosChange.getDoubleValue());
            this.lastPositionIncrement.set(currentPosition - previousPositon);
        } else {
            boolean velSlowedDownSincePosTakingTooLongToChange;
            this.velocityIfEncoderTicksNowConstantAccel.set(this.finiteDifferenceVelocity.getDoubleValue() + this.finiteDifferenceAccel.getDoubleValue() * this.timeSinceLastPosChange.getDoubleValue());
            boolean bl = velSlowedDownSincePosTakingTooLongToChange = this.timeSinceLastPosChange.getDoubleValue() > this.lastPosChangeTimeInterval.getDoubleValue();
            if (velSlowedDownSincePosTakingTooLongToChange && this.useDecay.getBooleanValue()) {
                this.unfilteredVelocity.set(this.velocityIfEncoderTicksNow.getDoubleValue());
            }
        }
        this.set(this.alphaFilter(this.velocityIfEncoderTicksNowConstantAccel.getDoubleValue()));
    }

    private double alphaFilter(double currentValue) {
        double previousFilteredValue = this.getDoubleValue();
        double a = this.alpha;
        if (this.alphaVariable != null) {
            a = this.alphaVariable.getDoubleValue();
        }
        double ret = a * previousFilteredValue + (1.0 - a) * currentValue;
        return ret;
    }

    private Direction computeDirectionOfMotion(double currentPosition) {
        Direction directionOfMotion = currentPosition > this.finiteDifferenceVelocity.getPreviousPosition() ? Direction.FORWARD : (currentPosition < this.finiteDifferenceVelocity.getPreviousPosition() ? Direction.BACKWARD : (Direction)this.lastPosChangeDirection.getEnumValue());
        return directionOfMotion;
    }

    private boolean determineIfDirectionChanged(double currentPosition) {
        Direction currentDirection = this.computeDirectionOfMotion(currentPosition);
        boolean directionOfMotionChanged = this.lastPosChangeDirection.getEnumValue() != currentDirection;
        this.lastPosChangeDirection.set((Enum)currentDirection);
        return directionOfMotionChanged;
    }

    private static enum Direction {
        NONE,
        FORWARD,
        BACKWARD;

    }
}

