/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.math.filters.AverageSampleYoDouble;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class AverageSampleYoFrameVector
extends YoFrameVector3D {
    private final AverageSampleYoDouble x;
    private final AverageSampleYoDouble y;
    private final AverageSampleYoDouble z;

    private AverageSampleYoFrameVector(AverageSampleYoDouble x, AverageSampleYoDouble y, AverageSampleYoDouble z, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, (YoDouble)z, referenceFrame);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static AverageSampleYoFrameVector createAverageSampleYoFrameVector(String namePrefix, YoRegistry registry, ReferenceFrame referenceFrame) {
        return AverageSampleYoFrameVector.createAverageSampleYoFrameVector(namePrefix, "", registry, referenceFrame);
    }

    public static AverageSampleYoFrameVector createAverageSampleYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        AverageSampleYoDouble x = new AverageSampleYoDouble(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry);
        AverageSampleYoDouble y = new AverageSampleYoDouble(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry);
        AverageSampleYoDouble z = new AverageSampleYoDouble(YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix), registry);
        AverageSampleYoFrameVector ret = new AverageSampleYoFrameVector(x, y, z, referenceFrame);
        return ret;
    }

    public static AverageSampleYoFrameVector createAverageSampleYoFrameVector(String namePrefix, YoRegistry registry, YoFrameVector3D dataSource, ReferenceFrame referenceFrame) {
        return AverageSampleYoFrameVector.createAverageSampleYoFrameVector(namePrefix, "", registry, dataSource, referenceFrame);
    }

    public static AverageSampleYoFrameVector createAverageSampleYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, YoFrameVector3D dataSource, ReferenceFrame referenceFrame) {
        AverageSampleYoDouble x = new AverageSampleYoDouble(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), dataSource.getYoX(), registry);
        AverageSampleYoDouble y = new AverageSampleYoDouble(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), dataSource.getYoY(), registry);
        AverageSampleYoDouble z = new AverageSampleYoDouble(YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix), dataSource.getYoZ(), registry);
        AverageSampleYoFrameVector ret = new AverageSampleYoFrameVector(x, y, z, referenceFrame);
        return ret;
    }

    public void update() {
        this.x.update();
        this.y.update();
        this.z.update();
    }

    public void update(double xSource, double ySource, double zSource) {
        this.x.update(xSource);
        this.y.update(ySource);
        this.z.update(zSource);
    }

    public void update(Vector3D vectorSource) {
        this.x.update(vectorSource.getX());
        this.y.update(vectorSource.getY());
        this.z.update(vectorSource.getZ());
    }

    public void update(FrameVector3D vectorSource) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)vectorSource);
        this.x.update(vectorSource.getX());
        this.y.update(vectorSource.getY());
        this.z.update(vectorSource.getZ());
    }

    public void doAverage() {
        this.x.doAverage();
        this.y.doAverage();
        this.z.doAverage();
    }

    public void reset() {
        this.x.reset();
        this.y.reset();
        this.z.reset();
    }
}

