/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class AverageSampleYoDouble
extends YoDouble {
    private final YoInteger dataLength;
    private final YoDouble dataSource;
    private final YoDouble dataCumulated;

    public AverageSampleYoDouble(String name, YoRegistry registry) {
        this(name, null, registry);
    }

    public AverageSampleYoDouble(String name, YoDouble dataSource, YoRegistry registry) {
        super(name, registry);
        this.dataSource = dataSource;
        this.dataLength = new YoInteger(name + "DataLength", registry);
        this.dataCumulated = new YoDouble(name + "DataCumulated", registry);
    }

    public void update() {
        if (this.dataSource == null) {
            throw new NullPointerException("AverageSampleYoDouble must be constructed with a non null dataSource variable to call update(), otherwise use update(double)");
        }
        this.update(this.dataSource.getDoubleValue());
    }

    public void update(double dataSource) {
        this.dataLength.increment();
        this.dataCumulated.add(dataSource);
    }

    public void doAverage() {
        if (this.dataLength.getIntegerValue() < 1) {
            return;
        }
        this.set(this.dataCumulated.getDoubleValue() / this.dataLength.getValueAsDouble());
        this.reset();
    }

    public void reset() {
        this.dataLength.set(0);
        this.dataCumulated.set(0.0);
    }
}

