/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFilteredYoFrameQuaternion
extends YoFrameQuaternion
implements ProcessingYoVariable {
    private final YoFrameQuaternion unfilteredQuaternion;
    private final DoubleProvider alpha;
    private final YoBoolean hasBeenCalled;
    private final Quaternion qMeasured = new Quaternion();
    private final Quaternion qPreviousFiltered = new Quaternion();
    private final Quaternion qNewFiltered = new Quaternion();

    private static DoubleProvider createAlphaYoDouble(String namePrefix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "AlphaVariable", registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public AlphaFilteredYoFrameQuaternion(String namePrefix, String nameSuffix, YoFrameQuaternion unfilteredQuaternion, double alpha, YoRegistry registry) {
        this(namePrefix, nameSuffix, unfilteredQuaternion, AlphaFilteredYoFrameQuaternion.createAlphaYoDouble(namePrefix, alpha, registry), registry);
    }

    public AlphaFilteredYoFrameQuaternion(String namePrefix, String nameSuffix, DoubleProvider alpha, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, nameSuffix, null, alpha, referenceFrame, registry);
    }

    public AlphaFilteredYoFrameQuaternion(String namePrefix, String nameSuffix, YoFrameQuaternion unfilteredQuaternion, DoubleProvider alpha, YoRegistry registry) {
        this(namePrefix, nameSuffix, unfilteredQuaternion, alpha, unfilteredQuaternion.getReferenceFrame(), registry);
    }

    private AlphaFilteredYoFrameQuaternion(String namePrefix, String nameSuffix, YoFrameQuaternion unfilteredQuaternion, DoubleProvider alpha, ReferenceFrame referenceFrame, YoRegistry registry) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.unfilteredQuaternion = unfilteredQuaternion;
        if (alpha == null) {
            alpha = AlphaFilteredYoFrameQuaternion.createAlphaYoDouble(namePrefix, 0.0, registry);
        }
        this.alpha = alpha;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
    }

    @Override
    public void update() {
        if (this.unfilteredQuaternion == null) {
            throw new NullPointerException("AlphaFilteredYoFrameQuaternion must be constructed with a non null quaternion variable to call update(), otherwise use update(Quat4d)");
        }
        this.qMeasured.set((QuaternionReadOnly)this.unfilteredQuaternion);
        this.update((QuaternionReadOnly)this.qMeasured);
    }

    public void update(FrameOrientation3DReadOnly rawOrientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)rawOrientation);
        this.qMeasured.set((Orientation3DReadOnly)rawOrientation);
        this.update((QuaternionReadOnly)this.qMeasured);
    }

    public void update(Orientation3DReadOnly rawOrientation) {
        this.qMeasured.set(rawOrientation);
        this.update((QuaternionReadOnly)this.qMeasured);
    }

    private void update(QuaternionReadOnly qMeasured) {
        if (this.hasBeenCalled.getBooleanValue()) {
            this.qPreviousFiltered.set((QuaternionReadOnly)this);
            this.qNewFiltered.interpolate(qMeasured, (QuaternionReadOnly)this.qPreviousFiltered, this.alpha.getValue());
            this.set((QuaternionReadOnly)this.qNewFiltered);
        } else {
            this.set(qMeasured);
            this.hasBeenCalled.set(true);
        }
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public YoFrameQuaternion getUnfilteredQuaternion() {
        return this.unfilteredQuaternion;
    }
}

