/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class AlphaFilteredYoFramePoint2d
extends YoFramePoint2D {
    private final DoubleProvider alphaProvider;
    private final FrameTuple2DReadOnly position;
    private final YoBoolean hasBeenCalled;
    private final Point2D unfilteredPoint2D = new Point2D();

    @Deprecated
    public static AlphaFilteredYoFramePoint2d createAlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, ReferenceFrame referenceFrame) {
        return new AlphaFilteredYoFramePoint2d(namePrefix, nameSuffix, registry, alpha, referenceFrame);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint2d createAlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame) {
        return AlphaFilteredYoFramePoint2d.createAlphaFilteredYoFramePoint2d(namePrefix, nameSuffix, "", registry, alpha, referenceFrame);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint2d createAlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, String description, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame) {
        return new AlphaFilteredYoFramePoint2d(namePrefix, nameSuffix, registry, alpha, referenceFrame);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint2d createAlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, FrameTuple2DReadOnly unfilteredFrameTuple2D) {
        return new AlphaFilteredYoFramePoint2d(namePrefix, nameSuffix, registry, alpha, unfilteredFrameTuple2D);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint2d createAlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, FrameTuple2DReadOnly unfilteredFrameTuple2D) {
        return new AlphaFilteredYoFramePoint2d(namePrefix, nameSuffix, registry, alpha, unfilteredFrameTuple2D);
    }

    public AlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, AlphaFilteredYoVariable.createAlphaYoDouble(namePrefix + nameSuffix, alpha, registry), referenceFrame);
    }

    public AlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, alpha, referenceFrame, null);
    }

    public AlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, FrameTuple2DReadOnly unfilteredFrameTuple2D) {
        this(namePrefix, nameSuffix, registry, AlphaFilteredYoVariable.createAlphaYoDouble(namePrefix + nameSuffix, alpha, registry), unfilteredFrameTuple2D.getReferenceFrame(), unfilteredFrameTuple2D);
    }

    public AlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, FrameTuple2DReadOnly unfilteredFrameTuple2D) {
        this(namePrefix, nameSuffix, registry, alpha, unfilteredFrameTuple2D.getReferenceFrame(), unfilteredFrameTuple2D);
    }

    private AlphaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame, FrameTuple2DReadOnly unfilteredFrameTuple2D) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.alphaProvider = alpha;
        this.position = unfilteredFrameTuple2D;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position);
    }

    public void update(FrameTuple2DReadOnly unfilteredFrameTuple2D) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)unfilteredFrameTuple2D);
        this.update((Tuple2DReadOnly)unfilteredFrameTuple2D);
    }

    public void update(Tuple2DReadOnly unfilteredTuple2D) {
        this.update(unfilteredTuple2D.getX(), unfilteredTuple2D.getY());
    }

    public void update(double xUnfiltered, double yUnfiltered) {
        if (!this.hasBeenCalled.getValue()) {
            this.hasBeenCalled.set(true);
            this.set(xUnfiltered, yUnfiltered);
        } else {
            this.unfilteredPoint2D.set(xUnfiltered, yUnfiltered);
            this.interpolate((Tuple2DReadOnly)this.unfilteredPoint2D, (FrameTuple2DReadOnly)this, this.alphaProvider.getValue());
        }
    }
}

