/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class AlphaFilteredYoFramePoint
extends YoFramePoint3D {
    private final DoubleProvider alphaProvider;
    private final FrameTuple3DReadOnly position;
    private final YoBoolean hasBeenCalled;
    private final Point3D unfilteredPoint3D = new Point3D();

    @Deprecated
    public static AlphaFilteredYoFramePoint createAlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, ReferenceFrame referenceFrame) {
        return new AlphaFilteredYoFramePoint(namePrefix, nameSuffix, registry, alpha, referenceFrame);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint createAlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame) {
        return new AlphaFilteredYoFramePoint(namePrefix, nameSuffix, registry, alpha, referenceFrame);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint createAlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, FrameTuple3DReadOnly unfilteredFrameTuple3D) {
        return new AlphaFilteredYoFramePoint(namePrefix, nameSuffix, registry, alpha, unfilteredFrameTuple3D);
    }

    @Deprecated
    public static AlphaFilteredYoFramePoint createAlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, FrameTuple3DReadOnly unfilteredFrameTuple3D) {
        return new AlphaFilteredYoFramePoint(namePrefix, nameSuffix, registry, alpha, unfilteredFrameTuple3D);
    }

    public AlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, AlphaFilteredYoVariable.createAlphaYoDouble(namePrefix + nameSuffix, alpha, registry), referenceFrame);
    }

    public AlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, alpha, referenceFrame, null);
    }

    public AlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, double alpha, FrameTuple3DReadOnly unfilteredFrameTuple3D) {
        this(namePrefix, nameSuffix, registry, AlphaFilteredYoVariable.createAlphaYoDouble(namePrefix + nameSuffix, alpha, registry), unfilteredFrameTuple3D.getReferenceFrame(), unfilteredFrameTuple3D);
    }

    public AlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, FrameTuple3DReadOnly unfilteredFrameTuple3D) {
        this(namePrefix, nameSuffix, registry, alpha, unfilteredFrameTuple3D.getReferenceFrame(), unfilteredFrameTuple3D);
    }

    private AlphaFilteredYoFramePoint(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider alpha, ReferenceFrame referenceFrame, FrameTuple3DReadOnly unfilteredFrameTuple3D) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.alphaProvider = alpha;
        this.position = unfilteredFrameTuple3D;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position);
    }

    public void update(FrameTuple3DReadOnly unfilteredFrameTuple3D) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)unfilteredFrameTuple3D);
        this.update((Tuple3DReadOnly)unfilteredFrameTuple3D);
    }

    public void update(Tuple3DReadOnly unfilteredTuple3D) {
        this.update(unfilteredTuple3D.getX(), unfilteredTuple3D.getY(), unfilteredTuple3D.getZ());
    }

    public void update(double xUnfiltered, double yUnfiltered, double zUnfiltered) {
        if (!this.hasBeenCalled.getValue()) {
            this.hasBeenCalled.set(true);
            this.set(xUnfiltered, yUnfiltered, zUnfiltered);
        } else {
            this.unfilteredPoint3D.set(xUnfiltered, yUnfiltered, zUnfiltered);
            this.interpolate((Tuple3DReadOnly)this.unfilteredPoint3D, (FrameTuple3DReadOnly)this, this.alphaProvider.getValue());
        }
    }
}

