/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaBetaFilteredYoVariable
extends YoDouble {
    private double alpha = 0.0;
    private double beta = 0.0;
    private final double DT;
    private YoDouble alphaVariable = null;
    private YoDouble betaVariable = null;
    private final YoDouble positionState;
    private final YoDouble xMeasuredVariable;

    public AlphaBetaFilteredYoVariable(String name, YoRegistry registry, double alpha, double beta, YoDouble positionVariable, YoDouble xMeasuredVariable, double DT) {
        super(name, registry);
        this.alpha = alpha;
        this.beta = beta;
        this.DT = DT;
        this.positionState = positionVariable;
        this.xMeasuredVariable = xMeasuredVariable;
        this.reset();
    }

    public AlphaBetaFilteredYoVariable(String name, YoRegistry registry, YoDouble alphaVariable, YoDouble betaVariable, YoDouble positionVariable, YoDouble xMeasuredVariable, double DT) {
        super(name, registry);
        this.alphaVariable = alphaVariable;
        this.betaVariable = betaVariable;
        this.DT = DT;
        this.positionState = positionVariable;
        this.xMeasuredVariable = xMeasuredVariable;
        this.reset();
    }

    public void reset() {
    }

    public YoDouble getPositionEstimation() {
        return this.positionState;
    }

    public YoDouble getVelocityEstimation() {
        return this;
    }

    public void update() {
        this.update(this.positionState.getDoubleValue());
    }

    public void update(double position) {
        if (this.alphaVariable != null) {
            this.alpha = this.alphaVariable.getDoubleValue();
        }
        if (this.betaVariable != null) {
            this.beta = this.betaVariable.getDoubleValue();
        }
        double velocity = this.getDoubleValue();
        double prediction = position + this.DT * velocity;
        double error = this.xMeasuredVariable.getDoubleValue() - prediction;
        double newPosition = prediction + this.alpha * error;
        double newVelocity = velocity + this.beta * error;
        this.positionState.set(newPosition);
        this.set(newVelocity);
    }
}

