/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AlphaBasedOnBreakFrequencyProvider
implements DoubleProvider {
    private final DoubleProvider breakFrequencyProvider;
    private final double dt;
    private double previousBreakFrequency = Double.NaN;
    private double alpha = 0.0;

    public AlphaBasedOnBreakFrequencyProvider(DoubleProvider breakFrequencyProvider, double dt) {
        this.breakFrequencyProvider = breakFrequencyProvider;
        this.dt = dt;
    }

    public AlphaBasedOnBreakFrequencyProvider(String name, double dt, YoRegistry registry, double defaultBreakFrequency) {
        this((DoubleProvider)new DoubleParameter(name, registry, defaultBreakFrequency), dt);
    }

    public AlphaBasedOnBreakFrequencyProvider(String name, double dt, YoRegistry registry) {
        this.breakFrequencyProvider = new DoubleParameter(name, registry, Double.NaN);
        this.dt = dt;
    }

    public double getValue() {
        double currentBreakFrequency = this.breakFrequencyProvider.getValue();
        if (currentBreakFrequency != this.previousBreakFrequency) {
            this.alpha = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly(currentBreakFrequency, this.dt);
            this.previousBreakFrequency = currentBreakFrequency;
        }
        return this.alpha;
    }
}

