/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.corruptors;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.robotics.math.corruptors.NoiseType;
import us.ihmc.robotics.math.corruptors.NoisyYoDouble;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class NoisyYoRotationMatrix {
    public static final double DEFAULT_NOISE_ROTATION_ANGLE_STANDARD_DEVIATION = 0.17453292519943295;
    public static final double DEFAULT_NOISE_DIRECTION_HEIGHT_BOUND = 1.0;
    public static final double DEFAULT_NOISE_DIRECTION_ANGLE_BOUND = Math.PI;
    public static final double DEFAULT_BIAS_ROTATION_ANGLE = 0.0;
    public static final double DEFAULT_BIAS_ROTATION_ANGLE_MAX = Math.PI;
    public static final double DEFAULT_BIAS_ROTATION_ANGLE_MIN = -Math.PI;
    public static final double DEFAULT_BIAS_ROTATION_ANGLE_DELTA = 0.0;
    public static final double DEFAULT_BIAS_DIRECTION_HEIGHT = 0.0;
    public static final double DEFAULT_BIAS_DIRECTION_HEIGHT_MAX = 1.0;
    public static final double DEFAULT_BIAS_DIRECTION_HEIGHT_MIN = -1.0;
    public static final double DEFAULT_BIAS_DIRECTION_HEIGHT_DELTA = 0.0;
    public static final double DEFAULT_BIAS_DIRECTION_ANGLE = 0.0;
    public static final double DEFAULT_BIAS_DIRECTION_ANGLE_MAX = Math.PI;
    public static final double DEFAULT_BIAS_DIRECTION_ANGLE_MIN = -Math.PI;
    public static final double DEFAULT_BIAS_DIRECTION_ANGLE_DELTA = 0.0;
    private final RotationMatrix perfectRotationMatrix = new RotationMatrix();
    private final RotationMatrix noisyRotationMatrix = new RotationMatrix();
    private final RotationMatrix biasMatrix = new RotationMatrix();
    private final RotationMatrix noiseMatrix = new RotationMatrix();
    private final NoisyYoDouble noiseRotationAngle;
    private final NoisyYoDouble noiseDirectionHeight;
    private final NoisyYoDouble noiseDirectionAngle;
    private final NoisyYoDouble biasRotationAngle;
    private final NoisyYoDouble biasDirectionHeight;
    private final NoisyYoDouble biasDirectionAngle;
    private final YoDouble noiseDirectionX;
    private final YoDouble noiseDirectionY;
    private final YoDouble noiseDirectionZ;
    private final YoDouble biasDirectionX;
    private final YoDouble biasDirectionY;
    private final YoDouble biasDirectionZ;

    public NoisyYoRotationMatrix(String name, YoRegistry registry) {
        this.noiseRotationAngle = new NoisyYoDouble(name + "_noise_rot_ang", registry);
        this.noiseDirectionHeight = new NoisyYoDouble(name + "_noise_dir_height", registry);
        this.noiseDirectionAngle = new NoisyYoDouble(name + "_noise_dir_ang", registry);
        this.biasRotationAngle = new NoisyYoDouble(name + "_bias_rot_ang", registry);
        this.biasDirectionHeight = new NoisyYoDouble(name + "_bias_dir_height", registry);
        this.biasDirectionAngle = new NoisyYoDouble(name + "_bias_dir_ang", registry);
        this.noiseDirectionX = new YoDouble(name + "_noise_dir_x", registry);
        this.noiseDirectionY = new YoDouble(name + "_noise_dir_y", registry);
        this.noiseDirectionZ = new YoDouble(name + "_noise_dir_z", registry);
        this.biasDirectionX = new YoDouble(name + "_bias_dir_x", registry);
        this.biasDirectionY = new YoDouble(name + "_bias_dir_y", registry);
        this.biasDirectionZ = new YoDouble(name + "_bias_dir_z", registry);
        this.noiseRotationAngle.setGaussianNoise(0.17453292519943295);
        this.noiseDirectionHeight.setRandomBound(1.0);
        this.noiseDirectionAngle.setRandomBound(Math.PI);
        this.noiseRotationAngle.setBias(false);
        this.noiseDirectionHeight.setBias(false);
        this.noiseDirectionAngle.setBias(false);
        this.biasRotationAngle.setRandomBound(0.0);
        this.biasDirectionHeight.setRandomBound(0.0);
        this.biasDirectionAngle.setRandomBound(0.0);
        this.biasRotationAngle.setBias(0.0, Math.PI, -Math.PI, 0.0);
        this.biasDirectionHeight.setBias(0.0, 1.0, -1.0, 0.0);
        this.biasDirectionAngle.setBias(0.0, Math.PI, -Math.PI, 0.0);
        this.biasRotationAngle.setIsNoisy(false);
        this.biasDirectionHeight.setIsNoisy(false);
        this.biasDirectionAngle.setIsNoisy(false);
    }

    public void update(RotationMatrix m) {
        this.update(m.getM00(), m.getM01(), m.getM02(), m.getM10(), m.getM11(), m.getM12(), m.getM20(), m.getM21(), m.getM22());
    }

    public void update(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.perfectRotationMatrix.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        this.generateNoise();
        this.generateBias();
        this.noisyRotationMatrix.set(this.perfectRotationMatrix);
        this.noisyRotationMatrix.multiply((RotationMatrixReadOnly)this.biasMatrix);
        this.noisyRotationMatrix.multiply((RotationMatrixReadOnly)this.noiseMatrix);
        if (Double.valueOf(this.noisyRotationMatrix.getM00()).isNaN()) {
            this.noisyRotationMatrix.set(this.perfectRotationMatrix);
        }
    }

    private void generateNoise() {
        this.noiseDirectionHeight.update(0.0);
        this.noiseDirectionAngle.update(0.0);
        this.noiseRotationAngle.update(0.0);
        double height = this.noiseDirectionHeight.getDoubleValue();
        double angle = this.noiseDirectionAngle.getDoubleValue();
        double radius = Math.sqrt(1.0 - height * height);
        this.noiseDirectionX.set(radius * Math.cos(angle));
        this.noiseDirectionY.set(radius * Math.sin(angle));
        this.noiseDirectionZ.set(height);
        this.noiseMatrix.set((Orientation3DReadOnly)new AxisAngle(this.noiseDirectionX.getDoubleValue(), this.noiseDirectionY.getDoubleValue(), this.noiseDirectionZ.getDoubleValue(), this.noiseRotationAngle.getDoubleValue()));
    }

    private void generateBias() {
        this.biasDirectionHeight.update(0.0);
        this.biasDirectionAngle.update(0.0);
        this.biasRotationAngle.update(0.0);
        double height = this.biasDirectionHeight.getDoubleValue();
        double angle = this.biasDirectionAngle.getDoubleValue();
        double radius = Math.sqrt(1.0 - height * height);
        this.biasDirectionX.set(radius * Math.cos(angle));
        this.biasDirectionY.set(radius * Math.sin(angle));
        this.biasDirectionZ.set(height);
        this.biasMatrix.set((Orientation3DReadOnly)new AxisAngle(this.biasDirectionX.getDoubleValue(), this.biasDirectionY.getDoubleValue(), this.biasDirectionZ.getDoubleValue(), this.biasRotationAngle.getDoubleValue()));
    }

    public RotationMatrix getMatrix3d() {
        return this.noisyRotationMatrix;
    }

    public void setIsNoisy(boolean choice) {
        this.noiseRotationAngle.setIsNoisy(choice);
        this.noiseDirectionHeight.setIsNoisy(choice);
        this.noiseDirectionAngle.setIsNoisy(choice);
        this.biasRotationAngle.setIsNoisy(choice);
        this.biasDirectionHeight.setIsNoisy(choice);
        this.biasDirectionAngle.setIsNoisy(choice);
    }

    public void setBias(boolean choice) {
        this.biasRotationAngle.setIsNoisy(choice);
        this.biasDirectionHeight.setIsNoisy(choice);
        this.biasDirectionAngle.setIsNoisy(choice);
    }

    public void setBias(double biasOfRotationAngle) {
        this.biasRotationAngle.setBias(biasOfRotationAngle);
    }

    public void setBias(double biasOfRotationAngle, double biasOfDirectionHeight, double biasOfDirectionAngle) {
        this.biasRotationAngle.setBias(biasOfRotationAngle);
        this.biasDirectionHeight.setBias(biasOfDirectionHeight);
        this.biasDirectionAngle.setBias(biasOfDirectionAngle);
    }

    public void setBiasOfRotationAngle(double bias, double biasMax, double biasMin, double biasDelta) {
        this.biasRotationAngle.setBias(bias, biasMax, biasMin, biasDelta);
    }

    public void setBiasOfDirectionHeight(double bias, double biasMax, double biasMin, double biasDelta) {
        this.biasDirectionHeight.setBias(bias, biasMax, biasMin, biasDelta);
    }

    public void setBiasOfDirectionAngle(double bias, double biasMax, double biasMin, double biasDelta) {
        this.biasDirectionAngle.setBias(bias, biasMax, biasMin, biasDelta);
    }

    public void setBiasRandomlyBetweenMinAndMax() {
        this.biasRotationAngle.setBiasRandomlyBetweenMinAndMax();
        this.biasDirectionHeight.setBiasRandomlyBetweenMinAndMax();
        this.biasDirectionAngle.setBiasRandomlyBetweenMinAndMax();
    }

    public void setNoiseType(NoiseType noiseType) {
        this.noiseRotationAngle.setNoiseType(noiseType);
    }

    public void setRandomBound(double randomBound) {
        this.noiseRotationAngle.setRandomBound(randomBound);
    }

    public void setGaussianNoise(double standardDeviation) {
        this.noiseRotationAngle.setGaussianNoise(standardDeviation);
    }
}

