/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.corruptors;

import java.util.Random;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.corruptors.NoiseType;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class NoisyYoDouble
extends YoDouble {
    private static final long serialVersionUID = 8152020075993223818L;
    private final YoBoolean isNoisy;
    private final YoBoolean useBias;
    private final YoEnum<NoiseType> noiseType;
    private final long randomSeed = System.nanoTime();
    private final Random rand = new Random(this.randomSeed);
    private final YoDouble randomBound;
    private final YoDouble bias;
    private final YoDouble biasMin;
    private final YoDouble biasMax;
    private final YoDouble biasDelta;
    private final YoDouble standardDeviation;
    private final YoDouble perfect;

    public NoisyYoDouble(String name, YoRegistry registry) {
        super(name, registry);
        this.isNoisy = new YoBoolean(name + "_IsNoisy", registry);
        this.isNoisy.set(false);
        this.randomBound = new YoDouble(name + "_RandomBound", registry);
        this.randomBound.set(0.0);
        this.useBias = new YoBoolean(name + "_UseBias", registry);
        this.useBias.set(false);
        this.bias = new YoDouble(name + "_Bias", registry);
        this.bias.set(0.0);
        this.biasMax = new YoDouble(name + "_BiasMax", registry);
        this.biasMax.set(0.0);
        this.biasMin = new YoDouble(name + "_BiasMin", registry);
        this.biasMin.set(0.0);
        this.biasDelta = new YoDouble(name + "_BiasDelta", registry);
        this.biasDelta.set(0.0);
        this.noiseType = new YoEnum(name + "_NoiseType", registry, NoiseType.class);
        this.noiseType.set((Enum)NoiseType.UNIFORM);
        this.standardDeviation = new YoDouble(name + "_StandardDeviation", registry);
        this.standardDeviation.set(0.0);
        this.perfect = new YoDouble(name + "_Perfect", registry);
        this.update(0.0);
    }

    public NoisyYoDouble(String name, YoRegistry registry, YoDouble perfect) {
        super(name, registry);
        this.isNoisy = new YoBoolean(name + "_IsNoisy", registry);
        this.isNoisy.set(false);
        this.randomBound = new YoDouble(name + "_RandomBound", registry);
        this.randomBound.set(0.0);
        this.useBias = new YoBoolean(name + "_UseBias", registry);
        this.useBias.set(false);
        this.bias = new YoDouble(name + "_Bias", registry);
        this.bias.set(0.0);
        this.biasMax = new YoDouble(name + "_BiasMax", registry);
        this.biasMax.set(0.0);
        this.biasMin = new YoDouble(name + "_BiasMin", registry);
        this.biasMin.set(0.0);
        this.biasDelta = new YoDouble(name + "_BiasDelta", registry);
        this.biasDelta.set(0.0);
        this.noiseType = new YoEnum(name + "_NoiseType", registry, NoiseType.class);
        this.noiseType.set((Enum)NoiseType.UNIFORM);
        this.standardDeviation = new YoDouble(name + "_StandardDeviation", registry);
        this.standardDeviation.set(0.0);
        this.perfect = perfect;
        this.update();
    }

    public NoisyYoDouble(String name, YoRegistry registry, boolean isNoisy, double randomBound, boolean useBias, double bias, double biasMax, double biasMin, double biasDelta, NoiseType noiseType, double standardDeviation) {
        super(name, registry);
        this.isNoisy = new YoBoolean(name + "_IsNoisy", registry);
        this.isNoisy.set(isNoisy);
        this.randomBound = new YoDouble(name + "_RandomBound", registry);
        this.randomBound.set(randomBound);
        this.useBias = new YoBoolean(name + "_UseBias", registry);
        this.useBias.set(useBias);
        this.bias = new YoDouble(name + "_Bias", registry);
        this.bias.set(bias);
        this.biasMax = new YoDouble(name + "_BiasMax", registry);
        this.biasMax.set(biasMax);
        this.biasMin = new YoDouble(name + "_BiasMin", registry);
        this.biasMin.set(biasMin);
        this.biasDelta = new YoDouble(name + "_BiasDelta", registry);
        this.biasDelta.set(biasDelta);
        this.noiseType = new YoEnum(name + "_NoiseType", registry, NoiseType.class);
        this.noiseType.set((Enum)noiseType);
        this.standardDeviation = new YoDouble(name + "_StandardDeviation", registry);
        this.standardDeviation.set(standardDeviation);
        this.perfect = new YoDouble(name + "_Perfect", registry);
        this.update(0.0);
    }

    public NoisyYoDouble(String name, YoRegistry registry, YoDouble perfect, boolean isNoisy, double randomBound, boolean useBias, double bias, double biasMax, double biasMin, double biasDelta, NoiseType noiseType, double standardDeviation) {
        super(name, registry);
        this.isNoisy = new YoBoolean(name + "_IsNoisy", registry);
        this.isNoisy.set(isNoisy);
        this.randomBound = new YoDouble(name + "_RandomBound", registry);
        this.randomBound.set(randomBound);
        this.useBias = new YoBoolean(name + "_UseBias", registry);
        this.useBias.set(useBias);
        this.bias = new YoDouble(name + "_Bias", registry);
        this.bias.set(bias);
        this.biasMax = new YoDouble(name + "_BiasMax", registry);
        this.biasMax.set(biasMax);
        this.biasMin = new YoDouble(name + "_BiasMin", registry);
        this.biasMin.set(biasMin);
        this.biasDelta = new YoDouble(name + "_BiasDelta", registry);
        this.biasDelta.set(biasDelta);
        this.noiseType = new YoEnum(name + "_NoiseType", registry, NoiseType.class);
        this.noiseType.set((Enum)noiseType);
        this.standardDeviation = new YoDouble(name + "_StandardDeviation", registry);
        this.standardDeviation.set(standardDeviation);
        this.perfect = perfect;
        this.update();
    }

    public void update() {
        this.update(this.perfect.getDoubleValue());
    }

    public void update(double perfectValue) {
        this.perfect.set(perfectValue);
        if (this.isNoisy.getBooleanValue()) {
            double noise = this.getBias() + this.getRandomNoise();
            super.set(this.perfect.getDoubleValue() + noise);
        } else {
            super.set(this.perfect.getDoubleValue());
        }
    }

    public double getPerfectDoubleValue() {
        return this.perfect.getDoubleValue();
    }

    public void setIsNoisy(boolean choice) {
        this.isNoisy.set(choice);
    }

    public void setBias(boolean choice) {
        this.useBias.set(choice);
    }

    public void setBias(double bias) {
        this.useBias.set(true);
        this.bias.set(bias);
        if (bias > this.biasMax.getDoubleValue()) {
            this.biasMax.set(bias);
        }
        if (bias < this.biasMin.getDoubleValue()) {
            this.biasMin.set(bias);
        }
        this.biasDelta.set(0.0);
    }

    public void setBias(double bias, double biasMax, double biasMin, double biasDelta) {
        this.useBias.set(true);
        this.bias.set(bias);
        this.biasMax.set(biasMax);
        this.biasMin.set(biasMin);
        this.biasDelta.set(biasDelta);
    }

    public void setBiasRandomlyBetweenMinAndMax() {
        this.bias.set((this.biasMax.getDoubleValue() - this.biasMin.getDoubleValue()) * this.rand.nextDouble() + this.biasMin.getDoubleValue());
    }

    public void setNoiseType(NoiseType noiseType) {
        this.noiseType.set((Enum)noiseType);
    }

    public void setRandomBound(double randomBound) {
        this.noiseType.set((Enum)NoiseType.UNIFORM);
        this.randomBound.set(randomBound);
    }

    public void setGaussianNoise(double standardDeviation) {
        this.noiseType.set((Enum)NoiseType.GAUSSIAN);
        this.standardDeviation.set(standardDeviation);
    }

    private double getBias() {
        if (this.useBias.getBooleanValue()) {
            double biasWalk = this.biasDelta.getDoubleValue() * (2.0 * this.rand.nextDouble() - 1.0);
            this.bias.set(MathTools.clamp((double)(this.bias.getDoubleValue() + biasWalk), (double)this.biasMin.getDoubleValue(), (double)this.biasMax.getDoubleValue()));
            return this.bias.getDoubleValue();
        }
        return 0.0;
    }

    private double getRandomNoise() {
        switch ((NoiseType)this.noiseType.getEnumValue()) {
            case UNIFORM: {
                return this.randomBound.getDoubleValue() * (2.0 * this.rand.nextDouble() - 1.0);
            }
            case GAUSSIAN: {
                return this.standardDeviation.getDoubleValue() * this.rand.nextGaussian();
            }
        }
        throw new RuntimeException("Noise type not recognized");
    }
}

