/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoVariableComparer {
    private final YoEnum<CompareStatus> status;
    private final YoDouble yoVariableA;
    private final YoDouble yoVariableB;
    private final YoDouble difference;
    private final YoDouble threshold;
    private final double nonChangingThreshold;
    private ThresholdType compareType;

    public YoVariableComparer(YoDouble variableA, YoDouble variableB, String name, ThresholdType thresholdType, YoDouble threshold, YoRegistry registry) {
        this.yoVariableA = variableA;
        this.yoVariableB = variableB;
        this.compareType = thresholdType;
        this.threshold = threshold;
        this.nonChangingThreshold = Double.NaN;
        this.status = new YoEnum(name + "_status", registry, CompareStatus.class);
        this.difference = new YoDouble(name, registry);
    }

    public YoVariableComparer(YoDouble variableA, YoDouble variableB, String name, ThresholdType thresholdType, double threshold, YoRegistry registry) {
        this.yoVariableA = variableA;
        this.yoVariableB = variableB;
        this.compareType = thresholdType;
        this.threshold = null;
        this.nonChangingThreshold = threshold;
        this.difference = new YoDouble(name, registry);
        this.status = new YoEnum(name + "_status", registry, CompareStatus.class);
    }

    public void update() {
        double threshold = this.threshold != null ? this.threshold.getDoubleValue() : this.nonChangingThreshold;
        double aValue = this.yoVariableA.getDoubleValue();
        double bValue = this.yoVariableB.getDoubleValue();
        switch (this.compareType) {
            case DIFFERENCE_GREATER_THAN: {
                this.difference.set(Math.abs(bValue - aValue));
                this.status.set((Enum)(this.difference.getDoubleValue() > threshold ? CompareStatus.ABOVE_LIMIT : CompareStatus.IN_RANGE));
                break;
            }
            case DIFFERENCE_LESS_THAN: {
                this.difference.set(Math.abs(bValue - aValue));
                this.status.set((Enum)(this.difference.getDoubleValue() < threshold ? CompareStatus.BELOW_LIMIT : CompareStatus.IN_RANGE));
                break;
            }
            case SQUARED_DIFFERENCE_GREATER_THAN: {
                this.difference.set(Math.pow(bValue - aValue, 2.0));
                this.status.set((Enum)(this.difference.getDoubleValue() < threshold ? CompareStatus.BELOW_LIMIT : CompareStatus.IN_RANGE));
                break;
            }
            case SQUARED_DIFFERENCE_LESS_THAN: {
                this.difference.set(Math.pow(bValue - aValue, 2.0));
                this.status.set((Enum)(this.difference.getDoubleValue() < threshold ? CompareStatus.BELOW_LIMIT : CompareStatus.IN_RANGE));
                break;
            }
        }
    }

    public double getDoubleValue() {
        return this.difference.getDoubleValue();
    }

    public CompareStatus getStatus() {
        return (CompareStatus)this.status.getEnumValue();
    }

    public String getName() {
        return this.difference.getName();
    }

    public static enum CompareStatus {
        IN_RANGE,
        BELOW_LIMIT,
        ABOVE_LIMIT;

    }

    public static enum ThresholdType {
        DIFFERENCE_GREATER_THAN,
        DIFFERENCE_LESS_THAN,
        SQUARED_DIFFERENCE_LESS_THAN,
        SQUARED_DIFFERENCE_GREATER_THAN;

    }
}

