/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoRMSCalculator {
    private final YoDouble rms;
    private final YoInteger nUpdates;

    public YoRMSCalculator(String prefix, YoRegistry registry) {
        this.rms = new YoDouble(prefix + "Rms", registry);
        this.nUpdates = new YoInteger(prefix + "RmsNUpdates", registry);
    }

    public void update(double input) {
        int nUpdatesOld = this.nUpdates.getIntegerValue();
        this.nUpdates.increment();
        int nUpdatesNew = this.nUpdates.getIntegerValue();
        double ratio = (double)nUpdatesOld / (double)nUpdatesNew;
        this.rms.set(Math.sqrt(MathTools.square((double)this.rms.getDoubleValue()) * ratio + MathTools.square((double)input) / (double)nUpdatesNew));
    }

    public double val() {
        return this.rms.getDoubleValue();
    }

    public void reset() {
        this.nUpdates.set(0);
    }
}

