/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class TimestampedVelocityYoVariable
extends YoDouble {
    private final YoDouble positionToReferenceOnUpdate;
    private final YoDouble updatedPosition;
    private final YoDouble previousPosition;
    private final YoDouble timeToReferenceOnUpdate;
    private final YoDouble updatedTimestamp;
    private final YoDouble previousTimestamp;
    private final YoBoolean hasBeenUpdated;
    private final double epsilonChange;

    public TimestampedVelocityYoVariable(String name, String description, YoDouble positionToReferenceOnUpdate, YoDouble timeToReferenceOnUpdate, YoRegistry registry, double epsilonChange) {
        super(name, description, registry);
        this.positionToReferenceOnUpdate = positionToReferenceOnUpdate;
        this.updatedPosition = new YoDouble(name + "_position", registry);
        this.previousPosition = new YoDouble(name + "_prevPosition", registry);
        this.timeToReferenceOnUpdate = timeToReferenceOnUpdate;
        this.updatedTimestamp = new YoDouble(name + "_timestamp", registry);
        this.previousTimestamp = new YoDouble(name + "_prevTimestamp", registry);
        this.hasBeenUpdated = new YoBoolean(name + "_hasBeenUpdated", registry);
        this.epsilonChange = epsilonChange;
        this.reset();
    }

    public void reset() {
        this.hasBeenUpdated.set(false);
        this.set(0.0);
    }

    public void update() {
        this.previousPosition.set(this.updatedPosition.getDoubleValue());
        this.previousTimestamp.set(this.updatedTimestamp.getDoubleValue());
        this.updatedPosition.set(this.positionToReferenceOnUpdate.getDoubleValue());
        this.updatedTimestamp.set(this.timeToReferenceOnUpdate.getDoubleValue());
        if (this.hasBeenUpdated.getBooleanValue()) {
            if (Math.abs(this.updatedPosition.getDoubleValue() - this.previousPosition.getDoubleValue()) > this.epsilonChange) {
                double dx = this.updatedPosition.getDoubleValue() - this.previousPosition.getDoubleValue();
                double dt = this.updatedTimestamp.getDoubleValue() - this.previousTimestamp.getDoubleValue();
                double velocity = dx / dt;
                this.set(velocity);
            }
        } else {
            this.set(0.0);
            this.hasBeenUpdated.set(true);
        }
    }

    public double getPosition() {
        return this.updatedPosition.getDoubleValue();
    }

    public double getTimestamp() {
        return this.updatedTimestamp.getDoubleValue();
    }

    public double getPreviousPosition() {
        return this.previousPosition.getDoubleValue();
    }

    public double getPreviousTimestamp() {
        return this.previousTimestamp.getDoubleValue();
    }
}

