/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lists;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoPreallocatedList<T>
implements List<T> {
    private final Class<T> clazz;
    private final T[] values;
    private final YoInteger position;

    public YoPreallocatedList(Class<T> clazz, String prefix, int capacity, YoRegistry registry) {
        this(clazz, new DefaultYoVariableAllocator<T>(clazz, prefix, registry), prefix, registry, capacity);
    }

    public YoPreallocatedList(Class<T> clazz, Supplier<T> allocator, String prefix, YoRegistry registry, int capacity) {
        this.clazz = clazz;
        this.position = new YoInteger(prefix + "Index", registry);
        this.values = (Object[])Array.newInstance(clazz, capacity);
        for (int i = 0; i < capacity; ++i) {
            this.values[i] = allocator.get();
        }
        this.position.set(-1);
    }

    public YoInteger getYoPosition() {
        return this.position;
    }

    @Override
    public T[] toArray() {
        Object[] array = (Object[])Array.newInstance(this.clazz, this.size());
        System.arraycopy(this.values, 0, array, 0, this.size());
        return array;
    }

    @Override
    public <S> S[] toArray(S[] dest) {
        int size = this.size();
        if (dest.length < size) {
            return Arrays.copyOf(this.values, size, dest.getClass());
        }
        System.arraycopy(this.values, 0, dest, 0, size);
        if (dest.length > size) {
            dest[size] = null;
        }
        return dest;
    }

    public void resetQuick() {
        this.position.set(-1);
    }

    public T add() {
        this.maxCapacityCheck(this.position.getIntegerValue() + 1);
        this.position.increment();
        T val = this.values[this.position.getIntegerValue()];
        return val;
    }

    public void remove() {
        this.nonEmptyCheck();
        this.position.decrement();
    }

    @Override
    public T remove(int i) {
        if (i == this.position.getIntegerValue()) {
            this.remove();
            return this.values[i];
        }
        this.rangeCheck(i);
        T t = this.values[i];
        while (i < this.position.getIntegerValue()) {
            this.values[i++] = this.values[i];
        }
        this.values[this.position.getIntegerValue()] = t;
        this.position.decrement();
        return t;
    }

    public void swap(int i, int j) {
        this.rangeCheck(i);
        this.rangeCheck(j);
        if (i == j) {
            return;
        }
        this.unsafeSwap(i, j);
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        if (this.size() == 0) {
            return;
        }
        Arrays.sort(this.values, 0, this.size(), comparator);
    }

    private void unsafeSwap(int i, int j) {
        T t = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = t;
    }

    @Override
    public T get(int i) {
        this.rangeCheck(i);
        return this.values[i];
    }

    @Override
    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values[0];
    }

    @Override
    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values[this.position.getIntegerValue()];
    }

    @Override
    public void clear() {
        this.resetQuick();
    }

    @Override
    public int size() {
        return this.position.getIntegerValue() + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int capacity() {
        return this.values.length;
    }

    public int remaining() {
        return this.capacity() - this.size();
    }

    private void nonEmptyCheck() {
        if (this.position.getIntegerValue() < 0) {
            throw new ArrayIndexOutOfBoundsException("List is empty");
        }
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.position.getIntegerValue()) {
            throw new ArrayIndexOutOfBoundsException("Position is not valid in the list, size is " + this.size() + ", requested element is " + index);
        }
    }

    private void maxCapacityCheck(int newSize) {
        if (newSize >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Cannot add element to sequence, max size is violated");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.position.getIntegerValue();
        result = 31 * result + 1237;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.values[i].equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "";
        s = s + this.clazz.getSimpleName();
        s = s + " pos: " + this.position.getIntegerValue();
        s = s + " [";
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + this.values[i].toString();
        }
        s = s + "]";
        return s;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.values[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    private static class DefaultYoVariableAllocator<S>
    implements Supplier<S> {
        private final Constructor<S> constructor;
        private final String prefix;
        private final YoRegistry registry;
        private int index = 0;

        public DefaultYoVariableAllocator(Class<S> clazz, String prefix, YoRegistry registry) {
            this.prefix = prefix;
            this.registry = registry;
            try {
                this.constructor = clazz.getConstructor(String.class, registry.getClass());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find (String, YoRegistry) constructor for class " + clazz.getSimpleName());
            }
        }

        @Override
        public S get() {
            try {
                return this.constructor.newInstance(this.prefix + this.index++, this.registry);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Could not call constructor");
            }
        }
    }
}

