/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;

public class TransferFunction {
    private final ObsoletePolynomial numerator;
    private final ObsoletePolynomial denominator;

    public TransferFunction(double[] numerator, double[] denominator) {
        ObsoletePolynomial numeratorPolynomial = new ObsoletePolynomial(numerator);
        ObsoletePolynomial denominatorPolynomial = new ObsoletePolynomial(denominator);
        double scaleFactor = 1.0 / denominatorPolynomial.getCoefficients()[0];
        this.numerator = numeratorPolynomial.times(scaleFactor);
        this.denominator = denominatorPolynomial.times(scaleFactor);
    }

    public TransferFunction(ObsoletePolynomial numeratorPolynomial, ObsoletePolynomial denominatorPolynomial) {
        double scaleFactor = 1.0 / denominatorPolynomial.getCoefficients()[0];
        this.numerator = numeratorPolynomial.times(scaleFactor);
        this.denominator = denominatorPolynomial.times(scaleFactor);
    }

    public static TransferFunction constructSecondOrderTransferFunction(double zeroFreqMagnitude, double wn, double zeta) {
        double[] numerator = new double[]{zeroFreqMagnitude * wn * wn};
        double[] denominator = new double[]{1.0, 2.0 * zeta * wn, wn * wn};
        return new TransferFunction(numerator, denominator);
    }

    public static TransferFunction constructZeroTransferFunction() {
        return new TransferFunction(new double[]{0.0}, new double[]{1.0});
    }

    public int getOrder() {
        return this.denominator.getOrder();
    }

    public ComplexNumber evaluate(ComplexNumber complexNumber) {
        ComplexNumber evaluateNumerator = this.numerator.evaluate(complexNumber);
        ComplexNumber evaluateDenominator = this.denominator.evaluate(complexNumber);
        ComplexNumber ret = evaluateNumerator.dividedBy(evaluateDenominator);
        return ret;
    }

    public double getMagnitude(double omega) {
        ComplexNumber jOmega = new ComplexNumber(0.0, omega);
        ComplexNumber evaluateNumerator = this.numerator.evaluate(jOmega);
        ComplexNumber evaluateDenominator = this.denominator.evaluate(jOmega);
        return evaluateNumerator.magnitude() / evaluateDenominator.magnitude();
    }

    public double getPhase(double omega) {
        ComplexNumber jOmega = new ComplexNumber(0.0, omega);
        ComplexNumber evaluateNumerator = this.numerator.evaluate(jOmega);
        ComplexNumber evaluateDenominator = this.denominator.evaluate(jOmega);
        return evaluateNumerator.angle() - evaluateDenominator.angle();
    }

    public double[] getMagnitude(double[] omega) {
        double[] magnitudes = new double[omega.length];
        for (int i = 0; i < omega.length; ++i) {
            magnitudes[i] = this.getMagnitude(omega[i]);
        }
        return magnitudes;
    }

    public double[] getPhase(double[] omega) {
        double[] phases = new double[omega.length];
        for (int i = 0; i < omega.length; ++i) {
            phases[i] = this.getPhase(omega[i]);
        }
        return phases;
    }

    public double[] getNumeratorCoefficients() {
        return this.numerator.getCoefficients();
    }

    public double[] getDenominatorCoefficients() {
        return this.denominator.getCoefficients();
    }

    public ObsoletePolynomial getNumeratorPolynomial() {
        return this.numerator;
    }

    public ObsoletePolynomial getDenominatorPolynomial() {
        return this.denominator;
    }

    public TransferFunction plus(double d) {
        return new TransferFunction(this.denominator.times(d).plus(this.numerator), this.denominator);
    }

    public TransferFunction times(double d) {
        ObsoletePolynomial newNumerator = this.numerator.times(d);
        if (newNumerator.equalsZero()) {
            return TransferFunction.constructZeroTransferFunction();
        }
        return new TransferFunction(newNumerator, this.denominator);
    }

    public TransferFunction plus(TransferFunction transferFunction) {
        ObsoletePolynomial otherNumerator = transferFunction.getNumeratorPolynomial();
        ObsoletePolynomial otherDenominator = transferFunction.getDenominatorPolynomial();
        if (this.equalsZero()) {
            return new TransferFunction(transferFunction.numerator, transferFunction.denominator);
        }
        if (transferFunction.equalsZero()) {
            return new TransferFunction(this.numerator, this.denominator);
        }
        if (this.denominator.epsilonEquals(otherDenominator, 1.0E-7)) {
            ObsoletePolynomial newDenominator = this.denominator;
            ObsoletePolynomial newNumerator = this.numerator.plus(otherNumerator);
            return new TransferFunction(newNumerator, newDenominator);
        }
        ObsoletePolynomial newDenominator = this.denominator.times(otherDenominator);
        ObsoletePolynomial newNumerator = this.numerator.times(otherDenominator).plus(otherNumerator.times(this.denominator));
        return new TransferFunction(newNumerator, newDenominator);
    }

    public boolean equalsZero() {
        return this.numerator.equalsZero();
    }

    public TransferFunction times(TransferFunction transferFunction) {
        ObsoletePolynomial otherNumerator = transferFunction.getNumeratorPolynomial();
        ObsoletePolynomial otherDenominator = transferFunction.getDenominatorPolynomial();
        ObsoletePolynomial newNumerator = this.numerator.times(otherNumerator);
        ObsoletePolynomial newDenominator = this.denominator.times(otherDenominator);
        return new TransferFunction(newNumerator, newDenominator);
    }

    public boolean epsilonEquals(TransferFunction transferFunction, double epsilon) {
        if (!this.numerator.epsilonEquals(transferFunction.numerator, epsilon)) {
            return false;
        }
        return this.denominator.epsilonEquals(transferFunction.denominator, epsilon);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.numerator.toString());
        builder.append(")");
        builder.append("/(");
        builder.append(this.denominator.toString());
        builder.append(")");
        return builder.toString();
    }
}

