/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class SingleRealMode {
    private final double eigenvalue;
    private final Matrix leftEigenvectorV;
    private final Matrix rightEigenvectorW;

    public SingleRealMode(ComplexNumber eigenvalue, ComplexNumber[] leftEigenvectorV, ComplexNumber[] rightEigenvectorW) {
        double realEigenvalue = this.verifyRealAndReturnRealPart(eigenvalue);
        double[] realV = this.verifyRealAndReturnRealPart(leftEigenvectorV);
        double[] realW = this.verifyRealAndReturnRealPart(rightEigenvectorW);
        this.verifySameLength(realV, realW);
        this.verifyDotProductEqualsOne(realV, realW);
        if (Math.abs(eigenvalue.imag()) > 1.0E-7) {
            throw new RuntimeException("Eigenvalue must be real!");
        }
        this.eigenvalue = eigenvalue.real();
        this.leftEigenvectorV = this.createSingleColumnMatrix(realV);
        this.rightEigenvectorW = this.createSingleRowMatrix(realW);
    }

    private double[] verifyRealAndReturnRealPart(ComplexNumber[] complexArray) {
        int length = complexArray.length;
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.verifyRealAndReturnRealPart(complexArray[i]);
        }
        return ret;
    }

    private double verifyRealAndReturnRealPart(ComplexNumber complexNumber) {
        if (Math.abs(complexNumber.imag()) > 1.0E-6) {
            throw new RuntimeException("Should only be real for SingleRealMode!. complexNumber = " + complexNumber);
        }
        return complexNumber.real();
    }

    public SingleRealMode(double eigenvalue, double[] leftEigenvectorV, double[] rightEigenvectorW) {
        this.verifySameLength(leftEigenvectorV, rightEigenvectorW);
        this.verifyDotProductEqualsOne(leftEigenvectorV, rightEigenvectorW);
        this.eigenvalue = eigenvalue;
        this.leftEigenvectorV = this.createSingleColumnMatrix(leftEigenvectorV);
        this.rightEigenvectorW = this.createSingleRowMatrix(rightEigenvectorW);
    }

    private void verifySameLength(double[] leftEigenvectorV, double[] rightEigenvectorW) {
        if (leftEigenvectorV.length != rightEigenvectorW.length) {
            throw new IllegalArgumentException("leftEigenvectorV.length != rightEigenvectorW.length");
        }
    }

    private void verifyDotProductEqualsOne(double[] leftEigenvectorV, double[] rightEigenvectorW) {
        double dotProduct = 0.0;
        for (int i = 0; i < leftEigenvectorV.length; ++i) {
            dotProduct += leftEigenvectorV[i] * rightEigenvectorW[i];
        }
        if (Math.abs(dotProduct - 1.0) > 1.0E-7) {
            throw new IllegalArgumentException("leftEigenvectorV.dot(rightEigenvectorW) must be 1.0!");
        }
    }

    private Matrix createSingleColumnMatrix(double[] values) {
        int numRows = values.length;
        Matrix ret = new Matrix(numRows, 1);
        for (int i = 0; i < numRows; ++i) {
            ret.set(i, 0, values[i]);
        }
        return ret;
    }

    private Matrix createSingleRowMatrix(double[] values) {
        int numColumns = values.length;
        Matrix ret = new Matrix(1, numColumns);
        for (int i = 0; i < numColumns; ++i) {
            ret.set(0, i, values[i]);
        }
        return ret;
    }

    public double getEigenvalue() {
        return this.eigenvalue;
    }

    public Matrix getLeftEigenvectorVCopy() {
        int numRows = this.leftEigenvectorV.getRowDimension();
        Matrix ret = new Matrix(numRows, 1);
        this.getLeftEigenvectorV(ret);
        return ret;
    }

    public void getLeftEigenvectorV(Matrix leftEigenvectorToPack) {
        int numRows = this.leftEigenvectorV.getRowDimension();
        for (int i = 0; i < numRows; ++i) {
            leftEigenvectorToPack.set(i, 0, this.leftEigenvectorV.get(i, 0));
        }
    }

    public Matrix getRightEigenvectorWCopy() {
        int numColumns = this.rightEigenvectorW.getColumnDimension();
        Matrix ret = new Matrix(1, numColumns);
        this.getRightEigenvectorW(ret);
        return ret;
    }

    public void getRightEigenvectorW(Matrix rightEigenvectorToPack) {
        int numColumns = this.rightEigenvectorW.getColumnDimension();
        for (int i = 0; i < numColumns; ++i) {
            rightEigenvectorToPack.set(0, i, this.rightEigenvectorW.get(0, i));
        }
    }

    public TransferFunctionMatrix constructTransferFunctionMatrix() {
        Matrix vwT = this.leftEigenvectorV.times(this.rightEigenvectorW);
        double[] denominator = new double[]{1.0, -this.eigenvalue};
        int numRows = vwT.getRowDimension();
        int numColumns = vwT.getColumnDimension();
        TransferFunction[][] transferFunctions = new TransferFunction[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                TransferFunction transferFunction;
                double[] numerator = new double[]{vwT.get(i, j)};
                transferFunctions[i][j] = transferFunction = new TransferFunction(numerator, denominator);
            }
        }
        return new TransferFunctionMatrix(transferFunctions);
    }

    public String toString() {
        return "RealMode: eigenvalue = " + this.eigenvalue;
    }
}

