/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import org.ejml.data.ZMatrixRMaj;
import org.ejml.dense.row.CommonOps_ZDRM;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.ComplexConjugateMode;
import us.ihmc.robotics.linearDynamicSystems.ComplexMatrix;
import us.ihmc.robotics.linearDynamicSystems.ComplexTools;
import us.ihmc.robotics.linearDynamicSystems.SingleRealMode;

public class EigenvalueDecomposer {
    private final Matrix matrixA;
    private final ComplexNumber[] eigenvalues;
    private final boolean[] isEigenvalueComplex;
    private final ComplexNumber[][] leftEigenvectors;
    private final ComplexNumber[][] rightEigenvectors;
    private final ArrayList<SingleRealMode> singleRealModes;
    private final ArrayList<ComplexConjugateMode> complexConjugateModes;

    public EigenvalueDecomposer(Matrix matrixA) {
        this.matrixA = matrixA;
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrixA);
        this.isEigenvalueComplex = new boolean[matrixA.getRowDimension()];
        this.eigenvalues = EigenvalueDecomposer.extractEigenvaluesFromJamaMatrixD(eigenvalueDecomposition.getD(), this.isEigenvalueComplex);
        Matrix matrixV = eigenvalueDecomposition.getV();
        this.leftEigenvectors = EigenvalueDecomposer.extractLeftEigenvectorsFromJamaMatrixV(matrixV, this.isEigenvalueComplex);
        this.rightEigenvectors = EigenvalueDecomposer.extractRightEigenvectorsByInvertingComplexV(this.leftEigenvectors);
        this.singleRealModes = EigenvalueDecomposer.extractRealModes(this.eigenvalues, this.leftEigenvectors, this.rightEigenvectors, this.isEigenvalueComplex);
        this.complexConjugateModes = EigenvalueDecomposer.extractComplexConjugateModes(this.eigenvalues, this.leftEigenvectors, this.rightEigenvectors, this.isEigenvalueComplex);
    }

    private static ArrayList<ComplexConjugateMode> extractComplexConjugateModes(ComplexNumber[] eigenvalues, ComplexNumber[][] leftEigenvectors, ComplexNumber[][] rightEigenvectors, boolean[] isEigenvalueComplex) {
        int order = eigenvalues.length;
        int index = 0;
        ArrayList<ComplexConjugateMode> ret = new ArrayList<ComplexConjugateMode>();
        while (index < order) {
            if (isEigenvalueComplex[index]) {
                ret.add(new ComplexConjugateMode(eigenvalues[index], leftEigenvectors[index], rightEigenvectors[index]));
                ++index;
                ++index;
                continue;
            }
            ++index;
        }
        return ret;
    }

    private static ArrayList<SingleRealMode> extractRealModes(ComplexNumber[] eigenvalues, ComplexNumber[][] leftEigenvectors, ComplexNumber[][] rightEigenvectors, boolean[] isEigenvalueComplex) {
        int order = eigenvalues.length;
        int index = 0;
        ArrayList<SingleRealMode> ret = new ArrayList<SingleRealMode>();
        while (index < order) {
            if (isEigenvalueComplex[index]) {
                ++index;
                continue;
            }
            ret.add(new SingleRealMode(eigenvalues[index], leftEigenvectors[index], rightEigenvectors[index]));
            ++index;
        }
        return ret;
    }

    private static ComplexNumber[][] extractRightEigenvectorsByInvertingComplexV(ComplexNumber[][] leftEigenvectors) {
        int order = leftEigenvectors.length;
        ComplexMatrix ihmcComplexV = new ComplexMatrix(order, order);
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                ihmcComplexV.set(i, j, leftEigenvectors[j][i]);
            }
        }
        ZMatrixRMaj ejmlComplexV = ComplexTools.ihmcComplexToEjmlComplex(ihmcComplexV);
        if (!CommonOps_ZDRM.invert((ZMatrixRMaj)ejmlComplexV)) {
            throw new RuntimeException("Complex matrix inversion failed");
        }
        return ComplexTools.copyEjmlComplexIntoIhmcComplexNumber2dArray(ejmlComplexV);
    }

    private static ComplexNumber[][] extractLeftEigenvectorsFromJamaMatrixV(Matrix matrixV, boolean[] isEigenvalueComplex) {
        int order = matrixV.getRowDimension();
        ComplexNumber[][] ret = new ComplexNumber[order][order];
        int index = 0;
        while (index < order) {
            if (isEigenvalueComplex[index]) {
                ComplexNumber[][] twoComplexEigenvectors = EigenvalueDecomposer.extractTwoComplexLeftEigenvectors(matrixV, index, isEigenvalueComplex);
                ret[index] = twoComplexEigenvectors[0];
                ret[++index] = twoComplexEigenvectors[1];
                ++index;
                continue;
            }
            ComplexNumber[] realEigenvector = EigenvalueDecomposer.extractRealLeftEigenvector(matrixV, index);
            ret[index] = realEigenvector;
            ++index;
        }
        return ret;
    }

    private static ComplexNumber[] extractRealLeftEigenvector(Matrix matrix, int index) {
        int order = matrix.getRowDimension();
        ComplexNumber[] ret = new ComplexNumber[order];
        for (int i = 0; i < order; ++i) {
            ret[i] = new ComplexNumber(matrix.get(i, index), 0.0);
        }
        return ret;
    }

    private static ComplexNumber[][] extractTwoComplexLeftEigenvectors(Matrix matrix, int column, boolean[] isEigenvalueComplex) {
        int order = matrix.getRowDimension();
        ComplexNumber[][] ret = new ComplexNumber[2][order];
        for (int index = 0; index < order; ++index) {
            ComplexNumber complexNumber;
            ret[0][index] = complexNumber = new ComplexNumber(matrix.get(index, column), matrix.get(index, column + 1));
            ret[1][index] = complexNumber.conj();
        }
        return ret;
    }

    private static ComplexNumber[] extractEigenvaluesFromJamaMatrixD(Matrix matrixD, boolean[] packIsEigenvalueComplex) {
        int order = matrixD.getRowDimension();
        ComplexNumber[] ret = new ComplexNumber[order];
        int index = 0;
        while (index < order) {
            boolean isReal;
            if (index == order - 1) {
                isReal = true;
            } else {
                boolean bl = isReal = matrixD.get(index, index + 1) == 0.0;
            }
            if (isReal) {
                packIsEigenvalueComplex[index] = false;
                ret[index] = new ComplexNumber(matrixD.get(index, index), 0.0);
                ++index;
                continue;
            }
            ComplexNumber[] twoComplexEigenvalues = EigenvalueDecomposer.extractTwoJamaRepresentedComplexNumbers(matrixD, index, index);
            packIsEigenvalueComplex[index] = true;
            ret[index] = twoComplexEigenvalues[0];
            packIsEigenvalueComplex[++index] = true;
            ret[index] = twoComplexEigenvalues[1];
            ++index;
        }
        return ret;
    }

    private static ComplexNumber[] extractTwoJamaRepresentedComplexNumbers(Matrix matrix, int i, int j) {
        double realOne = matrix.get(i, j);
        double imagOne = matrix.get(i, j + 1);
        double imagTwo = matrix.get(i + 1, j);
        double realTwo = matrix.get(i + 1, j + 1);
        ComplexNumber complexOne = new ComplexNumber(realOne, imagOne);
        ComplexNumber complexTwo = new ComplexNumber(realTwo, imagTwo);
        return new ComplexNumber[]{complexOne, complexTwo};
    }

    public ComplexNumber[] getEigenvalues() {
        return this.eigenvalues;
    }

    public ComplexNumber[][] getLeftEigenvectors() {
        return this.leftEigenvectors;
    }

    public ComplexNumber[][] getRightEigenvectors() {
        return this.rightEigenvectors;
    }

    public ArrayList<SingleRealMode> getRealModes() {
        return this.singleRealModes;
    }

    public ArrayList<ComplexConjugateMode> getComplexConjugateModes() {
        return this.complexConjugateModes;
    }
}

