/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import org.ejml.data.Complex_F64;
import org.ejml.data.ZMatrixRMaj;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.ComplexMatrix;

public class ComplexTools {
    public static ZMatrixRMaj ihmcComplexToEjmlComplex(ComplexMatrix ihmc) {
        ZMatrixRMaj ret = new ZMatrixRMaj(ihmc.getRowDimension(), ihmc.getColumnDimension());
        for (int i = 0; i < ret.numRows; ++i) {
            for (int j = 0; j < ret.numCols; ++j) {
                ComplexNumber c = ihmc.get(i, j);
                ret.set(i, j, c.real(), c.imag());
            }
        }
        return ret;
    }

    public static ComplexMatrix ejmlToIhmComplex(ZMatrixRMaj ejml) {
        ComplexMatrix ihmc = new ComplexMatrix(ejml.numRows, ejml.numCols);
        Complex_F64 c = new Complex_F64();
        for (int i = 0; i < ejml.numRows; ++i) {
            for (int j = 0; j < ejml.numCols; ++j) {
                ejml.get(i, j, c);
                ihmc.set(i, j, new ComplexNumber(c.getReal(), c.getImaginary()));
            }
        }
        return ihmc;
    }

    public static ComplexNumber[][] copyEjmlComplexIntoIhmcComplexNumber2dArray(ZMatrixRMaj ejml) {
        ComplexNumber[][] ihmcComplexNumber2dArray = new ComplexNumber[ejml.getNumRows()][ejml.getNumCols()];
        Complex_F64 c = new Complex_F64();
        for (int i = 0; i < ejml.getNumRows(); ++i) {
            for (int j = 0; j < ejml.getNumCols(); ++j) {
                ejml.get(i, j, c);
                ihmcComplexNumber2dArray[i][j] = new ComplexNumber(c.getReal(), c.getImaginary());
            }
        }
        return ihmcComplexNumber2dArray;
    }
}

