/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import org.ejml.data.ZMatrixRMaj;
import org.ejml.dense.row.CommonOps_ZDRM;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.ComplexTools;

public class ComplexMatrix {
    private final ComplexNumber[][] elements;

    public ComplexMatrix(int numRows, int numColumns) {
        this.elements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                this.elements[i][j] = new ComplexNumber(0.0, 0.0);
            }
        }
    }

    public ComplexMatrix(double[][][] elements) {
        int numRows = elements.length;
        int numColumns = elements[0].length;
        this.elements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                this.set(i, j, new ComplexNumber(elements[i][j][0], elements[i][j][1]));
            }
        }
    }

    public ComplexMatrix(ComplexNumber[][] elements) {
        int numRows = elements.length;
        int numColumns = elements[0].length;
        this.elements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ComplexNumber complexNumber = elements[i][j];
                if (complexNumber == null) {
                    complexNumber = new ComplexNumber(0.0, 0.0);
                }
                this.elements[i][j] = elements[i][j];
            }
        }
    }

    public static ComplexMatrix constructDiagonalMatrix(ComplexNumber[] diagonalElements) {
        int length = diagonalElements.length;
        ComplexMatrix ret = ComplexMatrix.constructZeros(length);
        for (int i = 0; i < length; ++i) {
            ret.set(i, i, new ComplexNumber(diagonalElements[i]));
        }
        return ret;
    }

    public static ComplexMatrix constructIdentity(int length) {
        ComplexMatrix ret = new ComplexMatrix(length, length);
        for (int i = 0; i < length; ++i) {
            ret.set(i, i, new ComplexNumber(1.0, 0.0));
        }
        return ret;
    }

    public static ComplexMatrix constructZeros(int length) {
        ComplexMatrix ret = new ComplexMatrix(length, length);
        for (int i = 0; i < length; ++i) {
            ret.set(i, i, new ComplexNumber(0.0, 0.0));
        }
        return ret;
    }

    public void set(int row, int column, ComplexNumber complexNumber) {
        this.elements[row][column] = complexNumber;
    }

    public ComplexNumber get(int row, int column) {
        return this.elements[row][column];
    }

    public ComplexMatrix inverse() {
        if (this.getRowDimension() != this.getColumnDimension()) {
            throw new RuntimeException("Can only call inverse on square, invertible matrices!");
        }
        ZMatrixRMaj ejmlMatrix = ComplexTools.ihmcComplexToEjmlComplex(this);
        CommonOps_ZDRM.invert((ZMatrixRMaj)ejmlMatrix);
        return ComplexTools.ejmlToIhmComplex(ejmlMatrix);
    }

    public ComplexMatrix times(ComplexNumber complexNumber) {
        int numRows = this.getRowDimension();
        int numColumns = this.getColumnDimension();
        ComplexNumber[][] newElements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                newElements[i][j] = this.elements[i][j].times(complexNumber);
            }
        }
        return new ComplexMatrix(newElements);
    }

    public ComplexMatrix times(double timesBy) {
        int numRows = this.getRowDimension();
        int numColumns = this.getColumnDimension();
        ComplexNumber[][] newElements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                newElements[i][j] = this.elements[i][j].times(timesBy);
            }
        }
        return new ComplexMatrix(newElements);
    }

    public ComplexMatrix minus(Matrix matrixA) {
        int numRows = this.getRowDimension();
        int numColumns = this.getColumnDimension();
        ComplexNumber[][] newElements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                newElements[i][j] = this.elements[i][j].minus(matrixA.get(i, j));
            }
        }
        return new ComplexMatrix(newElements);
    }

    public ComplexMatrix times(ComplexMatrix complexMatrix) {
        int numRows = this.getRowDimension();
        int numColumns = complexMatrix.getColumnDimension();
        int innerDimension = this.getColumnDimension();
        if (innerDimension != complexMatrix.getRowDimension()) {
            throw new RuntimeException("ComplexMatrix.times() called with two matrices with differing inner dimenstions!");
        }
        ComplexNumber[][] newElements = new ComplexNumber[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                newElements[i][j] = new ComplexNumber(0.0, 0.0);
                for (int k = 0; k < innerDimension; ++k) {
                    newElements[i][j] = newElements[i][j].plus(this.get(i, k).times(complexMatrix.get(k, j)));
                }
            }
        }
        return new ComplexMatrix(newElements);
    }

    public ComplexMatrix transpose() {
        int numColumns = this.getColumnDimension();
        int numRows = this.getRowDimension();
        ComplexNumber[][] newElements = new ComplexNumber[numColumns][numRows];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                newElements[j][i] = new ComplexNumber(this.elements[i][j].real(), this.elements[i][j].imag());
            }
        }
        return new ComplexMatrix(newElements);
    }

    public boolean epsilonEquals(ComplexMatrix complexMatrix, double epsilon) {
        int numRows = complexMatrix.getRowDimension();
        int numColumns = complexMatrix.getColumnDimension();
        if (this.getRowDimension() != numRows) {
            return false;
        }
        if (this.getColumnDimension() != numColumns) {
            return false;
        }
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                ComplexNumber otherComplexNumber;
                ComplexNumber thisComplexNumber = this.get(i, j);
                if (thisComplexNumber.epsilonEquals(otherComplexNumber = complexMatrix.get(i, j), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean epsilonEquals(Matrix matrix, double epsilon) {
        int numRows = matrix.getRowDimension();
        int numColumns = matrix.getColumnDimension();
        if (this.getRowDimension() != numRows) {
            return false;
        }
        if (this.getColumnDimension() != numColumns) {
            return false;
        }
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                if (this.get(i, j).epsilonEquals(matrix.get(i, j), epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public int getRowDimension() {
        return this.elements.length;
    }

    public int getColumnDimension() {
        return this.elements[0].length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < this.elements[i].length; ++j) {
                builder.append(this.elements[i][j]);
                if (j >= this.elements[i].length - 1) continue;
                builder.append(", ");
            }
            builder.append("\n");
        }
        builder.append("\n");
        return builder.toString();
    }
}

