/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers.signFunction;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixToolsLocal;
import us.ihmc.robotics.linearAlgebra.careSolvers.signFunction.SignFunction;

public class QuadraticSignFunction
implements SignFunction {
    private int maxIterations = Integer.MAX_VALUE;
    private double epsilon = 1.0E-12;
    private final DMatrixRMaj Wprev = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj W = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj ZInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Z = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj ZDiff = new DMatrixRMaj(0, 0);

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setConvergenceEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean compute(DMatrixRMaj K) {
        int size = K.getNumRows();
        this.Wprev.set((DMatrixD1)K);
        this.W.reshape(size, size);
        this.Z.reshape(size, size);
        this.ZInverse.reshape(size, size);
        this.ZDiff.reshape(size, size);
        boolean converged = false;
        int iterations = 0;
        while (!converged) {
            if (iterations > this.maxIterations) {
                return false;
            }
            double determinate = CommonOps_DDRM.det((DMatrixRMaj)this.Wprev);
            double c = Math.pow(Math.abs(determinate), -1.0 / (double)(2 * size));
            this.Z.set((DMatrixD1)this.Wprev);
            CommonOps_DDRM.scale((double)c, (DMatrixD1)this.Z);
            NativeCommonOps.invert((DMatrix1Row)this.Z, (DMatrix1Row)this.ZInverse);
            CommonOps_DDRM.subtract((DMatrixD1)this.Z, (DMatrixD1)this.ZInverse, (DMatrixD1)this.ZDiff);
            CommonOps_DDRM.add((DMatrixD1)this.Z, (double)-0.5, (DMatrixD1)this.ZDiff, (DMatrixD1)this.W);
            converged = MatrixToolsLocal.distance(this.W, this.Wprev) < this.epsilon;
            this.Wprev.set((DMatrixD1)this.W);
            ++iterations;
        }
        return true;
    }

    @Override
    public DMatrixRMaj getW(DMatrixRMaj WToPack) {
        if (WToPack != null) {
            WToPack.set((DMatrixD1)this.W);
            return null;
        }
        return new DMatrixRMaj(this.W);
    }
}

